/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.SignerFactory;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.transfer.Download;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.amazonaws.services.s3.transfer.Upload;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.snowflake.client.core.HeaderCustomizerHttpRequestInterceptor;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.jdbc.HttpHeadersCustomizer;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.cloud.storage.AwsSdkGCPSigner;
import net.snowflake.client.jdbc.cloud.storage.GCSAccessStrategy;
import net.snowflake.client.jdbc.cloud.storage.S3HttpUtil;
import net.snowflake.client.jdbc.cloud.storage.S3ObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeGCSClient;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeS3Client;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.client.jdbc.cloud.storage.StorageHelper;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectSummaryCollection;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.SFPair;
import org.apache.http.conn.socket.ConnectionSocketFactory;

class GCSAccessStrategyAwsSdk
implements GCSAccessStrategy {
    private static final SFLogger logger = SFLoggerFactory.getLogger(GCSAccessStrategyAwsSdk.class);
    private final AmazonS3 amazonClient;

    GCSAccessStrategyAwsSdk(StageInfo stage, SFBaseSession session) throws SnowflakeSQLException {
        List<HttpHeadersCustomizer> headersCustomizers;
        String accessToken = (String)stage.getCredentials().get("GCS_ACCESS_TOKEN");
        Optional<String> oEndpoint = stage.gcsCustomEndpoint();
        String endpoint = "storage.googleapis.com";
        if (oEndpoint.isPresent()) {
            endpoint = oEndpoint.get();
        }
        if (endpoint.startsWith("https://")) {
            endpoint = endpoint.replaceFirst("https://", "");
        }
        if (stage.getStorageAccount() != null && endpoint.startsWith(stage.getStorageAccount())) {
            endpoint = endpoint.replaceFirst(stage.getStorageAccount() + ".", "");
        }
        AmazonS3ClientBuilder amazonS3Builder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withPathStyleAccessEnabled(Boolean.valueOf(false))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, "auto"));
        ClientConfiguration clientConfig = new ClientConfiguration();
        SignerFactory.registerSigner((String)"net.snowflake.client.jdbc.cloud.storage.AwsSdkGCPSigner", AwsSdkGCPSigner.class);
        clientConfig.setSignerOverride("net.snowflake.client.jdbc.cloud.storage.AwsSdkGCPSigner");
        clientConfig.getApacheHttpClientConfig().setSslSocketFactory((ConnectionSocketFactory)SnowflakeS3Client.getSSLConnectionSocketFactory());
        if (session != null) {
            S3HttpUtil.setProxyForS3(session.getHttpClientKey(), clientConfig);
        } else {
            S3HttpUtil.setSessionlessProxyForS3(stage.getProxyProperties(), clientConfig);
        }
        if (session instanceof SFSession && (headersCustomizers = ((SFSession)session).getHttpHeadersCustomizers()) != null && !headersCustomizers.isEmpty()) {
            amazonS3Builder.withRequestHandlers(new RequestHandler2[]{new HeaderCustomizerHttpRequestInterceptor(headersCustomizers)});
        }
        if (accessToken != null) {
            amazonS3Builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(accessToken, "")));
        } else {
            logger.debug("no credentials provided, configuring bucket client without credentials", new Object[0]);
            amazonS3Builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials("", "")));
        }
        this.amazonClient = (AmazonS3)((AmazonS3ClientBuilder)amazonS3Builder.withClientConfiguration(clientConfig)).build();
    }

    @Override
    public StorageObjectSummaryCollection listObjects(String remoteStorageLocation, String prefix) {
        ObjectListing objListing = this.amazonClient.listObjects(remoteStorageLocation, prefix);
        return new StorageObjectSummaryCollection(objListing.getObjectSummaries());
    }

    @Override
    public StorageObjectMetadata getObjectMetadata(String remoteStorageLocation, String prefix) {
        ObjectMetadata meta = this.amazonClient.getObjectMetadata(remoteStorageLocation, prefix);
        Map<String, String> userMetadata = meta.getRawMetadata().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("x-goog-meta-")).collect(Collectors.toMap(e -> ((String)e.getKey()).replaceFirst("x-goog-meta-", ""), e -> e.getValue().toString()));
        meta.setUserMetadata(userMetadata);
        return new S3ObjectMetadata(meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> download(int parallelism, String remoteStorageLocation, String stageFilePath, File localFile) throws InterruptedException {
        logger.debug("Staring download of file from S3 stage path: {} to {}", stageFilePath, localFile.getAbsolutePath());
        TransferManager tx = null;
        logger.debug("Creating executor service for transfer manager with {} threads", parallelism);
        try {
            tx = TransferManagerBuilder.standard().withS3Client(this.amazonClient).withDisableParallelDownloads(Boolean.valueOf(true)).withExecutorFactory(() -> SnowflakeUtil.createDefaultExecutorService("s3-transfer-manager-downloader-", parallelism)).build();
            Download myDownload = tx.download(remoteStorageLocation, stageFilePath, localFile);
            StorageObjectMetadata meta = this.getObjectMetadata(remoteStorageLocation, stageFilePath);
            Map<String, String> metaMap = SnowflakeUtil.createCaseInsensitiveMap(meta.getUserMetadata());
            myDownload.waitForCompletion();
            Map<String, String> map = metaMap;
            return map;
        }
        finally {
            if (tx != null) {
                tx.shutdownNow(false);
            }
        }
    }

    @Override
    public SFPair<InputStream, Map<String, String>> downloadToStream(String remoteStorageLocation, String stageFilePath, boolean isEncrypting) {
        S3Object file = this.amazonClient.getObject(remoteStorageLocation, stageFilePath);
        ObjectMetadata meta = this.amazonClient.getObjectMetadata(remoteStorageLocation, stageFilePath);
        S3ObjectInputStream stream = file.getObjectContent();
        Map<String, String> metaMap = SnowflakeUtil.createCaseInsensitiveMap(meta.getUserMetadata());
        return SFPair.of(stream, metaMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uploadWithDownScopedToken(int parallelism, String remoteStorageLocation, String destFileName, String contentEncoding, Map<String, String> metadata, long contentLength, InputStream content, String queryId) throws InterruptedException {
        ObjectMetadata s3Meta = new ObjectMetadata();
        if (contentEncoding != null) {
            s3Meta.setContentEncoding(contentEncoding);
        }
        s3Meta.setContentLength(contentLength);
        s3Meta.setUserMetadata(metadata);
        TransferManager tx = null;
        logger.debug("Creating executor service for transfer manager with {} threads", parallelism);
        try {
            tx = TransferManagerBuilder.standard().withS3Client(this.amazonClient).withExecutorFactory(() -> SnowflakeUtil.createDefaultExecutorService("s3-transfer-manager-uploader-", parallelism)).build();
            Upload myUpload = tx.upload(remoteStorageLocation, destFileName, content, s3Meta);
            myUpload.waitForCompletion();
            logger.info("Uploaded data from input stream to S3 location: {}.", destFileName);
        }
        finally {
            if (tx != null) {
                tx.shutdownNow(false);
            }
        }
    }

    private static boolean isClientException400Or404(Exception ex) {
        if (ex instanceof AmazonServiceException) {
            AmazonServiceException asEx = (AmazonServiceException)ex;
            return asEx.getStatusCode() == 404 || asEx.getStatusCode() == 400;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean handleStorageException(Exception ex, int retryCount, String operation, SFSession session, String command, String queryId, SnowflakeGCSClient gcsClient) throws SnowflakeSQLException {
        AmazonS3Exception s3ex;
        if (!(ex instanceof AmazonClientException)) return false;
        logger.debug("GCSAccessStrategyAwsSdk: " + ex.getMessage(), new Object[0]);
        if (retryCount > gcsClient.getMaxRetries() || GCSAccessStrategyAwsSdk.isClientException400Or404(ex)) {
            AmazonS3Exception ex1;
            String extendedRequestId = "none";
            if (ex instanceof AmazonS3Exception) {
                ex1 = (AmazonS3Exception)ex;
                extendedRequestId = ex1.getExtendedRequestId();
            }
            if (!(ex instanceof AmazonServiceException)) throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, "58000", (int)StorageHelper.getOperationException(operation).getMessageCode(), ex, operation, ex.getMessage());
            ex1 = (AmazonServiceException)ex;
            if (ex1.getStatusCode() != 400 || session == null) throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, "58000", (int)StorageHelper.getOperationException(operation).getMessageCode(), (Throwable)ex1, operation, ex1.getErrorType().toString(), ex1.getErrorCode(), ex1.getMessage(), ex1.getRequestId(), extendedRequestId);
            SnowflakeFileTransferAgent.renewExpiredToken(session, command, gcsClient);
            return true;
        }
        logger.debug("Encountered exception ({}) during {}, retry count: {}", ex.getMessage(), operation, retryCount);
        logger.debug("Stack trace: ", ex);
        int backoffInMillis = gcsClient.getRetryBackoffMin();
        if (retryCount > 1) {
            backoffInMillis <<= Math.min(retryCount - 1, gcsClient.getRetryBackoffMaxExponent());
        }
        try {
            logger.debug("Sleep for {} milliseconds before retry", backoffInMillis);
            Thread.sleep(backoffInMillis);
        }
        catch (InterruptedException ex1) {
            // empty catch block
        }
        if (!(ex instanceof AmazonS3Exception) || !(s3ex = (AmazonS3Exception)ex).getErrorCode().equalsIgnoreCase("ExpiredToken")) return true;
        if (session == null) throw new SnowflakeSQLException(queryId, s3ex.getErrorCode(), 240001, "S3 credentials have expired");
        SnowflakeFileTransferAgent.renewExpiredToken(session, command, gcsClient);
        return true;
    }

    @Override
    public void shutdown() {
        if (this.amazonClient != null) {
            this.amazonClient.shutdown();
        }
    }
}

