/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import com.google.api.gax.paging.Page;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.HttpStorageOptions;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import java.io.File;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Map;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.cloud.storage.CommonObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.GCSAccessStrategy;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeGCSClient;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.client.jdbc.cloud.storage.StorageHelper;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectSummaryCollection;
import net.snowflake.client.jdbc.cloud.storage.StorageProviderException;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.SFPair;

class GCSDefaultAccessStrategy
implements GCSAccessStrategy {
    private static final SFLogger logger = SFLoggerFactory.getLogger(GCSDefaultAccessStrategy.class);
    private Storage gcsClient = null;

    GCSDefaultAccessStrategy(StageInfo stage, SFSession session) {
        String accessToken = (String)stage.getCredentials().get("GCS_ACCESS_TOKEN");
        if (accessToken != null) {
            StorageOptions.Builder builder = StorageOptions.newBuilder();
            GCSDefaultAccessStrategy.overrideHost(stage, builder);
            if (SnowflakeGCSClient.areDisabledGcsDefaultCredentials(session)) {
                logger.debug("Adding explicit credentials to avoid default credential lookup by the GCS client", new Object[0]);
                builder.setCredentials((Credentials)GoogleCredentials.create((AccessToken)new AccessToken(accessToken, null)));
            }
            this.gcsClient = (Storage)((StorageOptions.Builder)builder.setHeaderProvider((HeaderProvider)FixedHeaderProvider.create((String[])new String[]{"Authorization", "Bearer " + accessToken}))).build().getService();
        } else {
            HttpStorageOptions.Builder builder = HttpStorageOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance());
            GCSDefaultAccessStrategy.overrideHost(stage, (StorageOptions.Builder)builder);
            this.gcsClient = (Storage)builder.build().getService();
        }
    }

    private static void overrideHost(StageInfo stage, StorageOptions.Builder builder) {
        stage.gcsCustomEndpoint().ifPresent(host -> {
            if (host.startsWith("https://")) {
                builder.setHost(host);
            } else {
                builder.setHost("https://" + host);
            }
        });
    }

    @Override
    public StorageObjectSummaryCollection listObjects(String remoteStorageLocation, String prefix) {
        try {
            logger.debug("Listing objects in the bucket {} with prefix {}", remoteStorageLocation, prefix);
            Page blobs = this.gcsClient.list(remoteStorageLocation, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)prefix)});
            return new StorageObjectSummaryCollection((Page<Blob>)blobs);
        }
        catch (Exception e) {
            logger.debug("Failed to list objects", false);
            throw new StorageProviderException(e);
        }
    }

    @Override
    public StorageObjectMetadata getObjectMetadata(String remoteStorageLocation, String prefix) {
        try {
            BlobId blobId = BlobId.of((String)remoteStorageLocation, (String)prefix);
            Blob blob = this.gcsClient.get(blobId);
            if (blob == null) {
                throw new StorageProviderException((Exception)((Object)new StorageException(404, "Blob" + blobId.getName() + " not found in bucket " + blobId.getBucket())));
            }
            return new CommonObjectMetadata(blob.getSize(), blob.getContentEncoding(), blob.getMetadata());
        }
        catch (StorageException ex) {
            throw new StorageProviderException((Exception)((Object)ex));
        }
    }

    @Override
    public Map<String, String> download(int parallelism, String remoteStorageLocation, String stageFilePath, File localFile) {
        BlobId blobId = BlobId.of((String)remoteStorageLocation, (String)stageFilePath);
        Blob blob = this.gcsClient.get(blobId);
        if (blob == null) {
            throw new StorageProviderException((Exception)((Object)new StorageException(404, "Blob" + blobId.getName() + " not found in bucket " + blobId.getBucket())));
        }
        logger.debug("Starting download without presigned URL", false);
        blob.downloadTo(localFile.toPath(), new Blob.BlobSourceOption[]{Blob.BlobSourceOption.shouldReturnRawInputStream((boolean)true)});
        return SnowflakeUtil.createCaseInsensitiveMap(blob.getMetadata());
    }

    @Override
    public SFPair<InputStream, Map<String, String>> downloadToStream(String remoteStorageLocation, String stageFilePath, boolean isEncrypting) {
        BlobId blobId = BlobId.of((String)remoteStorageLocation, (String)stageFilePath);
        Blob blob = this.gcsClient.get(blobId);
        if (blob == null) {
            throw new StorageProviderException((Exception)((Object)new StorageException(404, "Blob" + blobId.getName() + " not found in bucket " + blobId.getBucket())));
        }
        InputStream inputStream = Channels.newInputStream((ReadableByteChannel)blob.reader(new Blob.BlobSourceOption[0]));
        Map<String, String> userDefinedMetadata = null;
        if (isEncrypting) {
            userDefinedMetadata = SnowflakeUtil.createCaseInsensitiveMap(blob.getMetadata());
        }
        return SFPair.of(inputStream, userDefinedMetadata);
    }

    @Override
    public void uploadWithDownScopedToken(int parallelism, String remoteStorageLocation, String destFileName, String contentEncoding, Map<String, String> metadata, long contentLength, InputStream content, String queryId) {
        BlobId blobId = BlobId.of((String)remoteStorageLocation, (String)destFileName);
        BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)blobId).setContentEncoding(contentEncoding).setMetadata(metadata).build();
        this.gcsClient.create(blobInfo, content, new Storage.BlobWriteOption[0]);
    }

    @Override
    public boolean handleStorageException(Exception ex, int retryCount, String operation, SFSession session, String command, String queryId, SnowflakeGCSClient gcsClient) throws SnowflakeSQLException {
        if (ex instanceof StorageException) {
            StorageException se = (StorageException)((Object)ex);
            if (retryCount > gcsClient.getMaxRetries()) {
                throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, "58000", (int)StorageHelper.getOperationException(operation).getMessageCode(), se, operation, se.getCode(), se.getMessage(), se.getReason());
            }
            logger.debug("Encountered exception ({}) during {}, retry count: {}", ex.getMessage(), operation, retryCount);
            logger.debug("Stack trace: ", ex);
            int backoffInMillis = gcsClient.getRetryBackoffMin();
            if (retryCount > 1) {
                backoffInMillis <<= Math.min(retryCount - 1, gcsClient.getRetryBackoffMaxExponent());
            }
            try {
                logger.debug("Sleep for {} milliseconds before retry", backoffInMillis);
                Thread.sleep(backoffInMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (se.getCode() == 401 && command != null) {
                if (session != null) {
                    SnowflakeFileTransferAgent.renewExpiredToken(session, command, gcsClient);
                } else {
                    throw new SnowflakeSQLException(queryId, se.getMessage(), 240001, "GCS credentials have expired");
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void shutdown() {
    }
}

