/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.util;

import java.util.concurrent.ThreadLocalRandom;

public class DecorrelatedJitterBackoff {
    private final long base;
    private final long cap;

    public DecorrelatedJitterBackoff(long base, long cap) {
        this.base = base;
        this.cap = cap;
    }

    public long nextSleepTime(long sleep) {
        long correctedSleep = sleep <= this.base ? this.base + 1L : sleep;
        return Math.min(this.cap, ThreadLocalRandom.current().nextLong(this.base, correctedSleep));
    }

    public long getJitterForLogin(long currentTime) {
        double multiplicationFactor = this.chooseRandom(-1.0, 1.0);
        long jitter = (long)(multiplicationFactor * (double)currentTime * 0.5);
        return jitter;
    }

    public double chooseRandom(double min, double max) {
        return min + Math.random() * (max - min);
    }
}

