/*
 * Copyright (c) 2012-2016 Snowflake Computing Inc. All right reserved.
 */

package net.snowflake.client.core;

import net.snowflake.client.jdbc.ErrorCode;
import com.snowflake.gscommon.core.ResourceBundleManager;

import java.util.logging.Logger;

/**
 * Created by jhuang on 1/5/16.
 */
public class SFException extends Throwable
{
  static final Logger logger = Logger.getLogger(SFException.class.getName());

  static final ResourceBundleManager errorResourceBundleManager =
      ResourceBundleManager.getSingleton(ErrorCode.errorMessageResource);

  private Throwable cause;
  private String queryId;
  private String sqlState;
  private int vendorCode;
  private Object[] params;

  public SFException(ErrorCode errorCode,
                     Object... params)
  {
    super(errorResourceBundleManager.getLocalizedMessage(
        String.valueOf(errorCode.getMessageCode()), params));

    this.cause = null;
    this.queryId = null;
    this.sqlState = errorCode.getSqlState();
    this.vendorCode = errorCode.getMessageCode();
    this.params = params;
  }

  public SFException(Throwable cause,
                     ErrorCode errorCode,
                     Object... params)
  {
    super(errorResourceBundleManager.getLocalizedMessage(
        String.valueOf(errorCode.getMessageCode()), params), cause);

    this.cause = null;
    this.queryId = null;
    this.sqlState = errorCode.getSqlState();
    this.vendorCode = errorCode.getMessageCode();
    this.params = params;
  }

  public Throwable getCause()
  {
    return cause;
  }

  public String getQueryId()
  {
    return queryId;
  }

  public String getSqlState()
  {
    return sqlState;
  }

  public int getVendorCode()
  {
    return vendorCode;
  }

  public Object[] getParams()
  {
    return params;
  }

  @Override
  public String toString()
  {
    return super.toString() +
        (getQueryId() != null ? ", query id = " + getQueryId() : "") +
        (getSqlState() != null ? ", sql state = " + getSqlState() : "");
  }
}
