/*
 * Copyright (c) 2012-2016 Snowflake Computing Inc. All right reserved.
 */

package net.snowflake.client.jdbc;

import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author jhuang
 */
public class SnowflakeSQLFeatureNotSupportedException
extends SQLFeatureNotSupportedException
{
  static final Logger logger = Logger.getLogger(
                      SnowflakeSQLFeatureNotSupportedException.class.getName());

  public SnowflakeSQLFeatureNotSupportedException()
  {
    super();

    logger.log(Level.WARNING,
               "Snowflake exception: SQL Feature not supported by Snowflake. ");

  }

  public SnowflakeSQLFeatureNotSupportedException(String reason)
  {
    super();

    logger.log(Level.WARNING,
               "Snowflake exception: SQL Feature not supported by Snowflake. "
               + reason);
  }
}
