/*
 * Copyright (c) 2012-2016 Snowflake Computing Inc. All right reserved.
 */

package net.snowflake.client.jdbc;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Snowflake Loader exception for Test. This should only be valid in tests.
 */
public class SnowflakeSimulatedUploadFailure extends RuntimeException
{

  static final Logger logger = Logger.getLogger(
          SnowflakeSimulatedUploadFailure.class.getName());

  public SnowflakeSimulatedUploadFailure()
  {
    super();
    logger.log(Level.SEVERE, "This constructor should not be used.");
  }

  public SnowflakeSimulatedUploadFailure(String filename)
  {
    super("Simulated upload failure for " + filename);

    logger.log(Level.INFO, this.getMessage()
                           + ". This should show up only in tests.");

  }

}
