/*
 * Copyright (c) 2012-2016 Snowflake Computing Inc. All right reserved.
 */

package net.snowflake.client.loader;

import java.sql.Connection;
import java.util.Map;
import java.util.logging.Logger;
import java.util.logging.Level;

public class LoaderFactory
{
  private static final Logger LOGGER = Logger.getLogger(
          LoaderFactory.class.getName());
  public static Loader createLoader(Map<LoaderProperty, Object> properties,
                                    Connection uploadConnection,
                                    Connection processingConnection)
  {
      LOGGER.log(Level.FINER, "");
      StreamLoader loader = new StreamLoader(properties, uploadConnection,
              processingConnection);
      return loader;
  }

}
