/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import net.snowflake.client.core.Constants;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFLoginInput;
import net.snowflake.client.core.SFLoginOutput;
import net.snowflake.client.core.SecureStorageAppleManager;
import net.snowflake.client.core.SecureStorageLinuxManager;
import net.snowflake.client.core.SecureStorageManager;
import net.snowflake.client.core.SecureStorageWindowsManager;
import net.snowflake.client.jdbc.internal.google.common.base.Strings;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class CredentialManager {
    private static final SFLogger logger = SFLoggerFactory.getLogger(CredentialManager.class);
    private SecureStorageManager secureStorageManager;
    private static final String ID_TOKEN = "ID_TOKEN";
    private static final String MFA_TOKEN = "MFATOKEN";

    private CredentialManager() {
        this.initSecureStorageManager();
    }

    private void initSecureStorageManager() {
        try {
            if (Constants.getOS() == Constants.OS.MAC) {
                this.secureStorageManager = SecureStorageAppleManager.builder();
            } else if (Constants.getOS() == Constants.OS.WINDOWS) {
                this.secureStorageManager = SecureStorageWindowsManager.builder();
            } else if (Constants.getOS() == Constants.OS.LINUX) {
                this.secureStorageManager = SecureStorageLinuxManager.getInstance();
            } else {
                logger.error("Unsupported Operating System. Expected: OSX, Windows, Linux");
            }
        }
        catch (NoClassDefFoundError error) {
            logger.info("JNA jar files are needed for Secure Local Storage service. Please follow the Snowflake JDBC instruction for Secure Local Storage feature. Fall back to normal process.");
        }
    }

    void resetSecureStorageManager() {
        this.initSecureStorageManager();
    }

    void injectSecureStorageManager(SecureStorageManager manager) {
        this.secureStorageManager = manager;
    }

    public static CredentialManager getInstance() {
        return CredentialManagerHolder.INSTANCE;
    }

    void fillCachedIdToken(SFLoginInput loginInput) throws SFException {
        this.fillCachedCredential(loginInput, ID_TOKEN);
    }

    void fillCachedMfaToken(SFLoginInput loginInput) throws SFException {
        this.fillCachedCredential(loginInput, MFA_TOKEN);
    }

    synchronized void fillCachedCredential(SFLoginInput loginInput, String credType) throws SFException {
        if (this.secureStorageManager == null) {
            logger.info("JNA jar files are needed for Secure Local Storage service. Please follow the Snowflake JDBC instruction for Secure Local Storage feature. Fall back to normal process.");
            return;
        }
        String cred = null;
        try {
            cred = this.secureStorageManager.getCredential(loginInput.getHostFromServerUrl(), loginInput.getUserName(), credType);
        }
        catch (NoClassDefFoundError error) {
            logger.info("JNA jar files are needed for Secure Local Storage service. Please follow the Snowflake JDBC instruction for Secure Local Storage feature. Fall back to normal process.");
            return;
        }
        if (cred == null) {
            logger.debug("retrieved %s is null", credType);
        }
        if (credType == ID_TOKEN) {
            loginInput.setIdToken(cred);
        } else if (credType == MFA_TOKEN) {
            loginInput.setMfaToken(cred);
        } else {
            logger.debug("unrecognized type %s for local cached credential", credType);
        }
    }

    void writeIdToken(SFLoginInput loginInput, SFLoginOutput loginOutput) throws SFException {
        this.writeTemporaryCredential(loginInput, loginOutput.getIdToken(), ID_TOKEN);
    }

    void writeMfaToken(SFLoginInput loginInput, SFLoginOutput loginOutput) throws SFException {
        this.writeTemporaryCredential(loginInput, loginOutput.getMfaToken(), MFA_TOKEN);
    }

    synchronized void writeTemporaryCredential(SFLoginInput loginInput, String cred, String credType) throws SFException {
        if (Strings.isNullOrEmpty(cred)) {
            logger.debug("no %s is given.", credType);
            return;
        }
        if (this.secureStorageManager == null) {
            logger.info("JNA jar files are needed for Secure Local Storage service. Please follow the Snowflake JDBC instruction for Secure Local Storage feature. Fall back to normal process.");
            return;
        }
        try {
            this.secureStorageManager.setCredential(loginInput.getHostFromServerUrl(), loginInput.getUserName(), credType, cred);
        }
        catch (NoClassDefFoundError error) {
            logger.info("JNA jar files are needed for Secure Local Storage service. Please follow the Snowflake JDBC instruction for Secure Local Storage feature. Fall back to normal process.");
        }
    }

    void deleteIdTokenCache(String host, String user) {
        this.deleteTemporaryCredential(host, user, ID_TOKEN);
    }

    void deleteMfaTokenCache(String host, String user) {
        this.deleteTemporaryCredential(host, user, MFA_TOKEN);
    }

    synchronized void deleteTemporaryCredential(String host, String user, String credType) {
        if (this.secureStorageManager == null) {
            logger.info("JNA jar files are needed for Secure Local Storage service. Please follow the Snowflake JDBC instruction for Secure Local Storage feature. Fall back to normal process.");
            return;
        }
        try {
            this.secureStorageManager.deleteCredential(host, user, credType);
        }
        catch (NoClassDefFoundError error) {
            logger.info("JNA jar files are needed for Secure Local Storage service. Please follow the Snowflake JDBC instruction for Secure Local Storage feature. Fall back to normal process.");
        }
    }

    private static class CredentialManagerHolder {
        private static final CredentialManager INSTANCE = new CredentialManager();

        private CredentialManagerHolder() {
        }
    }
}

