/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.batching;

import net.snowflake.client.jdbc.internal.google.api.core.InternalApi;
import net.snowflake.client.jdbc.internal.google.api.gax.batching.AutoValue_DynamicFlowControlSettings;
import net.snowflake.client.jdbc.internal.google.api.gax.batching.FlowController;
import net.snowflake.client.jdbc.internal.google.auto.value.AutoValue;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

@InternalApi(value="For google-cloud-java client use only")
@AutoValue
public abstract class DynamicFlowControlSettings {
    @Nullable
    public abstract Long getInitialOutstandingElementCount();

    @Nullable
    public abstract Long getInitialOutstandingRequestBytes();

    @Nullable
    public abstract Long getMaxOutstandingElementCount();

    @Nullable
    public abstract Long getMaxOutstandingRequestBytes();

    @Nullable
    public abstract Long getMinOutstandingElementCount();

    @Nullable
    public abstract Long getMinOutstandingRequestBytes();

    public abstract FlowController.LimitExceededBehavior getLimitExceededBehavior();

    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        return new AutoValue_DynamicFlowControlSettings.Builder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setInitialOutstandingElementCount(Long var1);

        public abstract Builder setInitialOutstandingRequestBytes(Long var1);

        public abstract Builder setMaxOutstandingElementCount(Long var1);

        public abstract Builder setMaxOutstandingRequestBytes(Long var1);

        public abstract Builder setMinOutstandingElementCount(Long var1);

        public abstract Builder setMinOutstandingRequestBytes(Long var1);

        public abstract Builder setLimitExceededBehavior(FlowController.LimitExceededBehavior var1);

        abstract DynamicFlowControlSettings autoBuild();

        public DynamicFlowControlSettings build() {
            DynamicFlowControlSettings settings = this.autoBuild();
            this.verifyElementCountSettings(settings);
            this.verifyRequestBytesSettings(settings);
            return settings;
        }

        private void verifyElementCountSettings(DynamicFlowControlSettings settings) {
            if (settings.getLimitExceededBehavior() == FlowController.LimitExceededBehavior.Ignore) {
                return;
            }
            if (settings.getInitialOutstandingElementCount() == null && settings.getMinOutstandingElementCount() == null && settings.getMaxOutstandingElementCount() == null) {
                return;
            }
            Preconditions.checkState(settings.getInitialOutstandingElementCount() != null && settings.getMinOutstandingElementCount() != null && settings.getMaxOutstandingElementCount() != null, "Throttling on element count is disabled by default. To enable this setting, minOutstandingElementCount, initialOutstandingElementCount, and maxOutstandingElementCount must all be set.");
            Preconditions.checkState(settings.getMinOutstandingElementCount() > 0L && settings.getInitialOutstandingElementCount() <= settings.getMaxOutstandingElementCount() && settings.getInitialOutstandingElementCount() >= settings.getMinOutstandingElementCount(), "If throttling on element count is set, minOutstandingElementCount must be greater than 0, and minOutstandingElementCount <= initialOutstandingElementCount <= maxOutstandingElementCount");
        }

        private void verifyRequestBytesSettings(DynamicFlowControlSettings settings) {
            if (settings.getLimitExceededBehavior() == FlowController.LimitExceededBehavior.Ignore) {
                return;
            }
            if (settings.getInitialOutstandingRequestBytes() == null && settings.getMinOutstandingRequestBytes() == null && settings.getMaxOutstandingRequestBytes() == null) {
                return;
            }
            Preconditions.checkState(settings.getInitialOutstandingRequestBytes() != null && settings.getMinOutstandingRequestBytes() != null && settings.getMaxOutstandingRequestBytes() != null, "Throttling on number of bytes is disabled by default. To enable this setting, minOutstandingRequestBytes, initialOutstandingRequestBytes, and maxOutstandingRequestBytes must all be set");
            Preconditions.checkState(settings.getMinOutstandingRequestBytes() > 0L && settings.getInitialOutstandingRequestBytes() <= settings.getMaxOutstandingRequestBytes() && settings.getInitialOutstandingRequestBytes() >= settings.getMinOutstandingRequestBytes(), "If throttling on number of bytes is set, minOutstandingRequestBytes must be greater than 0, and minOutstandingRequestBytes <= initialOutstandingRequestBytes <= maxOutstandingRequestBytes");
        }
    }
}

