/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.loader;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import net.snowflake.client.loader.BufferStage;
import net.snowflake.client.loader.LoadResultListener;
import net.snowflake.client.loader.Loader;
import net.snowflake.client.loader.LoadingError;
import net.snowflake.client.loader.Operation;
import net.snowflake.client.loader.StreamLoader;
import net.snowflake.client.loader.Utils;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class ProcessQueue
implements Runnable {
    private static final SFLogger LOGGER = SFLoggerFactory.getLogger(ProcessQueue.class);
    private final Thread _thread;
    private final StreamLoader _loader;

    public ProcessQueue(StreamLoader loader) {
        LOGGER.debug("");
        this._loader = loader;
        this._thread = new Thread(this);
        this._thread.setName("ProcessQueueThread");
        this._thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        while (true) {
            BufferStage stage = null;
            Connection conn = this._loader.getProcessConnection();
            State currentState = State.INITIALIZE;
            String currentCommand = null;
            try {
                stage = this._loader.takeProcess();
                if (stage.getRowCount() == 0) {
                    if (!stage.isTerminate()) continue;
                    return;
                }
                String remoteStage = "@" + this._loader.getRemoteStage() + "/" + stage.getRemoteLocation();
                StreamLoader streamLoader = this._loader;
                synchronized (streamLoader) {
                    String loadStatement;
                    String updateKeys = this.getOn(this._loader.getKeys(), "T", "S");
                    if (stage.getOp() != Operation.INSERT && updateKeys.isEmpty()) {
                        this._loader.abort(new RuntimeException("No update key column is specified for the job."));
                    }
                    if (this._loader.isAborted()) {
                        if (!this._loader._preserveStageFile) {
                            currentCommand = "RM '" + remoteStage + "'";
                            LOGGER.debug(currentCommand);
                            conn.createStatement().execute(currentCommand);
                        } else {
                            LOGGER.debug("Error occurred. The remote stage is preserved for further investigation: {}", remoteStage);
                        }
                        if (stage.isTerminate()) {
                            return;
                        }
                        continue;
                    }
                    long loaded = 0L;
                    long parsed = 0L;
                    int errorCount = 0;
                    String lastErrorRow = "";
                    LOGGER.debug("Creating Temporary Table: name={}", stage.getId());
                    currentState = State.CREATE_TEMP_TABLE;
                    List<String> allColumns = this.getAllColumns(conn);
                    currentCommand = "CREATE TEMPORARY TABLE \"" + stage.getId() + "\" LIKE " + this._loader.getFullTableName();
                    List<String> selectedColumns = this._loader.getColumns();
                    conn.createStatement().execute(currentCommand);
                    String dropClusteringKey = "alter table \"" + stage.getId() + "\" drop clustering key";
                    conn.createStatement().execute(dropClusteringKey);
                    for (String col : allColumns) {
                        if (selectedColumns.contains(col)) continue;
                        String dropUnSelectedColumn = "alter table \"" + stage.getId() + "\" drop column \"" + col + "\"";
                        conn.createStatement().execute(dropUnSelectedColumn);
                    }
                    LOGGER.debug("COPY data in the stage to table: stage={}, name={}", remoteStage, stage.getId());
                    currentState = State.COPY_INTO_TABLE;
                    currentCommand = "COPY INTO \"" + stage.getId() + "\" FROM '" + remoteStage + "' on_error='" + this._loader._onError + "' file_format=( field_optionally_enclosed_by='\"' empty_field_as_null=" + Boolean.toString(!this._loader._copyEmptyFieldAsEmpty) + ")";
                    ResultSet rs = conn.createStatement().executeQuery(currentCommand);
                    while (rs.next()) {
                        loaded += rs.getLong("rows_loaded");
                        parsed += rs.getLong("rows_parsed");
                    }
                    int errorRecordCount = Math.toIntExact(parsed - loaded);
                    LOGGER.debug("errorRecordCount=[{}], parsed=[{}], loaded=[{}]", errorRecordCount, parsed, loaded);
                    LoadResultListener listener = this._loader.getListener();
                    listener.addErrorRecordCount(errorRecordCount);
                    if (loaded == (long)stage.getRowCount()) {
                        LOGGER.debug("COPY command successfully finished: stage={}, name={}", remoteStage, stage.getId());
                        listener.addErrorCount(0);
                    } else {
                        LOGGER.debug("Found errors in COPY command: stage={}, name={}", remoteStage, stage.getId());
                        if (listener.needErrors()) {
                            currentState = State.COPY_INTO_TABLE_ERROR;
                            currentCommand = "COPY INTO \"" + stage.getId() + "\" FROM '" + remoteStage + "' validation_mode='return_all_errors' file_format=(field_optionally_enclosed_by='\"'empty_field_as_null=" + Boolean.toString(!this._loader._copyEmptyFieldAsEmpty) + ")";
                            ResultSet errorsSet = conn.createStatement().executeQuery(currentCommand);
                            Loader.DataError dataError = null;
                            while (errorsSet.next()) {
                                ++errorCount;
                                String rn = errorsSet.getString(LoadingError.ErrorProperty.ROW_NUMBER.name());
                                if (rn != null && !lastErrorRow.equals(rn)) {
                                    lastErrorRow = rn;
                                }
                                LoadingError loadError = new LoadingError(errorsSet, stage, this._loader);
                                listener.addError(loadError);
                                if (dataError != null) continue;
                                dataError = loadError.getException();
                            }
                            LOGGER.debug("errorCount: {}", errorCount);
                            listener.addErrorCount(errorCount);
                            if (listener.throwOnError()) {
                                this._loader.abort(dataError);
                                if (!this._loader._preserveStageFile) {
                                    LOGGER.debug("RM: {}", remoteStage);
                                    conn.createStatement().execute("RM '" + remoteStage + "'");
                                } else {
                                    LOGGER.error("Error occurred. The remote stage is preserved for further investigation: {}", remoteStage);
                                }
                                if (stage.isTerminate()) {
                                    return;
                                }
                                continue;
                            }
                        }
                    }
                    stage.setState(BufferStage.State.VALIDATED);
                    StringBuilder setStatement = null;
                    StringBuilder valueStatement = null;
                    if (stage.getOp() != Operation.INSERT && stage.getOp() != Operation.DELETE) {
                        setStatement = new StringBuilder(" ");
                        valueStatement = new StringBuilder("(");
                        for (int c = 0; c < this._loader.getColumns().size(); ++c) {
                            String column = this._loader.getColumns().get(c);
                            if (c > 0) {
                                setStatement.append(", ");
                                valueStatement.append(" , ");
                            }
                            setStatement.append("T.\"").append(column).append("\"=").append("S.\"").append(column).append("\"");
                            valueStatement.append("S.\"").append(column).append("\"");
                        }
                        valueStatement.append(")");
                    }
                    currentState = State.INGEST_DATA;
                    switch (stage.getOp()) {
                        case INSERT: {
                            loadStatement = "INSERT INTO " + this._loader.getFullTableName() + "(" + this._loader.getColumnsAsString() + ") SELECT * FROM \"" + stage.getId() + "\"";
                            break;
                        }
                        case DELETE: {
                            loadStatement = "DELETE FROM " + this._loader.getFullTableName() + " T USING \"" + stage.getId() + "\" AS S WHERE " + updateKeys;
                            break;
                        }
                        case MODIFY: {
                            loadStatement = "MERGE INTO " + this._loader.getFullTableName() + " T USING \"" + stage.getId() + "\" AS S ON " + updateKeys + " WHEN MATCHED THEN UPDATE SET " + setStatement;
                            break;
                        }
                        case UPSERT: {
                            loadStatement = "MERGE INTO " + this._loader.getFullTableName() + " T USING \"" + stage.getId() + "\" AS S ON " + updateKeys + " WHEN MATCHED THEN UPDATE SET " + setStatement + " WHEN NOT MATCHED THEN INSERT(" + this._loader.getColumnsAsString() + ") VALUES" + valueStatement;
                            break;
                        }
                        default: {
                            loadStatement = "";
                        }
                    }
                    currentCommand = loadStatement;
                    LOGGER.debug("Load Statement: {}", loadStatement);
                    Statement s2 = conn.createStatement();
                    s2.execute(loadStatement);
                    stage.setState(BufferStage.State.PROCESSED);
                    currentState = State.FINISH;
                    currentCommand = null;
                    switch (stage.getOp()) {
                        case INSERT: 
                        case UPSERT: {
                            this._loader.getListener().addProcessedRecordCount(stage.getOp(), stage.getRowCount());
                            this._loader.getListener().addOperationRecordCount(stage.getOp(), s2.getUpdateCount());
                            break;
                        }
                        case DELETE: 
                        case MODIFY: {
                            this._loader.getListener().addProcessedRecordCount(stage.getOp(), s2.getUpdateCount());
                            this._loader.getListener().addOperationRecordCount(stage.getOp(), s2.getUpdateCount());
                        }
                    }
                    conn.createStatement().execute("RM '" + remoteStage + "'");
                    if (stage.isTerminate()) {
                        return;
                    }
                    continue;
                }
            }
            catch (InterruptedException ex) {
                LOGGER.error("Interrupted", ex);
                return;
            }
            catch (Exception ex) {
                String msg = String.format("State: %s, %s, %s", new Object[]{currentState, currentCommand, ex.getMessage()});
                this._loader.abort(new Loader.ConnectionError(msg, Utils.getCause(ex)));
                LOGGER.error(msg);
                if (stage == null) return;
                if (stage.isTerminate()) return;
                continue;
            }
            break;
        }
    }

    private List<String> getAllColumns(Connection conn) throws SQLException {
        LinkedList<String> columns = new LinkedList<String>();
        ResultSet result = conn.createStatement().executeQuery("show columns in " + this._loader.getFullTableName());
        while (result.next()) {
            String col = result.getString("column_name");
            columns.add(col);
        }
        return columns;
    }

    private String getOn(List<String> keys, String L, String R) {
        if (keys == null) {
            return "";
        }
        StringBuilder sb = keys.size() > 1 ? new StringBuilder(64) : new StringBuilder();
        for (int i = 0; i < keys.size(); ++i) {
            if (i > 0) {
                sb.append("AND ");
            }
            sb.append(L);
            sb.append(".\"");
            sb.append(keys.get(i));
            sb.append("\" = ");
            sb.append(R);
            sb.append(".\"");
            sb.append(keys.get(i));
            sb.append("\" ");
        }
        return sb.toString();
    }

    public void join() {
        LOGGER.debug("");
        try {
            this._thread.join(0L);
        }
        catch (InterruptedException ex) {
            LOGGER.debug("Exception: ", ex);
        }
    }

    private static enum State {
        INITIALIZE,
        CREATE_TEMP_TABLE,
        COPY_INTO_TABLE,
        COPY_INTO_TABLE_ERROR,
        INGEST_DATA,
        FINISH;

    }
}

