/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;
import net.snowflake.client.core.IncidentUtil;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.ArrowResultUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeDateWithTimezone;
import net.snowflake.client.jdbc.SnowflakeTimeWithTimezone;
import net.snowflake.client.jdbc.SnowflakeTimestampWithTimezone;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFBinary;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFBinaryFormat;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTime;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTimestamp;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public abstract class SFJsonResultSet
extends SFBaseResultSet {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SFJsonResultSet.class);
    private static final TimeZone timeZoneUTC = TimeZone.getTimeZone("UTC");
    TimeZone sessionTimeZone;
    private static final int LONG_PRECISION = 19;
    private static final BigDecimal MAX_LONG_VAL = new BigDecimal(Long.MAX_VALUE);
    private static final BigDecimal MIN_LONG_VAL = new BigDecimal(Long.MIN_VALUE);

    protected abstract Object getObjectInternal(int var1) throws SFException;

    @Override
    public Object getObject(int columnIndex) throws SFException {
        int type = this.resultSetMetaData.getColumnType(columnIndex);
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        switch (type) {
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case -2: {
                return this.getBytes(columnIndex);
            }
            case 4: {
                return this.getInt(columnIndex);
            }
            case 3: {
                return this.getBigDecimal(columnIndex);
            }
            case -5: {
                return this.getBigInt(columnIndex, obj);
            }
            case 8: {
                return this.getDouble(columnIndex);
            }
            case 93: 
            case 2014: {
                return this.getTimestamp(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 16: {
                return this.getBoolean(columnIndex);
            }
        }
        throw (SFException)IncidentUtil.generateIncidentV2WithException(this.session, new SFException(ErrorCode.FEATURE_UNSUPPORTED, "data type: " + type), null, null);
    }

    private Object getBigInt(int columnIndex, Object obj) throws SFException {
        BigDecimal bigNum;
        String numberAsString = obj.toString();
        if (numberAsString.length() >= 19 && ((bigNum = this.getBigDecimal(columnIndex)).compareTo(MAX_LONG_VAL) == 1 || bigNum.compareTo(MIN_LONG_VAL) == -1)) {
            return bigNum;
        }
        return this.getLong(columnIndex);
    }

    @Override
    public String getString(int columnIndex) throws SFException {
        logger.debug("public String getString(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        int columnType = this.resultSetMetaData.getInternalColumnType(columnIndex);
        switch (columnType) {
            case 16: {
                return ResultUtil.getBooleanAsString(ResultUtil.getBoolean(obj.toString()));
            }
            case 93: 
            case 50000: 
            case 50001: {
                SFTimestamp sfTS = this.getSFTimestamp(columnIndex);
                int columnScale = this.resultSetMetaData.getScale(columnIndex);
                String timestampStr = ResultUtil.getSFTimestampAsString(sfTS, columnType, columnScale, this.timestampNTZFormatter, this.timestampLTZFormatter, this.timestampTZFormatter, this.session);
                Object[] objectArray = new Object[2];
                objectArray[0] = obj::toString;
                objectArray[1] = timestampStr;
                logger.debug("Converting timestamp to string from: {} to: {}", objectArray);
                return timestampStr;
            }
            case 91: {
                Date date = this.getDate(columnIndex);
                if (this.dateFormatter == null) {
                    throw (SFException)IncidentUtil.generateIncidentV2WithException(this.session, new SFException(ErrorCode.INTERNAL_ERROR, "missing date formatter"), null, null);
                }
                String dateStr = ResultUtil.getDateAsString(date, this.dateFormatter);
                Object[] objectArray = new Object[2];
                objectArray[0] = obj::toString;
                objectArray[1] = dateStr;
                logger.debug("Converting date to string from: {} to: {}", objectArray);
                return dateStr;
            }
            case 92: {
                SFTime sfTime = this.getSFTime(columnIndex);
                if (this.timeFormatter == null) {
                    throw (SFException)IncidentUtil.generateIncidentV2WithException(this.session, new SFException(ErrorCode.INTERNAL_ERROR, "missing time formatter"), null, null);
                }
                int scale = this.resultSetMetaData.getScale(columnIndex);
                String timeStr = ResultUtil.getSFTimeAsString(sfTime, scale, this.timeFormatter);
                Object[] objectArray = new Object[2];
                objectArray[0] = obj::toString;
                objectArray[1] = timeStr;
                logger.debug("Converting time to string from: {} to: {}", objectArray);
                return timeStr;
            }
            case -2: {
                if (this.binaryFormatter == null) {
                    throw (SFException)IncidentUtil.generateIncidentV2WithException(this.session, new SFException(ErrorCode.INTERNAL_ERROR, "missing binary formatter"), null, null);
                }
                if (this.binaryFormatter == SFBinaryFormat.HEX) {
                    return obj.toString();
                }
                SFBinary sfb = new SFBinary(this.getBytes(columnIndex));
                return this.binaryFormatter.format(sfb);
            }
        }
        return obj.toString();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SFException {
        logger.debug("public boolean getBoolean(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        if (columnType == 16 || columnType == 4 || columnType == 5 || columnType == -6 || columnType == -5 || columnType == -7 || columnType == 12 || columnType == 1) {
            String type = obj.toString();
            if ("1".equals(type) || Boolean.TRUE.toString().equalsIgnoreCase(type)) {
                return true;
            }
            if ("0".equals(type) || Boolean.FALSE.toString().equalsIgnoreCase(type)) {
                return false;
            }
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "boolean", obj);
    }

    @Override
    public byte getByte(int columnIndex) throws SFException {
        logger.debug("public short getByte(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof String) {
            return Byte.parseByte((String)obj);
        }
        return ((Number)obj).byteValue();
    }

    @Override
    public short getShort(int columnIndex) throws SFException {
        logger.debug("public short getShort(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0;
        }
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        try {
            if (obj instanceof String) {
                String objString = (String)obj;
                if (objString.contains(".") && (columnType == 6 || columnType == 8)) {
                    objString = objString.substring(0, objString.indexOf("."));
                }
                return Short.parseShort(objString);
            }
            return ((Number)obj).shortValue();
        }
        catch (NumberFormatException ex) {
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "short", obj);
        }
    }

    @Override
    public int getInt(int columnIndex) throws SFException {
        logger.debug("public int getInt(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0;
        }
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        try {
            if (obj instanceof String) {
                String objString = (String)obj;
                if (objString.contains(".") && (columnType == 6 || columnType == 8)) {
                    objString = objString.substring(0, objString.indexOf("."));
                }
                return Integer.parseInt(objString);
            }
            return ((Number)obj).intValue();
        }
        catch (NumberFormatException ex) {
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "int", obj);
        }
    }

    @Override
    public long getLong(int columnIndex) throws SFException {
        logger.debug("public long getLong(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0L;
        }
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        try {
            if (obj instanceof String) {
                String objString = (String)obj;
                if (objString.contains(".") && (columnType == 6 || columnType == 8)) {
                    objString = objString.substring(0, objString.indexOf("."));
                }
                return Long.parseLong(objString);
            }
            return ((Number)obj).longValue();
        }
        catch (NumberFormatException nfe) {
            if (4 == columnType || 5 == columnType) {
                throw (SFException)IncidentUtil.generateIncidentV2WithException(this.session, new SFException(ErrorCode.INTERNAL_ERROR, "long: " + obj.toString()), null, null);
            }
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "long", obj);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SFException {
        logger.debug("public BigDecimal getBigDecimal(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        try {
            if (columnType != 92 && columnType != 93 && columnType != 2014) {
                return new BigDecimal(obj.toString());
            }
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "big decimal", obj);
        }
        catch (NumberFormatException ex) {
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "big decimal", obj);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SFException {
        logger.debug("public BigDecimal getBigDecimal(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        BigDecimal value = new BigDecimal(obj.toString());
        value = value.setScale(scale, RoundingMode.HALF_UP);
        return value;
    }

    private TimeZone adjustTimezoneForTimestampTZ(int columnIndex) throws SFException {
        Object obj = this.getObjectInternal(columnIndex);
        int subType = this.resultSetMetaData.getInternalColumnType(columnIndex);
        if (obj != null && subType == 50001 && this.resultVersion > 0L) {
            String timestampStr = obj.toString();
            int indexForSeparator = timestampStr.indexOf(32);
            String timezoneIndexStr = timestampStr.substring(indexForSeparator + 1);
            return SFTimestamp.convertTimezoneIndexToTimeZone(Integer.parseInt(timezoneIndexStr));
        }
        return this.sessionTimeZone;
    }

    private SFTimestamp getSFTimestamp(int columnIndex) throws SFException {
        logger.debug("public Timestamp getTimestamp(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        return ResultUtil.getSFTimestamp(obj.toString(), this.resultSetMetaData.getScale(columnIndex), this.resultSetMetaData.getInternalColumnType(columnIndex), this.resultVersion, this.sessionTimeZone, this.session);
    }

    @Override
    public Time getTime(int columnIndex) throws SFException {
        logger.debug("public Time getTime(int columnIndex)", false);
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        if (92 == columnType) {
            SFTime sfTime = this.getSFTime(columnIndex);
            if (sfTime == null) {
                return null;
            }
            return new SnowflakeTimeWithTimezone(sfTime.getFractionalSeconds(3), sfTime.getNanosecondsWithinSecond(), this.resultSetSerializable.getUseSessionTimezone());
        }
        if (93 == columnType || 2014 == columnType) {
            Timestamp ts = this.getTimestamp(columnIndex);
            if (ts == null) {
                return null;
            }
            if (this.resultSetSerializable.getUseSessionTimezone()) {
                ts = this.getTimestamp(columnIndex, this.sessionTimeZone);
                TimeZone sessionTimeZone = this.adjustTimezoneForTimestampTZ(columnIndex);
                return new SnowflakeTimeWithTimezone(ts, sessionTimeZone, this.resultSetSerializable.getUseSessionTimezone());
            }
            return new Time(ts.getTime());
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "time", this.getObjectInternal(columnIndex));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, TimeZone tz) throws SFException {
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        if (93 == columnType || 2014 == columnType) {
            SFTimestamp sfTS;
            if (tz == null) {
                tz = TimeZone.getDefault();
            }
            if ((sfTS = this.getSFTimestamp(columnIndex)) == null) {
                return null;
            }
            Timestamp res = sfTS.getTimestamp();
            if (res == null) {
                return null;
            }
            int subType = this.resultSetMetaData.getInternalColumnType(columnIndex);
            if (this.resultSetSerializable.getUseSessionTimezone()) {
                if (subType == 50000 || subType == 50001) {
                    TimeZone specificSessionTimezone = this.adjustTimezoneForTimestampTZ(columnIndex);
                    res = new SnowflakeTimestampWithTimezone(res, specificSessionTimezone);
                } else {
                    res = new SnowflakeTimestampWithTimezone(res);
                }
            } else if (this.resultSetSerializable.getTreatNTZAsUTC() && this.resultSetMetaData.getInternalColumnType(columnIndex) == 93) {
                res = new SnowflakeTimestampWithTimezone(res);
            }
            if (this.resultSetMetaData.getInternalColumnType(columnIndex) == 93 && (!this.resultSetSerializable.getTreatNTZAsUTC() && this.honorClientTZForTimestampNTZ || this.resultSetSerializable.getUseSessionTimezone())) {
                res = sfTS.moveToTimeZone(tz).getTimestamp();
            }
            return ResultUtil.adjustTimestamp(res);
        }
        if (91 == columnType) {
            Date d = this.getDate(columnIndex, tz);
            if (d == null) {
                return null;
            }
            return new Timestamp(d.getTime());
        }
        if (92 == columnType) {
            Time t = this.getTime(columnIndex);
            if (t == null) {
                return null;
            }
            if (this.resultSetSerializable.getUseSessionTimezone()) {
                SFTime sfTime = this.getSFTime(columnIndex);
                return new SnowflakeTimestampWithTimezone(sfTime.getFractionalSeconds(3), sfTime.getNanosecondsWithinSecond(), TimeZone.getTimeZone("UTC"));
            }
            return new Timestamp(t.getTime());
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "timestamp", this.getObjectInternal(columnIndex));
    }

    @Override
    public float getFloat(int columnIndex) throws SFException {
        logger.debug("public float getFloat(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0.0f;
        }
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        try {
            if (obj instanceof String) {
                if (columnType != 92 && columnType != 93 && columnType != 2014) {
                    if ("inf".equals(obj)) {
                        return Float.POSITIVE_INFINITY;
                    }
                    if ("-inf".equals(obj)) {
                        return Float.NEGATIVE_INFINITY;
                    }
                    return Float.parseFloat((String)obj);
                }
                throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "float", this.getObjectInternal(columnIndex));
            }
            return ((Number)obj).floatValue();
        }
        catch (NumberFormatException ex) {
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "float", this.getObjectInternal(columnIndex));
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SFException {
        logger.debug("public double getDouble(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0.0;
        }
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        try {
            if (obj instanceof String) {
                if (columnType != 92 && columnType != 93 && columnType != 2014) {
                    if ("inf".equals(obj)) {
                        return Double.POSITIVE_INFINITY;
                    }
                    if ("-inf".equals(obj)) {
                        return Double.NEGATIVE_INFINITY;
                    }
                    return Double.parseDouble((String)obj);
                }
                throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "double", this.getObjectInternal(columnIndex));
            }
            return ((Number)obj).doubleValue();
        }
        catch (NumberFormatException ex) {
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "double", this.getObjectInternal(columnIndex));
        }
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SFException {
        logger.debug("public byte[] getBytes(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        if (obj == null) {
            return null;
        }
        try {
            switch (columnType) {
                case 6: 
                case 8: {
                    return ByteBuffer.allocate(8).putDouble(0, this.getDouble(columnIndex)).array();
                }
                case -6: 
                case -5: 
                case 2: 
                case 4: 
                case 5: {
                    return this.getBigDecimal(columnIndex).toBigInteger().toByteArray();
                }
                case 1: 
                case 12: {
                    return this.getString(columnIndex).getBytes();
                }
                case 16: {
                    byte[] byArray;
                    if (this.getBoolean(columnIndex)) {
                        byte[] byArray2 = new byte[1];
                        byArray = byArray2;
                        byArray2[0] = 1;
                    } else {
                        byte[] byArray3 = new byte[1];
                        byArray = byArray3;
                        byArray3[0] = 0;
                    }
                    return byArray;
                }
                case 3: 
                case 91: 
                case 92: 
                case 93: {
                    throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "byte array", this.getObjectInternal(columnIndex));
                }
            }
            return SFBinary.fromHex(obj.toString()).getBytes();
        }
        catch (IllegalArgumentException ex) {
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "byte array", this.getObjectInternal(columnIndex));
        }
    }

    public Date getDate(int columnIndex) throws SFException {
        return this.getDate(columnIndex, TimeZone.getDefault());
    }

    @Override
    public Date getDate(int columnIndex, TimeZone tz) throws SFException {
        logger.debug("public Date getDate(int columnIndex)", false);
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        if (93 == columnType || 2014 == columnType) {
            int subType;
            if (tz == null) {
                tz = TimeZone.getDefault();
            }
            if ((subType = this.resultSetMetaData.getInternalColumnType(columnIndex)) == 50001 || subType == 50000) {
                TimeZone specificSessionTimeZone = this.adjustTimezoneForTimestampTZ(columnIndex);
                return new SnowflakeDateWithTimezone(this.getTimestamp(columnIndex, tz).getTime(), specificSessionTimeZone, this.resultSetSerializable.getUseSessionTimezone());
            }
            return new Date(this.getTimestamp(columnIndex, tz).getTime());
        }
        if (91 == columnType) {
            if (tz == null || !this.resultSetSerializable.getFormatDateWithTimeZone()) {
                return ArrowResultUtil.getDate(Integer.parseInt((String)obj));
            }
            return ArrowResultUtil.getDate(Integer.parseInt((String)obj), tz, this.sessionTimeZone);
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "date", obj);
    }

    private SFTime getSFTime(int columnIndex) throws SFException {
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        int scale = this.resultSetMetaData.getScale(columnIndex);
        return ResultUtil.getSFTime(obj.toString(), scale, this.session);
    }

    private Timestamp getTimestamp(int columnIndex) throws SFException {
        return this.getTimestamp(columnIndex, TimeZone.getDefault());
    }
}

