/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.security.PrivateKey;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import net.snowflake.client.core.HeartbeatBackground;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.IncidentUtil;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.ParameterBindingDTO;
import net.snowflake.client.core.QueryStatus;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFLoginInput;
import net.snowflake.client.core.SFLoginOutput;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.core.SFStatement;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.jdbc.DefaultSFConnectionHandler;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeConnectString;
import net.snowflake.client.jdbc.SnowflakeReauthenticationRequest;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpGet;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpPost;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpRequestBase;
import net.snowflake.client.jdbc.internal.apache.http.client.utils.URIBuilder;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Strings;
import net.snowflake.client.jdbc.internal.snowflake.common.core.ClientAuthnDTO;
import net.snowflake.client.jdbc.telemetry.Telemetry;
import net.snowflake.client.jdbc.telemetry.TelemetryClient;
import net.snowflake.client.log.JDK14Logger;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SFSession
extends SFBaseSession {
    public static final String SF_QUERY_REQUEST_ID = "requestId";
    public static final String SF_HEADER_AUTHORIZATION = "Authorization";
    public static final String SF_HEADER_SNOWFLAKE_AUTHTYPE = "Snowflake";
    public static final String SF_HEADER_TOKEN_TAG = "Token";
    static final SFLogger logger = SFLoggerFactory.getLogger(SFSession.class);
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.getObjectMapper();
    private static final String SF_PATH_SESSION_HEARTBEAT = "/session/heartbeat";
    private static final String SF_PATH_QUERY_MONITOR = "/monitoring/queries/";
    private static final String CLIENT_STORE_TEMPORARY_CREDENTIAL = "CLIENT_STORE_TEMPORARY_CREDENTIAL";
    private static final ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
    private static final int MAX_SESSION_PARAMETERS = 1000;
    public static final int DEFAULT_HTTP_CLIENT_SOCKET_TIMEOUT = 300000;
    private final AtomicInteger sequenceId = new AtomicInteger(0);
    private final List<DriverPropertyInfo> missingProperties = new ArrayList<DriverPropertyInfo>();
    protected Set<String> activeAsyncQueries = ConcurrentHashMap.newKeySet();
    private boolean isClosed = true;
    private String sessionToken;
    private String masterToken;
    private long masterTokenValidityInSeconds;
    private String idToken;
    private String mfaToken;
    private String privateKeyFileLocation;
    private String privateKeyPassword;
    private PrivateKey privateKey;
    private int loginTimeout = 60;
    private int networkTimeoutInMilli = 0;
    private int authTimeout = 0;
    private boolean enableCombineDescribe = false;
    private int httpClientConnectionTimeout = 60000;
    private int httpClientSocketTimeout = 300000;
    private int injectSocketTimeout = 0;
    private int injectClientPause = 0;
    private Map<String, Object> sessionParametersMap = new HashMap<String, Object>();
    private boolean passcodeInPassword = false;
    private Level tracingLevel = Level.INFO;
    private Telemetry telemetryClient;
    private SnowflakeConnectString sfConnStr;

    @VisibleForTesting
    public SFSession() {
        this(new DefaultSFConnectionHandler(null));
    }

    public SFSession(DefaultSFConnectionHandler sfConnectionHandler) {
        super(sfConnectionHandler);
    }

    @Override
    public boolean isSafeToClose() {
        boolean canClose = true;
        if (this.activeAsyncQueries.isEmpty()) {
            return canClose;
        }
        for (String query : this.activeAsyncQueries) {
            try {
                QueryStatus qStatus = this.getQueryStatus(query);
                if (!QueryStatus.isStillRunning(qStatus)) continue;
                canClose = false;
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), true);
            }
        }
        return canClose;
    }

    public QueryStatus getQueryStatus(String queryID) throws SQLException {
        boolean sessionRenewed;
        String statusUrl = "";
        String sessionUrl = this.getUrl();
        statusUrl = sessionUrl.endsWith("/") ? sessionUrl.substring(0, sessionUrl.length() - 1) + SF_PATH_QUERY_MONITOR + queryID : sessionUrl + SF_PATH_QUERY_MONITOR + queryID;
        HttpGet get = new HttpGet(statusUrl);
        String response = null;
        JsonNode jsonNode = null;
        do {
            sessionRenewed = false;
            try {
                get.setHeader("Content-type", "application/json");
                get.setHeader(SF_HEADER_AUTHORIZATION, "Snowflake Token=\"" + this.sessionToken + "\"");
                response = HttpUtil.executeGeneralRequest((HttpRequestBase)get, this.loginTimeout, this.authTimeout, this.httpClientSocketTimeout, 0, this.getHttpClientKey());
                jsonNode = OBJECT_MAPPER.readTree(response);
            }
            catch (Exception e) {
                throw new SnowflakeSQLLoggedException((SFBaseSession)this, e.getMessage(), "No response or invalid response from GET request. Error: {}");
            }
            if (jsonNode.path("success").asBoolean()) continue;
            logger.debug("response = {}", response);
            int errorCode = jsonNode.path("code").asInt();
            if (errorCode == 390112) {
                try {
                    this.renewSession(this.sessionToken);
                }
                catch (SFException | SnowflakeReauthenticationRequest ex) {
                    if (ex instanceof SnowflakeReauthenticationRequest && this.isExternalbrowserAuthenticator()) {
                        try {
                            this.open();
                        }
                        catch (SFException e) {
                            throw new SnowflakeSQLException(e);
                        }
                    } else {
                        if (ex instanceof SnowflakeReauthenticationRequest) {
                            throw (SnowflakeSQLException)ex;
                        }
                        if (ex instanceof SFException) {
                            throw new SnowflakeSQLException((SFException)ex);
                        }
                    }
                    throw new SnowflakeSQLException(ex.getMessage());
                }
                sessionRenewed = true;
                continue;
            }
            throw new SnowflakeSQLException(queryID, jsonNode.path("message").asText(), "08001", errorCode);
        } while (sessionRenewed);
        JsonNode queryNode = jsonNode.path("data").path("queries");
        String queryStatus = "";
        String errorMessage = "";
        int errorCode = 0;
        if (queryNode.size() > 0) {
            queryStatus = queryNode.get(0).path("status").asText();
            errorMessage = queryNode.get(0).path("errorMessage").asText();
            errorCode = queryNode.get(0).path("errorCode").asInt();
        }
        logger.debug("Query status: {}", queryNode.asText());
        QueryStatus result = QueryStatus.getStatusFromString(queryStatus);
        if (errorCode != 0) {
            result.setErrorCode(errorCode);
        } else if (QueryStatus.isAnError(result)) {
            result.setErrorCode(ErrorCode.INTERNAL_ERROR.getMessageCode());
            result.setErrorMessage("no_error_code_from_server");
        } else if (!QueryStatus.isAnError(result)) {
            result.setErrorCode(0);
            result.setErrorMessage("No error reported");
        }
        if (!Strings.isNullOrEmpty(errorMessage) && !errorMessage.equalsIgnoreCase("null")) {
            result.setErrorMessage(errorMessage);
        } else {
            result.setErrorMessage("No error reported");
        }
        return result;
    }

    public void addSFSessionProperty(String propertyName, Object propertyValue) throws SFException {
        block25: {
            block24: {
                SFSessionProperty connectionProperty = SFSessionProperty.lookupByKey(propertyName);
                if (connectionProperty == null) break block24;
                this.addProperty(propertyName, propertyValue);
                propertyValue = SFSessionProperty.checkPropertyValue(connectionProperty, propertyValue);
                switch (connectionProperty) {
                    case LOGIN_TIMEOUT: {
                        if (propertyValue != null) {
                            this.loginTimeout = (Integer)propertyValue;
                            break;
                        }
                        break block25;
                    }
                    case NETWORK_TIMEOUT: {
                        if (propertyValue != null) {
                            this.networkTimeoutInMilli = (Integer)propertyValue;
                            break;
                        }
                        break block25;
                    }
                    case INJECT_CLIENT_PAUSE: {
                        if (propertyValue != null) {
                            this.injectClientPause = (Integer)propertyValue;
                            break;
                        }
                        break block25;
                    }
                    case INJECT_SOCKET_TIMEOUT: {
                        if (propertyValue != null) {
                            this.injectSocketTimeout = (Integer)propertyValue;
                            break;
                        }
                        break block25;
                    }
                    case PASSCODE_IN_PASSWORD: {
                        this.passcodeInPassword = propertyValue != null && (Boolean)propertyValue != false;
                        break;
                    }
                    case TRACING: {
                        if (propertyValue != null) {
                            this.tracingLevel = Level.parse(((String)propertyValue).toUpperCase());
                            if (this.tracingLevel != null && logger instanceof JDK14Logger) {
                                JDK14Logger.honorTracingParameter(this.tracingLevel);
                                break;
                            }
                        }
                        break block25;
                    }
                    case DISABLE_SOCKS_PROXY: {
                        if (propertyValue != null) {
                            HttpUtil.setSocksProxyDisabled((Boolean)propertyValue);
                            break;
                        }
                        break block25;
                    }
                    case VALIDATE_DEFAULT_PARAMETERS: {
                        if (propertyValue != null) {
                            this.setValidateDefaultParameters(SFLoginInput.getBooleanValue(propertyValue));
                            break;
                        }
                        break block25;
                    }
                    case PRIVATE_KEY_FILE: {
                        if (propertyValue != null) {
                            this.privateKeyFileLocation = (String)propertyValue;
                            break;
                        }
                        break block25;
                    }
                    case PRIVATE_KEY_FILE_PWD: {
                        if (propertyValue != null) {
                            this.privateKeyPassword = (String)propertyValue;
                            break;
                        }
                        break block25;
                    }
                }
                break block25;
            }
            if (this.sessionParametersMap.containsKey(propertyName)) {
                throw new SFException(ErrorCode.DUPLICATE_CONNECTION_PROPERTY_SPECIFIED, propertyName);
            }
            this.sessionParametersMap.put(propertyName, propertyValue);
            if (this.sessionParametersMap.size() > 1000) {
                throw new SFException(ErrorCode.TOO_MANY_SESSION_PARAMETERS, 1000);
            }
        }
    }

    public boolean containProperty(String key) {
        return this.sessionParametersMap.containsKey(key);
    }

    public synchronized void open() throws SFException, SnowflakeSQLException {
        this.performSanityCheckOnProperties();
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.getConnectionPropertiesMap();
        logger.debug("input: server={}, account={}, user={}, password={}, role={}, database={}, schema={}, warehouse={}, validate_default_parameters={}, authenticator={}, ocsp_mode={}, passcode_in_password={}, passcode={}, private_key={}, disable_socks_proxy={}, application={}, app_id={}, app_version={}, login_timeout={}, network_timeout={}, query_timeout={}, tracing={}, private_key_file={}, private_key_file_pwd={}. session_parameters: client_store_temporary_credential={}", connectionPropertiesMap.get((Object)SFSessionProperty.SERVER_URL), connectionPropertiesMap.get((Object)SFSessionProperty.ACCOUNT), connectionPropertiesMap.get((Object)SFSessionProperty.USER), !Strings.isNullOrEmpty((String)connectionPropertiesMap.get((Object)SFSessionProperty.PASSWORD)) ? "***" : "(empty)", connectionPropertiesMap.get((Object)SFSessionProperty.ROLE), connectionPropertiesMap.get((Object)SFSessionProperty.DATABASE), connectionPropertiesMap.get((Object)SFSessionProperty.SCHEMA), connectionPropertiesMap.get((Object)SFSessionProperty.WAREHOUSE), connectionPropertiesMap.get((Object)SFSessionProperty.VALIDATE_DEFAULT_PARAMETERS), connectionPropertiesMap.get((Object)SFSessionProperty.AUTHENTICATOR), this.getOCSPMode().name(), connectionPropertiesMap.get((Object)SFSessionProperty.PASSCODE_IN_PASSWORD), !Strings.isNullOrEmpty((String)connectionPropertiesMap.get((Object)SFSessionProperty.PASSCODE)) ? "***" : "(empty)", connectionPropertiesMap.get((Object)SFSessionProperty.PRIVATE_KEY) != null ? "(not null)" : "(null)", connectionPropertiesMap.get((Object)SFSessionProperty.DISABLE_SOCKS_PROXY), connectionPropertiesMap.get((Object)SFSessionProperty.APPLICATION), connectionPropertiesMap.get((Object)SFSessionProperty.APP_ID), connectionPropertiesMap.get((Object)SFSessionProperty.APP_VERSION), connectionPropertiesMap.get((Object)SFSessionProperty.LOGIN_TIMEOUT), connectionPropertiesMap.get((Object)SFSessionProperty.NETWORK_TIMEOUT), connectionPropertiesMap.get((Object)SFSessionProperty.QUERY_TIMEOUT), connectionPropertiesMap.get((Object)SFSessionProperty.TRACING), connectionPropertiesMap.get((Object)SFSessionProperty.PRIVATE_KEY_FILE), !Strings.isNullOrEmpty((String)connectionPropertiesMap.get((Object)SFSessionProperty.PRIVATE_KEY_FILE_PWD)) ? "***" : "(empty)", this.sessionParametersMap.get(CLIENT_STORE_TEMPORARY_CREDENTIAL));
        HttpClientSettingsKey httpClientSettingsKey = this.getHttpClientKey();
        logger.debug("connection proxy parameters: use_proxy={}, proxy_host={}, proxy_port={}, proxy_user={}, proxy_password={}, non_proxy_hosts={}, proxy_protocol={}", new Object[]{httpClientSettingsKey.usesProxy(), httpClientSettingsKey.getProxyHost(), httpClientSettingsKey.getProxyPort(), httpClientSettingsKey.getProxyUser(), !Strings.isNullOrEmpty(httpClientSettingsKey.getProxyPassword()) ? "***" : "(empty)", httpClientSettingsKey.getNonProxyHosts(), httpClientSettingsKey.getProxyProtocol()});
        SFLoginInput loginInput = new SFLoginInput();
        loginInput.setServerUrl((String)connectionPropertiesMap.get((Object)SFSessionProperty.SERVER_URL)).setDatabaseName((String)connectionPropertiesMap.get((Object)SFSessionProperty.DATABASE)).setSchemaName((String)connectionPropertiesMap.get((Object)SFSessionProperty.SCHEMA)).setWarehouse((String)connectionPropertiesMap.get((Object)SFSessionProperty.WAREHOUSE)).setRole((String)connectionPropertiesMap.get((Object)SFSessionProperty.ROLE)).setValidateDefaultParameters(connectionPropertiesMap.get((Object)SFSessionProperty.VALIDATE_DEFAULT_PARAMETERS)).setAuthenticator((String)connectionPropertiesMap.get((Object)SFSessionProperty.AUTHENTICATOR)).setOKTAUserName((String)connectionPropertiesMap.get((Object)SFSessionProperty.OKTA_USERNAME)).setAccountName((String)connectionPropertiesMap.get((Object)SFSessionProperty.ACCOUNT)).setLoginTimeout(this.loginTimeout).setAuthTimeout(this.authTimeout).setUserName((String)connectionPropertiesMap.get((Object)SFSessionProperty.USER)).setPassword((String)connectionPropertiesMap.get((Object)SFSessionProperty.PASSWORD)).setToken((String)connectionPropertiesMap.get((Object)SFSessionProperty.TOKEN)).setPasscodeInPassword(this.passcodeInPassword).setPasscode((String)connectionPropertiesMap.get((Object)SFSessionProperty.PASSCODE)).setConnectionTimeout(this.httpClientConnectionTimeout).setSocketTimeout(this.httpClientSocketTimeout).setAppId((String)connectionPropertiesMap.get((Object)SFSessionProperty.APP_ID)).setAppVersion((String)connectionPropertiesMap.get((Object)SFSessionProperty.APP_VERSION)).setSessionParameters(this.sessionParametersMap).setPrivateKey((PrivateKey)connectionPropertiesMap.get((Object)SFSessionProperty.PRIVATE_KEY)).setPrivateKeyFile((String)connectionPropertiesMap.get((Object)SFSessionProperty.PRIVATE_KEY_FILE)).setPrivateKeyFilePwd((String)connectionPropertiesMap.get((Object)SFSessionProperty.PRIVATE_KEY_FILE_PWD)).setApplication((String)connectionPropertiesMap.get((Object)SFSessionProperty.APPLICATION)).setServiceName(this.getServiceName()).setOCSPMode(this.getOCSPMode()).setHttpClientSettingsKey(httpClientSettingsKey);
        HttpUtil.initHttpClient(httpClientSettingsKey, null);
        SFLoginOutput loginOutput = SessionUtil.openSession(loginInput, connectionPropertiesMap, this.tracingLevel.toString());
        this.isClosed = false;
        this.authTimeout = loginInput.getAuthTimeout();
        this.sessionToken = loginOutput.getSessionToken();
        this.masterToken = loginOutput.getMasterToken();
        this.idToken = loginOutput.getIdToken();
        this.mfaToken = loginOutput.getMfaToken();
        this.setDatabaseVersion(loginOutput.getDatabaseVersion());
        this.setDatabaseMajorVersion(loginOutput.getDatabaseMajorVersion());
        this.setDatabaseMinorVersion(loginOutput.getDatabaseMinorVersion());
        this.httpClientSocketTimeout = loginOutput.getHttpClientSocketTimeout();
        this.masterTokenValidityInSeconds = loginOutput.getMasterTokenValidityInSeconds();
        this.setDatabase(loginOutput.getSessionDatabase());
        this.setSchema(loginOutput.getSessionSchema());
        this.setRole(loginOutput.getSessionRole());
        this.setWarehouse(loginOutput.getSessionWarehouse());
        this.setSessionId(loginOutput.getSessionId());
        this.setAutoCommit(loginOutput.getAutoCommit());
        SessionUtil.updateSfDriverParamValues(loginOutput.getCommonParams(), this);
        String loginDatabaseName = (String)connectionPropertiesMap.get((Object)SFSessionProperty.DATABASE);
        String loginSchemaName = (String)connectionPropertiesMap.get((Object)SFSessionProperty.SCHEMA);
        String loginRole = (String)connectionPropertiesMap.get((Object)SFSessionProperty.ROLE);
        String loginWarehouse = (String)connectionPropertiesMap.get((Object)SFSessionProperty.WAREHOUSE);
        if (loginDatabaseName != null && !loginDatabaseName.equalsIgnoreCase(this.getDatabase())) {
            this.sqlWarnings.add(new SFException(ErrorCode.CONNECTION_ESTABLISHED_WITH_DIFFERENT_PROP, "Database", loginDatabaseName, this.getDatabase()));
        }
        if (loginSchemaName != null && !loginSchemaName.equalsIgnoreCase(this.getSchema())) {
            this.sqlWarnings.add(new SFException(ErrorCode.CONNECTION_ESTABLISHED_WITH_DIFFERENT_PROP, "Schema", loginSchemaName, this.getSchema()));
        }
        if (loginRole != null && !loginRole.equalsIgnoreCase(this.getRole())) {
            this.sqlWarnings.add(new SFException(ErrorCode.CONNECTION_ESTABLISHED_WITH_DIFFERENT_PROP, "Role", loginRole, this.getRole()));
        }
        if (loginWarehouse != null && !loginWarehouse.equalsIgnoreCase(this.getWarehouse())) {
            this.sqlWarnings.add(new SFException(ErrorCode.CONNECTION_ESTABLISHED_WITH_DIFFERENT_PROP, "Warehouse", loginWarehouse, this.getWarehouse()));
        }
        this.startHeartbeatForThisSession();
    }

    private boolean isSnowflakeAuthenticator() {
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.getConnectionPropertiesMap();
        String authenticator = (String)connectionPropertiesMap.get((Object)SFSessionProperty.AUTHENTICATOR);
        PrivateKey privateKey = (PrivateKey)connectionPropertiesMap.get((Object)SFSessionProperty.PRIVATE_KEY);
        return authenticator == null && privateKey == null && this.privateKeyFileLocation == null || ClientAuthnDTO.AuthenticatorType.SNOWFLAKE.name().equalsIgnoreCase(authenticator);
    }

    boolean isExternalbrowserAuthenticator() {
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.getConnectionPropertiesMap();
        String authenticator = (String)connectionPropertiesMap.get((Object)SFSessionProperty.AUTHENTICATOR);
        return ClientAuthnDTO.AuthenticatorType.EXTERNALBROWSER.name().equalsIgnoreCase(authenticator);
    }

    boolean isOKTAAuthenticator() {
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.getConnectionPropertiesMap();
        String authenticator = (String)connectionPropertiesMap.get((Object)SFSessionProperty.AUTHENTICATOR);
        return !Strings.isNullOrEmpty(authenticator) && authenticator.startsWith("https://");
    }

    boolean isUsernamePasswordMFAAuthenticator() {
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.getConnectionPropertiesMap();
        String authenticator = (String)connectionPropertiesMap.get((Object)SFSessionProperty.AUTHENTICATOR);
        return ClientAuthnDTO.AuthenticatorType.USERNAME_PASSWORD_MFA.name().equalsIgnoreCase(authenticator);
    }

    synchronized void renewSession(String prevSessionToken) throws SFException, SnowflakeSQLException {
        if (this.sessionToken != null && !this.sessionToken.equals(prevSessionToken)) {
            logger.debug("not renew session because session token has not been updated.", false);
            return;
        }
        SFLoginInput loginInput = new SFLoginInput();
        loginInput.setServerUrl(this.getServerUrl()).setSessionToken(this.sessionToken).setMasterToken(this.masterToken).setIdToken(this.idToken).setMfaToken(this.mfaToken).setLoginTimeout(this.loginTimeout).setDatabaseName(this.getDatabase()).setSchemaName(this.getSchema()).setRole(this.getRole()).setWarehouse(this.getWarehouse()).setOCSPMode(this.getOCSPMode()).setHttpClientSettingsKey(this.getHttpClientKey());
        SFLoginOutput loginOutput = SessionUtil.renewSession(loginInput);
        this.sessionToken = loginOutput.getSessionToken();
        this.masterToken = loginOutput.getMasterToken();
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    @Override
    public void close() throws SFException, SnowflakeSQLException {
        logger.debug(" public void close()", false);
        this.stopHeartbeatForThisSession();
        if (this.isClosed) {
            return;
        }
        SFLoginInput loginInput = new SFLoginInput();
        loginInput.setServerUrl(this.getServerUrl()).setSessionToken(this.sessionToken).setLoginTimeout(this.loginTimeout).setOCSPMode(this.getOCSPMode()).setHttpClientSettingsKey(this.getHttpClientKey());
        SessionUtil.closeSession(loginInput);
        this.closeTelemetryClient();
        this.getClientInfo().clear();
        this.isClosed = true;
    }

    @Override
    public void callHeartBeat(int timeout) throws Exception, SFException {
        if (timeout > 0) {
            this.callHeartBeatWithQueryTimeout(timeout);
        } else {
            this.heartbeat();
        }
    }

    private void callHeartBeatWithQueryTimeout(int timeout) throws Exception, SFException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        class HeartbeatTask
        implements Callable<Void> {
            HeartbeatTask() {
            }

            @Override
            public Void call() throws SQLException {
                try {
                    SFSession.this.heartbeat();
                }
                catch (SFException e) {
                    throw new SnowflakeSQLException((Throwable)e, e.getSqlState(), e.getVendorCode(), e.getParams());
                }
                return null;
            }
        }
        Future<Void> future = executor.submit(new HeartbeatTask());
        try {
            future.get(timeout, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw new SFException(ErrorCode.QUERY_CANCELED, new Object[0]);
        }
        finally {
            executor.shutdownNow();
        }
    }

    protected void startHeartbeatForThisSession() {
        if (this.getEnableHeartbeat() && !Strings.isNullOrEmpty(this.masterToken)) {
            logger.debug("start heartbeat, master token validity: " + this.masterTokenValidityInSeconds, new Object[0]);
            HeartbeatBackground.getInstance().addSession(this, this.masterTokenValidityInSeconds, this.heartbeatFrequency);
        } else {
            logger.debug("heartbeat not enabled for the session", false);
        }
    }

    protected void stopHeartbeatForThisSession() {
        if (this.getEnableHeartbeat() && !Strings.isNullOrEmpty(this.masterToken)) {
            logger.debug("stop heartbeat", false);
            HeartbeatBackground.getInstance().removeSession(this);
        } else {
            logger.debug("heartbeat not enabled for the session", false);
        }
    }

    protected void heartbeat() throws SFException, SQLException {
        logger.debug(" public void heartbeat()", false);
        if (this.isClosed) {
            return;
        }
        HttpPost postRequest = null;
        String requestId = UUID.randomUUID().toString();
        boolean retry = false;
        do {
            try {
                URIBuilder uriBuilder = new URIBuilder(this.getServerUrl());
                uriBuilder.addParameter(SF_QUERY_REQUEST_ID, requestId);
                uriBuilder.setPath(SF_PATH_SESSION_HEARTBEAT);
                postRequest = new HttpPost(uriBuilder.build());
                String prevSessionToken = this.sessionToken;
                postRequest.setHeader(SF_HEADER_AUTHORIZATION, "Snowflake Token=\"" + prevSessionToken + "\"");
                logger.debug("Executing heartbeat request: {}", postRequest.toString());
                int SF_HEARTBEAT_TIMEOUT = 300;
                String theResponse = HttpUtil.executeGeneralRequest((HttpRequestBase)postRequest, SF_HEARTBEAT_TIMEOUT, this.authTimeout, this.httpClientSocketTimeout, 0, this.getHttpClientKey());
                logger.debug("connection heartbeat response: {}", theResponse);
                JsonNode rootNode = mapper.readTree(theResponse);
                if (rootNode != null && 390112 == rootNode.path("code").asInt()) {
                    logger.debug("renew session and retry", false);
                    this.renewSession(prevSessionToken);
                    retry = true;
                    continue;
                }
                SnowflakeUtil.checkErrorAndThrowException(rootNode);
                retry = false;
            }
            catch (Throwable ex) {
                if (ex instanceof SnowflakeSQLException) {
                    throw (SnowflakeSQLException)ex;
                }
                logger.error("unexpected exception", ex);
                throw new SFException(ErrorCode.INTERNAL_ERROR, IncidentUtil.oneLiner("unexpected exception", ex));
            }
        } while (retry);
    }

    void injectedDelay() {
        AtomicInteger injectedDelay = this.getInjectedDelay();
        int d = injectedDelay.get();
        if (d != 0) {
            injectedDelay.set(0);
            try {
                logger.trace("delayed for {}", d);
                Thread.sleep(d);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public int getInjectSocketTimeout() {
        return this.injectSocketTimeout;
    }

    public void setInjectSocketTimeout(int injectSocketTimeout) {
        this.injectSocketTimeout = injectSocketTimeout;
    }

    @Override
    public int getNetworkTimeoutInMilli() {
        return this.networkTimeoutInMilli;
    }

    @Override
    public int getAuthTimeout() {
        return this.authTimeout;
    }

    @Override
    public int getHttpClientSocketTimeout() {
        return this.httpClientSocketTimeout;
    }

    @Override
    public int getHttpClientConnectionTimeout() {
        return this.httpClientConnectionTimeout;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public int getInjectClientPause() {
        return this.injectClientPause;
    }

    public void setInjectClientPause(int injectClientPause) {
        this.injectClientPause = injectClientPause;
    }

    protected int getAndIncrementSequenceId() {
        return this.sequenceId.getAndIncrement();
    }

    @Override
    public boolean getEnableCombineDescribe() {
        return this.enableCombineDescribe;
    }

    @Override
    public void setEnableCombineDescribe(boolean enable) {
        this.enableCombineDescribe = enable;
    }

    @Override
    public synchronized Telemetry getTelemetryClient() {
        if (this.telemetryClient == null) {
            if (this.getUrl() == null) {
                logger.error("Telemetry client created before session properties set.", false);
                return null;
            }
            this.telemetryClient = TelemetryClient.createTelemetry(this);
        }
        return this.telemetryClient;
    }

    public void closeTelemetryClient() {
        if (this.telemetryClient != null) {
            this.telemetryClient.close();
        }
    }

    public String getIdToken() {
        return this.idToken;
    }

    public String getMfaToken() {
        return this.mfaToken;
    }

    void setCurrentObjects(SFLoginInput loginInput, SFLoginOutput loginOutput) {
        this.sessionToken = loginOutput.getSessionToken();
        this.runInternalCommand("USE ROLE IDENTIFIER(?)", loginInput.getRole());
        this.runInternalCommand("USE WAREHOUSE IDENTIFIER(?)", loginInput.getWarehouse());
        this.runInternalCommand("USE DATABASE IDENTIFIER(?)", loginInput.getDatabaseName());
        this.runInternalCommand("USE SCHEMA IDENTIFIER(?)", loginInput.getSchemaName());
        SFBaseResultSet result = this.runInternalCommand("SELECT ?", "1");
        loginOutput.setSessionDatabase(this.getDatabase());
        loginOutput.setSessionSchema(this.getSchema());
        loginOutput.setSessionWarehouse(this.getWarehouse());
        loginOutput.setSessionRole(this.getRole());
        loginOutput.setIdToken(loginInput.getIdToken());
        if (result != null) {
            loginOutput.setCommonParams(result.parameters);
        }
    }

    private SFBaseResultSet runInternalCommand(String sql, String value) {
        if (value == null) {
            return null;
        }
        try {
            HashMap<String, ParameterBindingDTO> bindValues = new HashMap<String, ParameterBindingDTO>();
            bindValues.put("1", new ParameterBindingDTO("TEXT", value));
            SFStatement statement = new SFStatement(this);
            return statement.executeQueryInternal(sql, bindValues, false, true, false, null);
        }
        catch (SQLException | SFException ex) {
            logger.debug("Failed to run a command: {}, err={}", sql, ex);
            return null;
        }
    }

    @Override
    public SnowflakeConnectString getSnowflakeConnectionString() {
        return this.sfConnStr;
    }

    public void setSnowflakeConnectionString(SnowflakeConnectString connStr) {
        this.sfConnStr = connStr;
    }

    private void performSanityCheckOnProperties() throws SFException {
        boolean useProxy;
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.getConnectionPropertiesMap();
        for (SFSessionProperty property : SFSessionProperty.values()) {
            if (!property.isRequired() || connectionPropertiesMap.containsKey((Object)property)) continue;
            switch (property) {
                case SERVER_URL: {
                    throw new SFException(ErrorCode.MISSING_SERVER_URL, new Object[0]);
                }
            }
            throw new SFException(ErrorCode.MISSING_CONNECTION_PROPERTY, property.getPropertyKey());
        }
        if (this.isSnowflakeAuthenticator() || this.isOKTAAuthenticator() || this.isUsernamePasswordMFAAuthenticator()) {
            String userName = (String)connectionPropertiesMap.get((Object)SFSessionProperty.USER);
            if (Strings.isNullOrEmpty(userName)) {
                throw new SFException(ErrorCode.MISSING_USERNAME, new Object[0]);
            }
            String password = (String)connectionPropertiesMap.get((Object)SFSessionProperty.PASSWORD);
            if (Strings.isNullOrEmpty(password)) {
                throw new SFException(ErrorCode.MISSING_PASSWORD, new Object[0]);
            }
        }
        if ((useProxy = ((Boolean)connectionPropertiesMap.getOrDefault((Object)SFSessionProperty.USE_PROXY, false)).booleanValue()) && (!connectionPropertiesMap.containsKey((Object)SFSessionProperty.PROXY_HOST) || connectionPropertiesMap.get((Object)SFSessionProperty.PROXY_HOST) == null || ((String)connectionPropertiesMap.get((Object)SFSessionProperty.PROXY_HOST)).isEmpty() || !connectionPropertiesMap.containsKey((Object)SFSessionProperty.PROXY_PORT) || connectionPropertiesMap.get((Object)SFSessionProperty.PROXY_HOST) == null)) {
            throw new SFException(ErrorCode.INVALID_PROXY_PROPERTIES, "Both proxy host and port values are needed.");
        }
    }

    @Override
    public List<DriverPropertyInfo> checkProperties() {
        boolean useProxy;
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.getConnectionPropertiesMap();
        for (SFSessionProperty property : SFSessionProperty.values()) {
            if (!property.isRequired() || connectionPropertiesMap.containsKey((Object)property)) continue;
            this.missingProperties.add(this.addNewDriverProperty(property.getPropertyKey(), null));
        }
        if (this.isSnowflakeAuthenticator() || this.isOKTAAuthenticator()) {
            String password;
            String userName = (String)connectionPropertiesMap.get((Object)SFSessionProperty.USER);
            if (Strings.isNullOrEmpty(userName)) {
                this.missingProperties.add(this.addNewDriverProperty(SFSessionProperty.USER.getPropertyKey(), "username for account"));
            }
            if (Strings.isNullOrEmpty(password = (String)connectionPropertiesMap.get((Object)SFSessionProperty.PASSWORD))) {
                this.missingProperties.add(this.addNewDriverProperty(SFSessionProperty.PASSWORD.getPropertyKey(), "password for account"));
            }
        }
        if (useProxy = ((Boolean)connectionPropertiesMap.getOrDefault((Object)SFSessionProperty.USE_PROXY, false)).booleanValue()) {
            if (!connectionPropertiesMap.containsKey((Object)SFSessionProperty.PROXY_HOST)) {
                this.missingProperties.add(this.addNewDriverProperty(SFSessionProperty.PROXY_HOST.getPropertyKey(), "proxy host name"));
            }
            if (!connectionPropertiesMap.containsKey((Object)SFSessionProperty.PROXY_PORT)) {
                this.missingProperties.add(this.addNewDriverProperty(SFSessionProperty.PROXY_PORT.getPropertyKey(), "proxy port; should be an integer"));
            }
        }
        return this.missingProperties;
    }

    private DriverPropertyInfo addNewDriverProperty(String name, String description) {
        DriverPropertyInfo info = new DriverPropertyInfo(name, null);
        info.description = description;
        return info;
    }

    @Override
    public boolean isAsyncSession() {
        return !this.activeAsyncQueries.isEmpty();
    }
}

