/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.monitoring;

import net.snowflake.client.jdbc.internal.amazonaws.SdkClientException;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.ThreadSafe;
import net.snowflake.client.jdbc.internal.amazonaws.monitoring.CsmConfiguration;
import net.snowflake.client.jdbc.internal.amazonaws.monitoring.CsmConfigurationProvider;

@ThreadSafe
public final class EnvironmentVariableCsmConfigurationProvider
implements CsmConfigurationProvider {
    @Override
    public CsmConfiguration getConfiguration() {
        String enabled = System.getenv("AWS_CSM_ENABLED");
        if (enabled == null) {
            throw new SdkClientException("Unable to load Client Side Monitoring configurations from environment variables!");
        }
        String port = System.getenv("AWS_CSM_PORT");
        String clientId = System.getenv("AWS_CSM_CLIENT_ID");
        clientId = clientId == null ? "" : clientId;
        try {
            int portNumber = port == null ? 31000 : Integer.parseInt(port);
            return new CsmConfiguration(Boolean.parseBoolean(enabled), portNumber, clientId);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to load Client Side Monitoring configurations from environment variables!", e);
        }
    }
}

