/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.retry;

import net.snowflake.client.jdbc.internal.amazonaws.AmazonClientException;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonWebServiceRequest;
import net.snowflake.client.jdbc.internal.amazonaws.ClientConfiguration;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.retry.RetryPolicy;
import net.snowflake.client.jdbc.internal.amazonaws.retry.v2.RetryPolicyContext;
import net.snowflake.client.jdbc.internal.amazonaws.util.ValidationUtils;

@SdkInternalApi
public class RetryPolicyAdapter
implements net.snowflake.client.jdbc.internal.amazonaws.retry.v2.RetryPolicy {
    private final RetryPolicy legacyRetryPolicy;
    private final ClientConfiguration clientConfiguration;

    public RetryPolicyAdapter(RetryPolicy legacyRetryPolicy, ClientConfiguration clientConfiguration) {
        this.legacyRetryPolicy = ValidationUtils.assertNotNull(legacyRetryPolicy, "legacyRetryPolicy");
        this.clientConfiguration = ValidationUtils.assertNotNull(clientConfiguration, "clientConfiguration");
    }

    @Override
    public long computeDelayBeforeNextRetry(RetryPolicyContext context) {
        return this.legacyRetryPolicy.getBackoffStrategy().delayBeforeNextRetry((AmazonWebServiceRequest)context.originalRequest(), (AmazonClientException)context.exception(), context.retriesAttempted());
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext context) {
        if (context.retriesAttempted() >= this.getMaxErrorRetry()) {
            return false;
        }
        return this.legacyRetryPolicy.getRetryCondition().shouldRetry((AmazonWebServiceRequest)context.originalRequest(), (AmazonClientException)context.exception(), context.retriesAttempted());
    }

    public RetryPolicy getLegacyRetryPolicy() {
        return this.legacyRetryPolicy;
    }

    private int getMaxErrorRetry() {
        if (this.legacyRetryPolicy.isMaxErrorRetryInClientConfigHonored() && this.clientConfiguration.getMaxErrorRetry() >= 0) {
            return this.clientConfiguration.getMaxErrorRetry();
        }
        return this.legacyRetryPolicy.getMaxErrorRetry();
    }
}

