/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.transform;

import net.snowflake.client.jdbc.internal.amazonaws.AmazonServiceException;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.ThreadSafe;
import net.snowflake.client.jdbc.internal.amazonaws.transform.AbstractErrorUnmarshaller;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.TreeNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.DeserializationFeature;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.PropertyNamingStrategy;

@SdkInternalApi
@ThreadSafe
public class JsonErrorUnmarshaller
extends AbstractErrorUnmarshaller<JsonNode> {
    public static final JsonErrorUnmarshaller DEFAULT_UNMARSHALLER = new JsonErrorUnmarshaller(AmazonServiceException.class, null);
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setPropertyNamingStrategy(new PropertyNamingStrategy.PascalCaseStrategy());
    private final String handledErrorCode;

    public JsonErrorUnmarshaller(Class<? extends AmazonServiceException> exceptionClass, String handledErrorCode) {
        super(exceptionClass);
        this.handledErrorCode = handledErrorCode;
    }

    @Override
    public AmazonServiceException unmarshall(JsonNode jsonContent) throws Exception {
        return (AmazonServiceException)MAPPER.treeToValue((TreeNode)jsonContent, this.exceptionClass);
    }

    public boolean matchErrorCode(String actualErrorCode) {
        if (this.handledErrorCode == null) {
            return true;
        }
        return this.handledErrorCode.equals(actualErrorCode);
    }
}

