/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.snowflake.client.core.MetaDataOfBinds;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFResultSetMetaData;
import net.snowflake.client.core.SFStatementType;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializable;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializableV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFBinaryFormat;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SnowflakeDateTimeFormat;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public abstract class SFBaseResultSet {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SFBaseResultSet.class);
    boolean wasNull = false;
    protected SFResultSetMetaData resultSetMetaData = null;
    protected int row = 0;
    protected Map<String, Object> parameters = new HashMap<String, Object>();
    SnowflakeDateTimeFormat timestampNTZFormatter;
    SnowflakeDateTimeFormat timestampLTZFormatter;
    SnowflakeDateTimeFormat timestampTZFormatter;
    SnowflakeDateTimeFormat dateFormatter;
    SnowflakeDateTimeFormat timeFormatter;
    boolean honorClientTZForTimestampNTZ = true;
    SFBinaryFormat binaryFormatter;
    protected long resultVersion = 0L;
    protected int numberOfBinds = 0;
    protected List<MetaDataOfBinds> metaDataOfBinds = new ArrayList<MetaDataOfBinds>();
    protected SFBaseSession session;
    protected boolean isClosed;
    protected SnowflakeResultSetSerializableV1 resultSetSerializable;

    public abstract boolean isLast();

    public abstract boolean isAfterLast();

    public abstract String getString(int var1) throws SFException;

    public abstract boolean getBoolean(int var1) throws SFException;

    public abstract byte getByte(int var1) throws SFException;

    public abstract short getShort(int var1) throws SFException;

    public abstract int getInt(int var1) throws SFException;

    public abstract long getLong(int var1) throws SFException;

    public abstract float getFloat(int var1) throws SFException;

    public abstract double getDouble(int var1) throws SFException;

    public abstract byte[] getBytes(int var1) throws SFException;

    public abstract Time getTime(int var1) throws SFException;

    public abstract Timestamp getTimestamp(int var1, TimeZone var2) throws SFException;

    public abstract Date getDate(int var1, TimeZone var2) throws SFException;

    public abstract Object getObject(int var1) throws SFException;

    public abstract BigDecimal getBigDecimal(int var1) throws SFException;

    public abstract BigDecimal getBigDecimal(int var1, int var2) throws SFException;

    public abstract SFStatementType getStatementType();

    public abstract void setStatementType(SFStatementType var1) throws SQLException;

    public abstract String getQueryId();

    public void setSession(SFBaseSession session) {
        this.session = session;
    }

    public SFBaseSession getSession() {
        return this.session;
    }

    public boolean next() throws SFException, SnowflakeSQLException {
        logger.debug("public boolean next()", false);
        return false;
    }

    public void close() throws SnowflakeSQLException {
        logger.debug("public void close()", false);
        this.resultSetMetaData = null;
        this.isClosed = true;
    }

    public boolean wasNull() {
        logger.debug("public boolean wasNull() returning {}", this.wasNull);
        return this.wasNull;
    }

    public SFResultSetMetaData getMetaData() throws SFException {
        return this.resultSetMetaData;
    }

    public int getRow() throws SQLException {
        return this.row;
    }

    public boolean absolute(int row) throws SFException {
        throw new SFException(ErrorCode.FEATURE_UNSUPPORTED, "seek to a specific row");
    }

    public boolean relative(int rows) throws SFException {
        throw new SFException(ErrorCode.FEATURE_UNSUPPORTED, "seek to a row relative to current row");
    }

    public boolean previous() throws SFException {
        throw new SFException(ErrorCode.FEATURE_UNSUPPORTED, "seek to a previous row");
    }

    public int getNumberOfBinds() {
        return this.numberOfBinds;
    }

    public List<MetaDataOfBinds> getMetaDataOfBinds() {
        return this.metaDataOfBinds;
    }

    public boolean isFirst() {
        return this.row == 1;
    }

    public boolean isBeforeFirst() {
        return this.row == 0;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isArrayBindSupported() {
        return false;
    }

    public List<SnowflakeResultSetSerializable> getResultSetSerializables(long maxSizeInBytes) throws SQLException {
        return this.resultSetSerializable.splitBySize(maxSizeInBytes);
    }
}

