/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Pattern;
import net.snowflake.client.core.QueryStatus;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeBaseResultSet;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.client.jdbc.SnowflakeResultSetMetaDataV1;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializable;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializableV1;
import net.snowflake.client.jdbc.SnowflakeResultSetV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeStatementV1;

class SFAsyncResultSet
extends SnowflakeBaseResultSet
implements SnowflakeResultSet,
ResultSet {
    private final SFBaseResultSet sfBaseResultSet;
    private ResultSet resultSetForNext = new SnowflakeResultSetV1.EmptyResultSet();
    private boolean resultSetForNextInitialized = false;
    private String queryID;
    private SFSession session;
    private Statement extraStatement;
    private QueryStatus lastQueriedStatus = QueryStatus.NO_DATA;

    SFAsyncResultSet(SFBaseResultSet sfBaseResultSet, Statement statement) throws SQLException {
        super(statement);
        this.sfBaseResultSet = sfBaseResultSet;
        this.queryID = sfBaseResultSet.getQueryId();
        this.session = (SFSession)sfBaseResultSet.getSession();
        this.extraStatement = statement;
        try {
            this.resultSetMetaData = new SnowflakeResultSetMetaDataV1(sfBaseResultSet.getMetaData());
            this.resultSetMetaData.setQueryIdForAsyncResults(this.queryID);
            this.resultSetMetaData.setQueryType(SnowflakeResultSetMetaDataV1.QueryType.ASYNC);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLLoggedException((SFBaseSession)this.session, ex.getSqlState(), ex.getVendorCode(), ex.getCause(), ex.getParams());
        }
    }

    public SFAsyncResultSet(SFBaseResultSet sfBaseResultSet, SnowflakeResultSetSerializableV1 resultSetSerializable) throws SQLException {
        super(resultSetSerializable);
        this.queryID = sfBaseResultSet.getQueryId();
        this.sfBaseResultSet = sfBaseResultSet;
        try {
            this.resultSetMetaData = new SnowflakeResultSetMetaDataV1(sfBaseResultSet.getMetaData());
            this.resultSetMetaData.setQueryIdForAsyncResults(this.queryID);
            this.resultSetMetaData.setQueryType(SnowflakeResultSetMetaDataV1.QueryType.ASYNC);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLLoggedException((SFBaseSession)this.session, ex.getSqlState(), ex.getVendorCode(), ex.getCause(), ex.getParams());
        }
    }

    public SFAsyncResultSet(String queryID, Statement statement) throws SQLException {
        super(statement);
        this.sfBaseResultSet = null;
        queryID.trim();
        if (!Pattern.matches("[a-z0-9]{8}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{12}", queryID)) {
            throw new SQLException("The provided query ID " + queryID + " is invalid.", "22023");
        }
        this.queryID = queryID;
    }

    @Override
    protected void raiseSQLExceptionIfResultSetIsClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SnowflakeSQLException(ErrorCode.RESULTSET_ALREADY_CLOSED, new Object[0]);
        }
    }

    @Override
    public QueryStatus getStatus() throws SQLException {
        if (this.session == null) {
            throw new SQLException("Session not set");
        }
        if (this.queryID == null) {
            throw new SQLException("QueryID unknown");
        }
        if (this.lastQueriedStatus == QueryStatus.SUCCESS) {
            return this.lastQueriedStatus;
        }
        this.lastQueriedStatus = this.session.getQueryStatus(this.queryID);
        return this.lastQueriedStatus;
    }

    private void getRealResults() throws SQLException {
        if (!this.resultSetForNextInitialized) {
            if (this.lastQueriedStatus != QueryStatus.SUCCESS) {
                QueryStatus qs = this.getStatus();
                int noDataRetry = 0;
                int noDataMaxRetries = 30;
                int[] retryPattern = new int[]{1, 1, 2, 3, 4, 8, 10};
                int maxIndex = retryPattern.length - 1;
                int retry = 0;
                while (qs != QueryStatus.SUCCESS) {
                    if (!QueryStatus.isStillRunning(qs) && qs.getValue() != QueryStatus.SUCCESS.getValue()) {
                        throw new SQLException("Status of query associated with resultSet is " + qs.getDescription() + ". Results not generated.");
                    }
                    if (qs == QueryStatus.NO_DATA && ++noDataRetry >= 30) {
                        throw new SQLException("Cannot retrieve data on the status of this query. No information returned from server for queryID={}.", this.queryID);
                    }
                    try {
                        Thread.sleep(500 * retryPattern[retry]);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (retry < maxIndex) {
                        ++retry;
                    }
                    qs = this.getStatus();
                }
            }
            this.resultSetForNext = this.extraStatement.executeQuery("select * from table(result_scan('" + this.queryID + "'))");
            this.resultSetForNextInitialized = true;
        }
    }

    @Override
    public boolean next() throws SQLException {
        this.getMetaData();
        return this.resultSetForNext.next();
    }

    @Override
    public void close() throws SQLException {
        this.close(true);
    }

    public void close(boolean removeClosedResultSetFromStatement) throws SQLException {
        this.resultSetForNext.close();
        if (this.sfBaseResultSet != null) {
            this.sfBaseResultSet.close();
        }
        if (removeClosedResultSetFromStatement && this.statement.isWrapperFor(SnowflakeStatementV1.class)) {
            this.statement.unwrap(SnowflakeStatementV1.class).removeClosedResultSet(this);
        }
    }

    @Override
    public String getQueryID() {
        return this.queryID;
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetForNext.wasNull();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetForNext.getString(columnIndex);
    }

    public void setSession(SFSession session) {
        this.session = session;
    }

    public void setStatement(Statement statement) {
        this.extraStatement = statement;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetForNext.getBoolean(columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetForNext.getByte(columnIndex);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetForNext.getShort(columnIndex);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetForNext.getInt(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetForNext.getLong(columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetForNext.getFloat(columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetForNext.getDouble(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex, TimeZone tz) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetForNext.getDate(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetForNext.getTime(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, TimeZone tz) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetForNext.unwrap(SnowflakeResultSetV1.class).getTimestamp(columnIndex, tz);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        this.getRealResults();
        this.resultSetMetaData = (SnowflakeResultSetMetaDataV1)this.resultSetForNext.unwrap(SnowflakeResultSetV1.class).getMetaData();
        this.resultSetMetaData.setQueryIdForAsyncResults(this.queryID);
        this.resultSetMetaData.setQueryType(SnowflakeResultSetMetaDataV1.QueryType.ASYNC);
        return this.resultSetMetaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetForNext.getObject(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetForNext.getBigDecimal(columnIndex);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetForNext.getBigDecimal(columnIndex, scale);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetForNext.getBytes(columnIndex);
    }

    @Override
    public int getRow() throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetForNext.getRow();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetForNext.isFirst();
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.sfBaseResultSet != null) {
            return this.resultSetForNext.isClosed() && this.sfBaseResultSet.isClosed();
        }
        return this.resultSetForNext.isClosed();
    }

    @Override
    public boolean isLast() throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetForNext.isLast();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetForNext.isAfterLast();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return !this.resultSetForNextInitialized || this.resultSetForNext.isBeforeFirst();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        logger.debug("public boolean isWrapperFor(Class<?> iface)", false);
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        logger.debug("public <T> T unwrap(Class<T> iface)", false);
        if (!iface.isInstance(this)) {
            throw new SQLException(this.getClass().getName() + " not unwrappable from " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public List<SnowflakeResultSetSerializable> getResultSetSerializables(long maxSizeInBytes) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        this.getRealResults();
        return this.resultSetForNext.unwrap(SnowflakeResultSet.class).getResultSetSerializables(maxSizeInBytes);
    }
}

