/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.snowflake.client.core.Event;
import net.snowflake.client.core.EventUtil;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.SFOCSPException;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.OCSPErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.CloseableHttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpRequestBase;
import net.snowflake.client.jdbc.internal.apache.http.client.utils.URIBuilder;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.CloseableHttpClient;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryService;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.DecorrelatedJitterBackoff;
import net.snowflake.client.util.SecretDetector;

public class RestRequest {
    private static final SFLogger logger = SFLoggerFactory.getLogger(RestRequest.class);
    private static final String SF_REQUEST_GUID = "request_guid";
    private static final long minBackoffInMilli = 1000L;
    private static final long maxBackoffInMilli = 16000L;
    private static final int MIN_RETRY_COUNT = 1;

    public static CloseableHttpResponse execute(CloseableHttpClient httpClient, HttpRequestBase httpRequest, long retryTimeout, long authTimeout, int socketTimeout, int retryCount, int injectSocketTimeout, AtomicBoolean canceling, boolean withoutCookies, boolean includeRetryParameters, boolean includeRequestGuid, boolean retryHTTP403) throws SnowflakeSQLException {
        return RestRequest.execute(httpClient, httpRequest, retryTimeout, authTimeout, socketTimeout, retryCount, injectSocketTimeout, canceling, withoutCookies, includeRetryParameters, includeRequestGuid, retryHTTP403, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableHttpResponse execute(CloseableHttpClient httpClient, HttpRequestBase httpRequest, long retryTimeout, long authTimeout, int socketTimeout, int retryCount, int injectSocketTimeout, AtomicBoolean canceling, boolean withoutCookies, boolean includeRetryParameters, boolean includeRequestGuid, boolean retryHTTP403, boolean noRetry) throws SnowflakeSQLException {
        long startTime;
        CloseableHttpResponse response = null;
        String requestInfoScrubbed = SecretDetector.maskSASToken(httpRequest.toString());
        long startTimePerRequest = startTime = System.currentTimeMillis();
        long elapsedMilliForTransientIssues = 0L;
        long retryTimeoutInMilliseconds = retryTimeout * 1000L;
        long backoffInMilli = 1000L;
        long authTimeoutInMilli = authTimeout * 1000L;
        DecorrelatedJitterBackoff backoff = new DecorrelatedJitterBackoff(backoffInMilli, 16000L);
        int origSocketTimeout = 0;
        Exception savedEx = null;
        String breakRetryReason = "";
        while (true) {
            logger.debug("Retry count: {}", retryCount);
            try {
                startTimePerRequest = System.currentTimeMillis();
                if (withoutCookies) {
                    httpRequest.setConfig(HttpUtil.getRequestConfigWithoutCookies());
                }
                if (injectSocketTimeout != 0 && retryCount == 0) {
                    logger.debug("Injecting socket timeout by setting socket timeout to {} millisecond ", injectSocketTimeout);
                    httpRequest.setConfig(HttpUtil.getDefaultRequestConfigWithSocketTimeout(injectSocketTimeout, withoutCookies));
                }
                URIBuilder builder = new URIBuilder(httpRequest.getURI());
                if (includeRetryParameters && retryCount > 0) {
                    builder.setParameter("retryCount", String.valueOf(retryCount));
                    builder.setParameter("clientStartTime", String.valueOf(startTime));
                }
                if (authTimeout > 0L) {
                    int requestSocketAndConnectTimeout = (int)authTimeout * 1000;
                    httpRequest.setConfig(HttpUtil.getDefaultRequestConfigWithSocketAndConnectTimeout(requestSocketAndConnectTimeout, withoutCookies));
                }
                if (includeRequestGuid) {
                    builder.setParameter(SF_REQUEST_GUID, UUID.randomUUID().toString());
                }
                httpRequest.setURI(builder.build());
                response = httpClient.execute(httpRequest);
            }
            catch (Exception ex) {
                if (ex instanceof IllegalStateException) {
                    throw new SnowflakeSQLLoggedException(null, ErrorCode.INVALID_STATE, ex, ex.getMessage());
                }
                savedEx = ex;
                if (System.currentTimeMillis() - startTimePerRequest > 300000L) {
                    logger.error("HTTP request took longer than 5 min: {} sec", (System.currentTimeMillis() - startTimePerRequest) / 1000L);
                }
                StringWriter sw = new StringWriter();
                savedEx.printStackTrace(new PrintWriter(sw));
                Object[] objectArray = new Object[3];
                objectArray[0] = requestInfoScrubbed;
                objectArray[1] = ex.getLocalizedMessage();
                objectArray[2] = sw::toString;
                logger.debug("Exception encountered for: {}, {}, {}", objectArray);
            }
            finally {
                if (injectSocketTimeout != 0 && retryCount == 0) {
                    httpRequest.setConfig(HttpUtil.getDefaultRequestConfigWithSocketTimeout(origSocketTimeout, withoutCookies));
                }
            }
            if (noRetry || RestRequest.isCertificateRevoked(savedEx) || RestRequest.isNonRetryableHTTPCode(response, retryHTTP403)) {
                String msg = "Unknown cause";
                if (response != null) {
                    logger.debug("HTTP response code: {}", response.getStatusLine().getStatusCode());
                    msg = "StatusCode: " + response.getStatusLine().getStatusCode() + ", Reason: " + response.getStatusLine().getReasonPhrase();
                } else if (savedEx != null) {
                    Throwable rootCause = RestRequest.getRootCause(savedEx);
                    msg = rootCause.getMessage();
                }
                if (response == null || response.getStatusLine().getStatusCode() != 200) {
                    logger.debug("Error response not retryable, " + msg + ", request: {}", requestInfoScrubbed);
                    EventUtil.triggerBasicEvent(Event.EventType.NETWORK_ERROR, msg + ", Request: " + httpRequest.toString(), false);
                }
                breakRetryReason = "status code does not need retry";
                if (noRetry) {
                    logger.debug("HTTP retry disabled for this request. noRetry: {}", noRetry);
                    breakRetryReason = "retry is disabled";
                }
                retryCount = 0;
                break;
            }
            if (response != null) {
                logger.debug("HTTP response not ok: status code: {}, request: {}", response.getStatusLine().getStatusCode(), requestInfoScrubbed);
            } else if (savedEx != null) {
                logger.debug("Null response for cause: {}, request: {}", RestRequest.getRootCause(savedEx).getMessage(), requestInfoScrubbed);
            } else {
                logger.debug("Null response for request: {}", requestInfoScrubbed);
            }
            long elapsedMilliForLastCall = System.currentTimeMillis() - startTimePerRequest;
            if (canceling != null && canceling.get()) {
                logger.debug("Stop retrying since canceling is requested", false);
                breakRetryReason = "canceling is requested";
                break;
            }
            if (retryTimeoutInMilliseconds > 0L && (elapsedMilliForTransientIssues += elapsedMilliForLastCall) > retryTimeoutInMilliseconds && retryCount >= 1) {
                logger.error("Stop retrying since elapsed time due to network issues has reached timeout. Elapsed: {}(ms), timeout: {}(ms)", elapsedMilliForTransientIssues, retryTimeoutInMilliseconds);
                breakRetryReason = "retry timeout";
                TelemetryService.getInstance().logHttpRequestTelemetryEvent("HttpRequestRetryTimeout", httpRequest, injectSocketTimeout, canceling, withoutCookies, includeRetryParameters, includeRequestGuid, response, savedEx, breakRetryReason, retryTimeout, retryCount, "58030", ErrorCode.NETWORK_ERROR.getMessageCode());
                if (response == null && savedEx != null) {
                    throw new SnowflakeSQLException((Throwable)savedEx, ErrorCode.NETWORK_ERROR, "Exception encountered for HTTP request: " + savedEx.getMessage());
                }
                retryCount = 0;
                break;
            }
            if (authTimeout > 0L && elapsedMilliForTransientIssues > authTimeoutInMilli && (socketTimeout == 0 || elapsedMilliForTransientIssues < (long)socketTimeout) && String.valueOf(httpRequest.getURI()).contains("login-request")) {
                throw new SnowflakeSQLException(ErrorCode.AUTHENTICATOR_REQUEST_TIMEOUT, retryCount, true, elapsedMilliForTransientIssues / 1000L);
            }
            logger.debug("Retrying request: {}", requestInfoScrubbed);
            if (backoffInMilli > elapsedMilliForLastCall) {
                try {
                    logger.debug("sleeping in {}(ms)", backoffInMilli);
                    Thread.sleep(backoffInMilli);
                    elapsedMilliForTransientIssues += backoffInMilli;
                    backoffInMilli = backoff.nextSleepTime(backoffInMilli);
                }
                catch (InterruptedException ex1) {
                    logger.debug("Backoff sleep before retrying login got interrupted", false);
                }
            }
            ++retryCount;
            if (authTimeout > 0L && elapsedMilliForTransientIssues >= authTimeoutInMilli) {
                throw new SnowflakeSQLException(ErrorCode.AUTHENTICATOR_REQUEST_TIMEOUT, retryCount, false, elapsedMilliForTransientIssues / 1000L);
            }
            int numOfRetryToTriggerTelemetry = TelemetryService.getInstance().getNumOfRetryToTriggerTelemetry();
            if (retryCount == numOfRetryToTriggerTelemetry) {
                TelemetryService.getInstance().logHttpRequestTelemetryEvent(String.format("HttpRequestRetry%dTimes", numOfRetryToTriggerTelemetry), httpRequest, injectSocketTimeout, canceling, withoutCookies, includeRetryParameters, includeRequestGuid, response, savedEx, breakRetryReason, retryTimeout, retryCount, "58030", ErrorCode.NETWORK_ERROR.getMessageCode());
            }
            savedEx = null;
            httpRequest.releaseConnection();
        }
        if (response == null) {
            if (savedEx != null) {
                logger.error("Returning null response: cause: {}, request: {}", RestRequest.getRootCause(savedEx), requestInfoScrubbed);
            } else {
                logger.error("Returning null response for request: {}", requestInfoScrubbed);
            }
        } else if (response.getStatusLine().getStatusCode() != 200) {
            logger.error("Error response: HTTP Response code: {}, request: {}", response.getStatusLine().getStatusCode(), requestInfoScrubbed);
        }
        if (response == null || response.getStatusLine().getStatusCode() != 200) {
            String eventName = response == null ? "NullResponseHttpError" : (response.getStatusLine() == null ? "NullResponseStatusLine" : String.format("HttpError%d", response.getStatusLine().getStatusCode()));
            TelemetryService.getInstance().logHttpRequestTelemetryEvent(eventName, httpRequest, injectSocketTimeout, canceling, withoutCookies, includeRetryParameters, includeRequestGuid, response, savedEx, breakRetryReason, retryTimeout, retryCount, null, 0);
            if (response == null && savedEx != null) {
                throw new SnowflakeSQLException((Throwable)savedEx, ErrorCode.NETWORK_ERROR, "Exception encountered for HTTP request: " + savedEx.getMessage());
            }
        }
        return response;
    }

    static boolean isNonRetryableHTTPCode(CloseableHttpResponse response, boolean retryHTTP403) {
        return !(response == null || response.getStatusLine().getStatusCode() >= 500 && response.getStatusLine().getStatusCode() < 600 || response.getStatusLine().getStatusCode() == 408 || response.getStatusLine().getStatusCode() == 429 || retryHTTP403 && response.getStatusLine().getStatusCode() == 403);
    }

    private static boolean isCertificateRevoked(Exception ex) {
        if (ex == null) {
            return false;
        }
        Throwable ex0 = RestRequest.getRootCause(ex);
        if (!(ex0 instanceof SFOCSPException)) {
            return false;
        }
        SFOCSPException cause = (SFOCSPException)ex0;
        return cause.getErrorCode() == OCSPErrorCode.CERTIFICATE_STATUS_REVOKED;
    }

    private static Throwable getRootCause(Throwable ex) {
        Throwable ex0 = ex;
        while (ex0.getCause() != null) {
            ex0 = ex0.getCause();
        }
        return ex0;
    }
}

