/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.tracing;

import net.snowflake.client.jdbc.internal.google.api.core.BetaApi;
import net.snowflake.client.jdbc.internal.google.api.core.InternalApi;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ApiCallContext;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ResponseObserver;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ServerStreamingCallable;
import net.snowflake.client.jdbc.internal.google.api.gax.tracing.ApiTracer;
import net.snowflake.client.jdbc.internal.google.api.gax.tracing.ApiTracerFactory;
import net.snowflake.client.jdbc.internal.google.api.gax.tracing.SpanName;
import net.snowflake.client.jdbc.internal.google.api.gax.tracing.TracedResponseObserver;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.javax.annotation.Nonnull;

@BetaApi(value="The surface for tracing is not stable and might change in the future")
@InternalApi(value="For internal use by google-cloud-java clients only")
public final class TracedServerStreamingCallable<RequestT, ResponseT>
extends ServerStreamingCallable<RequestT, ResponseT> {
    @Nonnull
    private final ApiTracerFactory tracerFactory;
    @Nonnull
    private final SpanName spanName;
    @Nonnull
    private final ServerStreamingCallable<RequestT, ResponseT> innerCallable;

    public TracedServerStreamingCallable(@Nonnull ServerStreamingCallable<RequestT, ResponseT> innerCallable, @Nonnull ApiTracerFactory tracerFactory, @Nonnull SpanName spanName) {
        this.tracerFactory = Preconditions.checkNotNull(tracerFactory, "tracerFactory can't be null");
        this.spanName = Preconditions.checkNotNull(spanName, "spanName can't be null");
        this.innerCallable = Preconditions.checkNotNull(innerCallable, "innerCallable can't be null");
    }

    @Override
    public void call(RequestT request, ResponseObserver<ResponseT> responseObserver, ApiCallContext context) {
        ApiTracer tracer = this.tracerFactory.newTracer(context.getTracer(), this.spanName, ApiTracerFactory.OperationType.ServerStreaming);
        TracedResponseObserver<ResponseT> tracedObserver = new TracedResponseObserver<ResponseT>(tracer, responseObserver);
        context = context.withTracer(tracer);
        try {
            this.innerCallable.call(request, tracedObserver, context);
        }
        catch (RuntimeException e) {
            tracedObserver.onError(e);
            throw e;
        }
    }
}

