/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client;

import net.snowflake.client.core.SFException;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;

public class TestUtil {
    private static final SFLogger logger = SFLoggerFactory.getLogger(TestUtil.class);

    public static void assertSFException(int errorCode, TestRunInterface testCode) {
        try {
            testCode.run();
            Assert.fail();
        }
        catch (SFException e) {
            MatcherAssert.assertThat((Object)e.getVendorCode(), (Matcher)CoreMatchers.is((Object)errorCode));
        }
    }

    public static String systemGetEnv(String env) {
        try {
            return System.getenv(env);
        }
        catch (SecurityException ex) {
            logger.debug("Failed to get environment variable {}. Security exception raised: {}", new Object[]{env, ex.getMessage()});
            return null;
        }
    }

    @FunctionalInterface
    public static interface TestRunInterface {
        public void run() throws SFException;
    }
}

