/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.snowflake.client.config.SFClientConfig;
import net.snowflake.client.config.SFClientConfigParser;
import net.snowflake.client.jdbc.SnowflakeUtil;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class SFClientConfigParserTest {
    private static final String CONFIG_JSON = "{\"common\":{\"log_level\":\"info\",\"log_path\":\"/jdbc.log\"}}";

    @Test
    public void testloadSFClientConfigValidPath() {
        Path configFilePath = Paths.get("config.json", new String[0]);
        try {
            Files.write(configFilePath, CONFIG_JSON.getBytes(), new OpenOption[0]);
            SFClientConfig actualConfig = SFClientConfigParser.loadSFClientConfig((String)configFilePath.toString());
            Assert.assertEquals((Object)"info", (Object)actualConfig.getCommonProps().getLogLevel());
            Assert.assertEquals((Object)"/jdbc.log", (Object)actualConfig.getCommonProps().getLogPath());
            Files.delete(configFilePath);
        }
        catch (IOException e) {
            Assert.fail((String)"testloadSFClientConfigValidPath failed");
        }
    }

    @Test
    public void testloadSFClientConfigInValidPath() {
        String configFilePath = "InvalidPath";
        Object config = null;
        try {
            SFClientConfigParser.loadSFClientConfig((String)configFilePath.toString());
            Assert.fail((String)"testloadSFClientConfigInValidPath");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testloadSFClientConfigInValidJson() {
        try {
            String invalidJson = "invalidJson";
            Path configFilePath = Paths.get("config.json", new String[0]);
            Files.write(configFilePath, invalidJson.getBytes(), new OpenOption[0]);
            SFClientConfigParser.loadSFClientConfig((String)configFilePath.toString());
            Assert.fail((String)"testloadSFClientConfigInValidJson");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testloadSFClientConfigWithEnvVar() {
        Path configFilePath = Paths.get("config.json", new String[0]);
        try {
            Files.write(configFilePath, CONFIG_JSON.getBytes(), new OpenOption[0]);
            SnowflakeUtil.systemSetEnv((String)"SF_CLIENT_CONFIG_FILE", (String)"config.json");
            SFClientConfig actualConfig = SFClientConfigParser.loadSFClientConfig(null);
            Assert.assertEquals((Object)"info", (Object)actualConfig.getCommonProps().getLogLevel());
            Assert.assertEquals((Object)"/jdbc.log", (Object)actualConfig.getCommonProps().getLogPath());
            Files.delete(configFilePath);
            SnowflakeUtil.systemUnsetEnv((String)"SF_CLIENT_CONFIG_FILE");
        }
        catch (IOException e) {
            Assert.fail((String)"testloadSFClientConfigWithEnvVar failed");
        }
    }

    @Test
    public void testloadSFClientConfigWithDriverLoaction() {
        String configLocation = Paths.get(SFClientConfigParser.getConfigFilePathFromJDBCJarLocation(), "sf_client_config.json").toString();
        Path configFilePath = Paths.get(configLocation, new String[0]);
        try {
            Files.write(configFilePath, CONFIG_JSON.getBytes(), new OpenOption[0]);
            SFClientConfig actualConfig = SFClientConfigParser.loadSFClientConfig(null);
            Assert.assertEquals((Object)"info", (Object)actualConfig.getCommonProps().getLogLevel());
            Assert.assertEquals((Object)"/jdbc.log", (Object)actualConfig.getCommonProps().getLogPath());
            Files.delete(configFilePath);
        }
        catch (IOException e) {
            Assert.fail((String)"testloadSFClientConfigWithClasspath failed");
        }
    }

    @Test
    public void testloadSFClientConfigWithUserHome() {
        String tmpDirectory = SnowflakeUtil.systemGetProperty((String)"java.io.tmpdir");
        try (MockedStatic mockedSnowflakeUtil = Mockito.mockStatic(SnowflakeUtil.class);){
            mockedSnowflakeUtil.when(() -> SnowflakeUtil.systemGetProperty((String)"user.home")).thenReturn((Object)tmpDirectory);
            Path configFilePath = Paths.get(SnowflakeUtil.systemGetProperty((String)"user.home"), "sf_client_config.json");
            Files.write(configFilePath, CONFIG_JSON.getBytes(), new OpenOption[0]);
            SFClientConfig actualConfig = SFClientConfigParser.loadSFClientConfig(null);
            Assert.assertEquals((Object)"info", (Object)actualConfig.getCommonProps().getLogLevel());
            Assert.assertEquals((Object)"/jdbc.log", (Object)actualConfig.getCommonProps().getLogPath());
            Files.delete(configFilePath);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            Assert.fail((String)("testloadSFClientConfigWithUserHome failed: " + e.getMessage()));
        }
    }

    @Test
    public void testloadSFClientConfigWithTmpDirectory() {
        Path configFilePath = Paths.get(SnowflakeUtil.systemGetProperty((String)"java.io.tmpdir"), "sf_client_config.json");
        try {
            Files.write(configFilePath, CONFIG_JSON.getBytes(), new OpenOption[0]);
            SFClientConfig actualConfig = SFClientConfigParser.loadSFClientConfig(null);
            Assert.assertEquals((Object)"info", (Object)actualConfig.getCommonProps().getLogLevel());
            Assert.assertEquals((Object)"/jdbc.log", (Object)actualConfig.getCommonProps().getLogPath());
            Files.delete(configFilePath);
        }
        catch (IOException e) {
            Assert.fail((String)"testloadSFClientConfigWithTmpDirectory failed");
        }
    }

    @Test
    public void testloadSFClientNoConditionsMatch() throws IOException {
        SFClientConfig actualConfig = SFClientConfigParser.loadSFClientConfig(null);
        Assert.assertTrue((actualConfig == null ? 1 : 0) != 0);
    }

    @Test
    public void testgetConfigFileNameFromJDBCJarLocation() {
        String jdbcDirectoryPath = SFClientConfigParser.getConfigFilePathFromJDBCJarLocation();
        Assert.assertTrue((jdbcDirectoryPath != null && !jdbcDirectoryPath.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testgetConfigFileNameFromJDBCJarLocationForWindows() {
        try (MockedStatic mockedSnowflakeUtil = Mockito.mockStatic(SnowflakeUtil.class);){
            mockedSnowflakeUtil.when(() -> SnowflakeUtil.systemGetProperty((String)"os.name")).thenReturn((Object)"windows");
            String jdbcDirectoryPath = SFClientConfigParser.getConfigFilePathFromJDBCJarLocation();
            Assert.assertFalse((boolean)jdbcDirectoryPath.contains("/"));
        }
    }
}

