/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.microsoft.azure.storage.OperationContext;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Properties;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.core.AssertUtil;
import net.snowflake.client.core.Constants;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.SFException;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import org.junit.Assert;
import org.junit.Test;

public class CoreUtilsMiscellaneousTest {
    @Test
    public void testSnowflakeAssertTrue() {
        try {
            AssertUtil.assertTrue((boolean)false, (String)"Numbers do not match");
        }
        catch (SFException e) {
            Assert.assertEquals((Object)"JDBC driver internal error: Numbers do not match.", (Object)e.getMessage());
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testgetOS() {
        Constants.clearOSForTesting();
        String originalOS = SnowflakeUtil.systemGetProperty((String)"os.name");
        System.setProperty("os.name", "Windows");
        Assert.assertEquals((Object)Constants.OS.WINDOWS, (Object)Constants.getOS());
        Constants.clearOSForTesting();
        System.setProperty("os.name", "Linux");
        Assert.assertEquals((Object)Constants.OS.LINUX, (Object)Constants.getOS());
        Constants.clearOSForTesting();
        System.setProperty("os.name", "Macintosh");
        Assert.assertEquals((Object)Constants.OS.MAC, (Object)Constants.getOS());
        Constants.clearOSForTesting();
        System.setProperty("os.name", "Sunos");
        Assert.assertEquals((Object)Constants.OS.SOLARIS, (Object)Constants.getOS());
        Constants.clearOSForTesting();
        System.setProperty("os.name", originalOS);
    }

    @Test
    public void testHttpClientSettingsKey() {
        HttpClientSettingsKey testKey1 = new HttpClientSettingsKey(OCSPMode.FAIL_OPEN, "snowflakecomputing.com", 443, "*.foo.com", "testuser", "pw", "https", "jdbc", Boolean.valueOf(false));
        HttpClientSettingsKey testKey2 = new HttpClientSettingsKey(OCSPMode.FAIL_OPEN, "snowflakecomputing.com", 443, "*.baz.com", "testuser", "pw", "https", "jdbc", Boolean.valueOf(false));
        HttpClientSettingsKey testKey3 = new HttpClientSettingsKey(OCSPMode.FAIL_CLOSED, "jdbc", Boolean.valueOf(false));
        Assert.assertTrue((boolean)testKey1.equals((Object)testKey2));
        Assert.assertEquals((Object)"*.foo.com", (Object)testKey2.getNonProxyHosts());
        Assert.assertFalse((boolean)testKey1.equals((Object)testKey3));
    }

    @Test
    public void testSetProxyForS3() {
        HttpClientSettingsKey testKey = new HttpClientSettingsKey(OCSPMode.FAIL_OPEN, "snowflakecomputing.com", 443, "*.foo.com", "testuser", "pw", "https", "jdbc", Boolean.valueOf(false));
        ClientConfiguration clientConfig = new ClientConfiguration();
        HttpUtil.setProxyForS3((HttpClientSettingsKey)testKey, (ClientConfiguration)clientConfig);
        Assert.assertEquals((Object)Protocol.HTTPS, (Object)clientConfig.getProxyProtocol());
        Assert.assertEquals((Object)"snowflakecomputing.com", (Object)clientConfig.getProxyHost());
        Assert.assertEquals((long)443L, (long)clientConfig.getProxyPort());
        Assert.assertEquals((Object)"*.foo.com", (Object)clientConfig.getNonProxyHosts());
        Assert.assertEquals((Object)"pw", (Object)clientConfig.getProxyPassword());
        Assert.assertEquals((Object)"testuser", (Object)clientConfig.getProxyUsername());
    }

    @Test
    public void testSetSessionlessProxyForS3() throws SnowflakeSQLException {
        Properties props = new Properties();
        props.put("useProxy", "true");
        props.put("proxyHost", "localhost");
        props.put("proxyPort", "8084");
        props.put("proxyUser", "testuser");
        props.put("proxyPassword", "pw");
        props.put("nonProxyHosts", "baz.com | foo.com");
        props.put("proxyProtocol", "http");
        ClientConfiguration clientConfig = new ClientConfiguration();
        HttpUtil.setSessionlessProxyForS3((Properties)props, (ClientConfiguration)clientConfig);
        Assert.assertEquals((Object)Protocol.HTTP, (Object)clientConfig.getProxyProtocol());
        Assert.assertEquals((Object)"localhost", (Object)clientConfig.getProxyHost());
        Assert.assertEquals((long)8084L, (long)clientConfig.getProxyPort());
        Assert.assertEquals((Object)"baz.com | foo.com", (Object)clientConfig.getNonProxyHosts());
        Assert.assertEquals((Object)"pw", (Object)clientConfig.getProxyPassword());
        Assert.assertEquals((Object)"testuser", (Object)clientConfig.getProxyUsername());
        props.put("proxyPort", "invalidnumber");
        try {
            HttpUtil.setSessionlessProxyForS3((Properties)props, (ClientConfiguration)clientConfig);
        }
        catch (SnowflakeSQLException e) {
            Assert.assertEquals((long)ErrorCode.INVALID_PROXY_PROPERTIES.getMessageCode().intValue(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testSetProxyForAzure() {
        OperationContext op = new OperationContext();
        HttpClientSettingsKey testKey = new HttpClientSettingsKey(OCSPMode.FAIL_OPEN, "snowflakecomputing.com", 443, "*.foo.com", "testuser", "pw", "https", "jdbc", Boolean.valueOf(false));
        HttpUtil.setProxyForAzure((HttpClientSettingsKey)testKey, (OperationContext)op);
        Proxy proxy = op.getProxy();
        Assert.assertEquals((Object)((Object)Proxy.Type.HTTP), (Object)((Object)proxy.type()));
        Assert.assertEquals((Object)new InetSocketAddress("snowflakecomputing.com", 443), (Object)proxy.address());
    }

    @Test
    public void testSetSessionlessProxyForAzure() throws SnowflakeSQLException {
        Properties props = new Properties();
        props.put("useProxy", "true");
        props.put("proxyHost", "localhost");
        props.put("proxyPort", "8084");
        OperationContext op = new OperationContext();
        HttpUtil.setSessionlessProxyForAzure((Properties)props, (OperationContext)op);
        Proxy proxy = op.getProxy();
        Assert.assertEquals((Object)((Object)Proxy.Type.HTTP), (Object)((Object)proxy.type()));
        Assert.assertEquals((Object)new InetSocketAddress("localhost", 8084), (Object)proxy.address());
        props.put("proxyPort", "invalidnumber");
        try {
            HttpUtil.setSessionlessProxyForAzure((Properties)props, (OperationContext)op);
        }
        catch (SnowflakeSQLException e) {
            Assert.assertEquals((long)ErrorCode.INVALID_PROXY_PROPERTIES.getMessageCode().intValue(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testSizeOfHttpClientMapWithVariableNonProxyHosts() {
        HttpUtil.httpClient = new HashMap();
        HttpUtil.httpClientRoutePlanner = new HashMap();
        HttpClientSettingsKey key1 = new HttpClientSettingsKey(null, "localhost", 8080, "google.com | baz.com", "testuser", "pw", "https", "jdbc", Boolean.valueOf(false));
        HttpUtil.getHttpClient((HttpClientSettingsKey)key1);
        Assert.assertEquals((long)1L, (long)HttpUtil.httpClient.size());
        HttpClientSettingsKey key2 = new HttpClientSettingsKey(null, "localhost", 8080, "snowflake.com", "testuser", "pw", "https", "jdbc", Boolean.valueOf(false));
        HttpUtil.getHttpClient((HttpClientSettingsKey)key2);
        Assert.assertEquals((long)1L, (long)HttpUtil.httpClient.size());
        Assert.assertEquals((Object)"snowflake.com", (Object)key1.getNonProxyHosts());
        HttpClientSettingsKey key3 = new HttpClientSettingsKey(null, "differenthost.com", 8080, "snowflake.com", "testuser", "pw", "https", "jdbc", Boolean.valueOf(false));
        HttpUtil.getHttpClient((HttpClientSettingsKey)key3);
        Assert.assertEquals((long)2L, (long)HttpUtil.httpClient.size());
    }

    @Test
    public void testSizeOfHttpClientMapWithGzipAndUserAgentSuffix() {
        HttpUtil.httpClient = new HashMap();
        HttpClientSettingsKey key1 = new HttpClientSettingsKey(null, "localhost", 8080, "google.com | baz.com", "testuser", "pw", "https", "jdbc", Boolean.valueOf(false));
        HttpUtil.getHttpClient((HttpClientSettingsKey)key1);
        Assert.assertEquals((long)1L, (long)HttpUtil.httpClient.size());
        HttpClientSettingsKey key2 = new HttpClientSettingsKey(null, "localhost", 8080, "google.com | baz.com", "testuser", "pw", "https", "jdbc", Boolean.valueOf(true));
        HttpUtil.getHttpClient((HttpClientSettingsKey)key2);
        Assert.assertEquals((long)2L, (long)HttpUtil.httpClient.size());
        HttpClientSettingsKey key3 = new HttpClientSettingsKey(null, "localhost", 8080, "google.com | baz.com", "testuser", "pw", "https", "odbc", Boolean.valueOf(true));
        HttpUtil.getHttpClient((HttpClientSettingsKey)key3);
        Assert.assertEquals((long)3L, (long)HttpUtil.httpClient.size());
    }
}

