/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.zip.GZIPInputStream;
import net.snowflake.client.core.Event;
import net.snowflake.client.core.EventHandler;
import net.snowflake.client.core.EventUtil;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class EventHandlerTest {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    @Before
    public void setUp() throws IOException {
        this.tmpFolder.newFolder("snowflake_dumps");
        System.setProperty("snowflake.dump_path", this.tmpFolder.getRoot().getCanonicalPath());
    }

    @Test
    public void testPublishRecord() {
        LogRecord record = new LogRecord(Level.INFO, "test message");
        EventHandler handler = new EventHandler(10, 5000);
        Assert.assertEquals((long)0L, (long)handler.getLogBufferSize());
        handler.publish(record);
        Assert.assertEquals((long)1L, (long)handler.getLogBufferSize());
    }

    @Test
    public void testDumpLogBuffer() throws IOException {
        System.setProperty("snowflake.max_dumpfiles", "1");
        System.setProperty("snowflake.max_dumpdir_size_mb", "100");
        LogRecord record = new LogRecord(Level.INFO, "test message");
        EventHandler handler = new EventHandler(10, 5000);
        handler.publish(record);
        handler.flush();
        File logDumpFile = new File(EventUtil.getDumpPathPrefix() + "/sf_log_.dmp.gz");
        GZIPInputStream gzip = new GZIPInputStream(Files.newInputStream(logDumpFile.toPath(), new OpenOption[0]));
        StringWriter sWriter = new StringWriter();
        IOUtils.copy((InputStream)gzip, (Writer)sWriter, (String)"UTF-8");
        Assert.assertTrue((boolean)sWriter.toString().contains("test message"));
        gzip.close();
        sWriter.close();
        logDumpFile.delete();
    }

    @Test
    public void testEventFlusher() {
        EventHandler handler = new EventHandler(2, 1000);
        handler.startFlusher();
        handler.triggerBasicEvent(Event.EventType.STATE_TRANSITION, "test event");
        Assert.assertEquals((long)handler.getBufferSize(), (long)1L);
        handler.triggerBasicEvent(Event.EventType.STATE_TRANSITION, "test event 2");
        Assert.assertEquals((long)handler.getBufferSize(), (long)0L);
        handler.stopFlusher();
    }
}

