/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.GZIPInputStream;
import net.snowflake.client.core.BasicEvent;
import net.snowflake.client.core.Event;
import net.snowflake.client.core.EventUtil;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class EventTest {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    private File homeDirectory;
    private File dmpDirectory;

    @Before
    public void setUp() throws IOException {
        this.homeDirectory = this.tmpFolder.newFolder("homedir");
        this.dmpDirectory = this.tmpFolder.newFolder(new String[]{"homedir", "snowflake_dumps"});
    }

    @After
    public void tearDown() {
        this.dmpDirectory.delete();
    }

    @Test
    public void testEvent() {
        BasicEvent event = new BasicEvent(Event.EventType.NONE, "basic event");
        event.setType(Event.EventType.NETWORK_ERROR);
        event.setMessage("network timeout");
        Assert.assertEquals((long)1L, (long)event.getType().getId());
        Assert.assertEquals((Object)"network timeout", (Object)event.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteEventDumpLine() throws IOException {
        try {
            String dumpPath = this.homeDirectory.getCanonicalPath();
            System.setProperty("snowflake.dump_path", dumpPath);
            EventUtil.setDumpPathPrefixForTesting((String)dumpPath);
            BasicEvent event = new BasicEvent(Event.EventType.NETWORK_ERROR, "network timeout");
            event.writeEventDumpLine("network timeout after 60 seconds");
            String dmpPath1 = EventUtil.getDumpPathPrefix();
            String dmpPath2 = this.dmpDirectory.getCanonicalPath();
            Assert.assertEquals((String)("dump path is: " + EventUtil.getDumpPathPrefix()), (Object)dmpPath2, (Object)dmpPath1);
            File dumpFile = new File(EventUtil.getDumpPathPrefix() + "/sf_event_" + EventUtil.getDumpFileId() + ".dmp.gz");
            GZIPInputStream gzip = new GZIPInputStream(Files.newInputStream(dumpFile.toPath(), new OpenOption[0]));
            StringWriter sWriter = new StringWriter();
            IOUtils.copy((InputStream)gzip, (Writer)sWriter, (String)"UTF-8");
            Assert.assertTrue((boolean)sWriter.toString().contains("network timeout after 60 seconds"));
            gzip.close();
            sWriter.close();
            dumpFile.delete();
        }
        finally {
            System.clearProperty("snowflake.dump_path");
            EventUtil.setDumpPathPrefixForTesting((String)EventUtil.getDumpPathPrefix());
        }
    }
}

