/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.zip.GZIPInputStream;
import net.snowflake.client.category.TestCategoryCore;
import net.snowflake.client.core.EventUtil;
import net.snowflake.client.core.IncidentUtil;
import net.snowflake.client.jdbc.BaseJDBCTest;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;

@Category(value={TestCategoryCore.class})
public class IncidentUtilLatestIT
extends BaseJDBCTest {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    private static final String FILE_NAME = "sf_incident_123456.dmp.gz";

    @Test
    public void testOneLinerDescription() {
        String desc = IncidentUtil.oneLiner((String)"unexpected exception", (Throwable)new IOException("File not found"));
        Assert.assertEquals((Object)"unexpected exception java.io.IOException: File not found", (Object)desc.substring(0, 56));
    }

    @Test
    public void testDumpVmMetrics() throws IOException {
        String dumpPath = this.tmpFolder.newFolder().getCanonicalPath();
        System.setProperty("snowflake.dump_path", dumpPath);
        String incidentId = "123456";
        IncidentUtil.dumpVmMetrics((String)incidentId);
        String targetVMFileLocation = EventUtil.getDumpPathPrefix() + "/" + "sf_incident_" + incidentId + ".dmp.gz";
        GZIPInputStream gzip = new GZIPInputStream(new FileInputStream(targetVMFileLocation));
        StringWriter sWriter = new StringWriter();
        IOUtils.copy((InputStream)gzip, (Writer)sWriter, (String)"UTF-8");
        String output = sWriter.toString();
        Assert.assertEquals((Object)"\n\n\n---------------------------  METRICS ---------------------------\n\n", (Object)output.substring(0, 69));
        sWriter.close();
    }
}

