/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.category.TestCategoryArrow;
import net.snowflake.client.core.ChunkDownloader;
import net.snowflake.client.core.DownloaderMetrics;
import net.snowflake.client.core.SFArrowResultSet;
import net.snowflake.client.jdbc.ArrowResultChunk;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeResultChunk;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializableV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.telemetry.NoOpTelemetryClient;
import net.snowflake.client.jdbc.telemetry.Telemetry;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.Text;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;

@Category(value={TestCategoryArrow.class})
public class SFArrowResultSetIT {
    private Random random = new Random();
    protected BufferAllocator allocator = new RootAllocator(Long.MAX_VALUE);
    @Rule
    public TemporaryFolder resultFolder = new TemporaryFolder();

    @Test
    public void testNoOfflineData() throws Throwable {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("scale", "0");
        FieldType type = new FieldType(false, Types.MinorType.INT.getType(), null, customFieldMeta);
        fieldList.add(new Field("", type, null));
        Schema schema = new Schema(fieldList);
        Object[][] data = this.generateData(schema, 1000);
        File file = this.createArrowFile("testNoOfflineData_0_0_0", schema, data, 10);
        int dataSize = (int)file.length();
        byte[] dataBytes = new byte[dataSize];
        FileInputStream is = new FileInputStream(file);
        ((InputStream)is).read(dataBytes, 0, dataSize);
        SnowflakeResultSetSerializableV1 resultSetSerializable = new SnowflakeResultSetSerializableV1();
        resultSetSerializable.setRootAllocator(new RootAllocator(Long.MAX_VALUE));
        resultSetSerializable.setFirstChunkStringData(Base64.getEncoder().encodeToString(dataBytes));
        resultSetSerializable.setFirstChunkByteData(dataBytes);
        resultSetSerializable.setChunkFileCount(0);
        SFArrowResultSet resultSet = new SFArrowResultSet(resultSetSerializable, (Telemetry)new NoOpTelemetryClient(), false);
        int i = 0;
        while (resultSet.next()) {
            int val = resultSet.getInt(1);
            MatcherAssert.assertThat((Object)val, (Matcher)CoreMatchers.equalTo((Object)data[0][i]));
            ++i;
        }
        MatcherAssert.assertThat((Object)i, (Matcher)CoreMatchers.is((Object)1000));
    }

    @Test
    public void testEmptyResultSet() throws Throwable {
        SnowflakeResultSetSerializableV1 resultSetSerializable = new SnowflakeResultSetSerializableV1();
        resultSetSerializable.setFirstChunkStringData(Base64.getEncoder().encodeToString("".getBytes(StandardCharsets.UTF_8)));
        resultSetSerializable.setChunkFileCount(0);
        SFArrowResultSet resultSet = new SFArrowResultSet(resultSetSerializable, (Telemetry)new NoOpTelemetryClient(), false);
        MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)resultSet.isLast(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)resultSet.isAfterLast(), (Matcher)CoreMatchers.is((Object)true));
        resultSetSerializable.setFirstChunkStringData(null);
        resultSet = new SFArrowResultSet(resultSetSerializable, (Telemetry)new NoOpTelemetryClient(), false);
        MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)resultSet.isLast(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)resultSet.isAfterLast(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testOnlyOfflineData() throws Throwable {
        int colCount = 2;
        int chunkCount = 10;
        ArrayList<Field> fieldList = new ArrayList<Field>();
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("scale", "0");
        FieldType type = new FieldType(false, Types.MinorType.INT.getType(), null, customFieldMeta);
        for (int i = 0; i < 2; ++i) {
            fieldList.add(new Field("col_" + i, type, null));
        }
        Schema schema = new Schema(fieldList);
        ArrayList<Object[][]> dataLists = new ArrayList<Object[][]>();
        ArrayList<File> fileLists = new ArrayList<File>();
        for (int i = 0; i < 10; ++i) {
            Object[][] data = this.generateData(schema, 500);
            File file = this.createArrowFile("testOnlyOfflineData_" + i, schema, data, 10);
            dataLists.add(data);
            fileLists.add(file);
        }
        SnowflakeResultSetSerializableV1 resultSetSerializable = new SnowflakeResultSetSerializableV1();
        resultSetSerializable.setChunkDownloader((ChunkDownloader)new MockChunkDownloader(fileLists));
        resultSetSerializable.setChunkFileCount(10);
        SFArrowResultSet resultSet = new SFArrowResultSet(resultSetSerializable, (Telemetry)new NoOpTelemetryClient(), false);
        int index = 0;
        while (resultSet.next()) {
            for (int i = 0; i < 2; ++i) {
                int val = resultSet.getInt(i + 1);
                Integer expectedVal = (Integer)((Object[][])dataLists.get(index / 500))[i][index % 500];
                MatcherAssert.assertThat((Object)val, (Matcher)CoreMatchers.is((Object)expectedVal));
            }
            ++index;
        }
        MatcherAssert.assertThat((Object)index, (Matcher)CoreMatchers.is((Object)5000));
    }

    @Test
    public void testFirstResponseAndOfflineData() throws Throwable {
        int colCount = 2;
        int chunkCount = 10;
        ArrayList<Field> fieldList = new ArrayList<Field>();
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("scale", "0");
        FieldType type = new FieldType(false, Types.MinorType.INT.getType(), null, customFieldMeta);
        for (int i = 0; i < 2; ++i) {
            fieldList.add(new Field("col_" + i, type, null));
        }
        Schema schema = new Schema(fieldList);
        ArrayList<Object[][]> dataLists = new ArrayList<Object[][]>();
        ArrayList<File> fileLists = new ArrayList<File>();
        Object[][] firstChunkData = this.generateData(schema, 500);
        File arrowFile = this.createArrowFile("testOnlyOfflineData_0", schema, firstChunkData, 10);
        dataLists.add(firstChunkData);
        int dataSize = (int)arrowFile.length();
        byte[] dataBytes = new byte[dataSize];
        FileInputStream is = new FileInputStream(arrowFile);
        ((InputStream)is).read(dataBytes, 0, dataSize);
        SnowflakeResultSetSerializableV1 resultSetSerializable = new SnowflakeResultSetSerializableV1();
        resultSetSerializable.setFirstChunkStringData(Base64.getEncoder().encodeToString(dataBytes));
        resultSetSerializable.setFirstChunkByteData(dataBytes);
        resultSetSerializable.setChunkFileCount(10);
        resultSetSerializable.setRootAllocator(new RootAllocator(Long.MAX_VALUE));
        for (int i = 0; i < 10; ++i) {
            Object[][] data = this.generateData(schema, 500);
            File file = this.createArrowFile("testOnlyOfflineData_" + (i + 1), schema, data, 10);
            dataLists.add(data);
            fileLists.add(file);
        }
        resultSetSerializable.setChunkDownloader((ChunkDownloader)new MockChunkDownloader(fileLists));
        SFArrowResultSet resultSet = new SFArrowResultSet(resultSetSerializable, (Telemetry)new NoOpTelemetryClient(), false);
        int index = 0;
        while (resultSet.next()) {
            for (int i = 0; i < 2; ++i) {
                int val = resultSet.getInt(i + 1);
                Integer expectedVal = (Integer)((Object[][])dataLists.get(index / 500))[i][index % 500];
                MatcherAssert.assertThat((Object)val, (Matcher)CoreMatchers.is((Object)expectedVal));
            }
            ++index;
        }
        MatcherAssert.assertThat((Object)index, (Matcher)CoreMatchers.is((Object)5500));
    }

    Object[][] generateData(Schema schema, int rowCount) {
        Object[][] data = new Object[schema.getFields().size()][rowCount];
        block11: for (int i = 0; i < schema.getFields().size(); ++i) {
            Types.MinorType type = Types.getMinorTypeForArrowType((ArrowType)((Field)schema.getFields().get(i)).getType());
            switch (type) {
                case BIT: {
                    int j;
                    for (j = 0; j < rowCount; ++j) {
                        data[i][j] = this.random.nextBoolean();
                    }
                    continue block11;
                }
                case INT: {
                    int j;
                    for (j = 0; j < rowCount; ++j) {
                        data[i][j] = 0;
                    }
                    continue block11;
                }
                case DATEDAY: {
                    int j;
                    for (j = 0; j < rowCount; ++j) {
                        data[i][j] = Date.from(Instant.now());
                    }
                    continue block11;
                }
                case BIGINT: 
                case DECIMAL: {
                    int j;
                    for (j = 0; j < rowCount; ++j) {
                        data[i][j] = 154639183700000L;
                    }
                    continue block11;
                }
                case FLOAT8: {
                    int j;
                    for (j = 0; j < rowCount; ++j) {
                        data[i][j] = this.random.nextDouble();
                    }
                    continue block11;
                }
                case TINYINT: {
                    int j;
                    for (j = 0; j < rowCount; ++j) {
                        data[i][j] = (byte)this.random.nextInt(256);
                    }
                    continue block11;
                }
                case SMALLINT: {
                    int j;
                    for (j = 0; j < rowCount; ++j) {
                        data[i][j] = (short)this.random.nextInt(65536);
                    }
                    continue block11;
                }
                case VARBINARY: {
                    int j;
                    for (j = 0; j < rowCount; ++j) {
                        data[i][j] = RandomStringUtils.random((int)20).getBytes();
                    }
                    continue block11;
                }
                case VARCHAR: {
                    int j;
                    for (j = 0; j < rowCount; ++j) {
                        data[i][j] = RandomStringUtils.random((int)20);
                    }
                    continue block11;
                }
            }
        }
        return data;
    }

    File createArrowFile(String fileName, Schema schema, Object[][] data, int rowsPerRecordBatch) throws IOException {
        File file = this.resultFolder.newFile(fileName);
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);
        try (ArrowStreamWriter writer = new ArrowStreamWriter(root, (DictionaryProvider)new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]), (OutputStream)new FileOutputStream(file));){
            int rowsToAppend;
            writer.start();
            for (int i = 0; i < data[0].length; i += rowsToAppend) {
                rowsToAppend = Math.min(rowsPerRecordBatch, data[0].length - i);
                root.setRowCount(rowsToAppend);
                block19: for (int j = 0; j < data.length; ++j) {
                    FieldVector vector = (FieldVector)root.getFieldVectors().get(j);
                    switch (vector.getMinorType()) {
                        case BIT: {
                            this.writeBitToField(vector, data[j], i, rowsToAppend);
                            continue block19;
                        }
                        case INT: {
                            this.writeIntToField(vector, data[j], i, rowsToAppend);
                            continue block19;
                        }
                        case TINYINT: {
                            this.writeTinyIntToField(vector, data[j], i, rowsToAppend);
                            continue block19;
                        }
                        case SMALLINT: {
                            this.writeSmallIntToField(vector, data[j], i, rowsToAppend);
                            continue block19;
                        }
                        case DATEDAY: {
                            this.writeDateToField(vector, data[j], i, rowsToAppend);
                            continue block19;
                        }
                        case BIGINT: {
                            this.writeLongToField(vector, data[j], i, rowsToAppend);
                            continue block19;
                        }
                        case FLOAT8: {
                            this.writeDoubleToField(vector, data[j], i, rowsToAppend);
                            continue block19;
                        }
                        case VARBINARY: {
                            this.writeBytesToField(vector, data[j], i, rowsToAppend);
                            continue block19;
                        }
                        case VARCHAR: {
                            this.writeTextToField(vector, data[j], i, rowsToAppend);
                            continue block19;
                        }
                        case DECIMAL: {
                            this.writeDecimalToField(vector, data[j], i, rowsToAppend);
                            continue block19;
                        }
                        case STRUCT: {
                            this.writeTimestampStructToField(vector, data[j], data[j + 1], i, rowsToAppend);
                            ++j;
                        }
                    }
                }
                writer.writeBatch();
            }
        }
        return file;
    }

    private void writeLongToField(FieldVector fieldVector, Object[] data, int startIndex, int rowsToAppend) {
        BigIntVector vector = (BigIntVector)fieldVector;
        vector.setInitialCapacity(rowsToAppend);
        vector.allocateNew();
        vector.setNull(0);
        for (int i = 0; i < rowsToAppend; ++i) {
            vector.setSafe(i, 1, ((Long)data[startIndex + i]).longValue());
        }
        fieldVector.setValueCount(rowsToAppend);
    }

    private void writeBitToField(FieldVector fieldVector, Object[] data, int startIndex, int rowsToAppend) {
        BitVector vector = (BitVector)fieldVector;
        vector.setInitialCapacity(rowsToAppend);
        vector.allocateNew();
        vector.setNull(0);
        for (int i = 1; i < rowsToAppend; ++i) {
            int val = (Boolean)data[startIndex + i] == true ? 1 : 0;
            vector.setSafe(i, 1, val);
        }
        fieldVector.setValueCount(rowsToAppend);
    }

    private void writeDateToField(FieldVector fieldVector, Object[] data, int startIndex, int rowsToAppend) {
        DateDayVector datedayVector = (DateDayVector)fieldVector;
        datedayVector.setInitialCapacity(rowsToAppend);
        datedayVector.allocateNew();
        datedayVector.setNull(0);
        for (int i = 1; i < rowsToAppend; ++i) {
            datedayVector.setSafe(i, 1, (int)((Date)data[startIndex + i]).getTime() / 1000);
        }
        fieldVector.setValueCount(rowsToAppend);
    }

    private void writeDecimalToField(FieldVector fieldVector, Object[] data, int startIndex, int rowsToAppend) {
        DecimalVector datedayVector = (DecimalVector)fieldVector;
        datedayVector.setInitialCapacity(rowsToAppend);
        datedayVector.allocateNew();
        datedayVector.setNull(0);
        for (int i = 1; i < rowsToAppend; ++i) {
            datedayVector.setSafe(i, ((Long)data[startIndex + i]).longValue());
        }
        fieldVector.setValueCount(rowsToAppend);
    }

    private void writeDoubleToField(FieldVector fieldVector, Object[] data, int startIndex, int rowsToAppend) {
        Float8Vector vector = (Float8Vector)fieldVector;
        vector.setInitialCapacity(rowsToAppend);
        vector.allocateNew();
        vector.setNull(0);
        for (int i = 1; i < rowsToAppend; ++i) {
            vector.setSafe(i, 1, ((Double)data[startIndex + i]).doubleValue());
        }
        fieldVector.setValueCount(rowsToAppend);
    }

    private void writeIntToField(FieldVector fieldVector, Object[] data, int startIndex, int rowsToAppend) {
        IntVector intVector = (IntVector)fieldVector;
        intVector.setInitialCapacity(rowsToAppend);
        intVector.allocateNew();
        intVector.setNull(0);
        for (int i = 1; i < rowsToAppend; ++i) {
            intVector.setSafe(i, 1, ((Integer)data[startIndex + i]).intValue());
        }
        fieldVector.setValueCount(rowsToAppend);
    }

    private void writeSmallIntToField(FieldVector fieldVector, Object[] data, int startIndex, int rowsToAppend) {
        SmallIntVector intVector = (SmallIntVector)fieldVector;
        intVector.setInitialCapacity(rowsToAppend);
        intVector.allocateNew();
        intVector.setNull(0);
        for (int i = 1; i < rowsToAppend; ++i) {
            intVector.setSafe(i, 1, ((Short)data[startIndex + i]).shortValue());
        }
        fieldVector.setValueCount(rowsToAppend);
    }

    private void writeTinyIntToField(FieldVector fieldVector, Object[] data, int startIndex, int rowsToAppend) {
        TinyIntVector vector = (TinyIntVector)fieldVector;
        vector.setInitialCapacity(rowsToAppend);
        vector.allocateNew();
        vector.setNull(0);
        for (int i = 1; i < rowsToAppend; ++i) {
            vector.setSafe(i, 1, ((Byte)data[startIndex + i]).byteValue());
        }
        fieldVector.setValueCount(rowsToAppend);
    }

    private void writeBytesToField(FieldVector fieldVector, Object[] data, int startIndex, int rowsToAppend) {
        VarBinaryVector vector = (VarBinaryVector)fieldVector;
        vector.setInitialCapacity(rowsToAppend);
        vector.allocateNew();
        vector.setNull(0);
        for (int i = 1; i < rowsToAppend; ++i) {
            vector.setSafe(i, (byte[])data[startIndex + i], 0, ((byte[])data[startIndex + i]).length);
        }
        fieldVector.setValueCount(rowsToAppend);
    }

    private void writeTextToField(FieldVector fieldVector, Object[] data, int startIndex, int rowsToAppend) {
        VarCharVector intVector = (VarCharVector)fieldVector;
        intVector.setInitialCapacity(rowsToAppend);
        intVector.allocateNew();
        intVector.setNull(0);
        for (int i = 1; i < rowsToAppend; ++i) {
            intVector.setSafe(i, new Text((String)data[startIndex + i]));
        }
        fieldVector.setValueCount(rowsToAppend);
    }

    private void writeTimestampStructToField(FieldVector fieldVector, Object[] data, Object[] data2, int startIndex, int rowsToAppend) {
        StructVector vector = (StructVector)fieldVector;
        vector.setInitialCapacity(rowsToAppend);
        vector.allocateNew();
        vector.setNull(0);
        for (int i = 1; i < rowsToAppend; ++i) {
            List childVectors = vector.getChildrenFromFields();
            BigIntVector v1 = (BigIntVector)childVectors.get(0);
            v1.setSafe(i, 1, ((Long)data[startIndex + i]).longValue());
            IntVector v2 = (IntVector)childVectors.get(1);
            v2.setSafe(i, 1, ((Integer)data2[startIndex + i]).intValue());
        }
        fieldVector.setValueCount(rowsToAppend);
    }

    @Test
    public void testSortedResultChunkWithStructVectors() throws Throwable {
        Connection con = AbstractDriverIT.getConnection();
        Statement statement = con.createStatement();
        statement.execute("create or replace table teststructtimestamp (t1 timestamp_ltz)");
        ResultSet rs = statement.executeQuery("select * from teststructtimestamp");
        List resultSetSerializables = ((SnowflakeResultSet)rs).getResultSetSerializables(0x6400000L);
        SnowflakeResultSetSerializableV1 resultSetSerializable = (SnowflakeResultSetSerializableV1)resultSetSerializables.get(0);
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "TIMESTAMP_LTZ");
        customFieldMeta.put("scale", "38");
        FieldType fieldType = new FieldType(true, Types.MinorType.BIGINT.getType(), null, customFieldMeta);
        FieldType fieldType2 = new FieldType(true, Types.MinorType.INT.getType(), null, customFieldMeta);
        StructVector structVector = StructVector.empty((String)"testListVector", (BufferAllocator)this.allocator);
        LinkedList<Field> fieldList = new LinkedList<Field>();
        Field bigIntField = new Field("epoch", fieldType, null);
        Field intField = new Field("fraction", fieldType2, null);
        fieldList.add(bigIntField);
        fieldList.add(intField);
        FieldType structFieldType = new FieldType(true, Types.MinorType.STRUCT.getType(), null, customFieldMeta);
        Field structField = new Field("timestamp", structFieldType, fieldList);
        structVector.initializeChildrenFromFields(fieldList);
        LinkedList<Field> fieldListMajor = new LinkedList<Field>();
        fieldListMajor.add(structField);
        Schema dataSchema = new Schema(fieldList);
        Object[][] data = this.generateData(dataSchema, 1000);
        Schema schema = new Schema(fieldListMajor);
        File file = this.createArrowFile("testTimestamp", schema, data, 10);
        int dataSize = (int)file.length();
        byte[] dataBytes = new byte[dataSize];
        FileInputStream is = new FileInputStream(file);
        ((InputStream)is).read(dataBytes, 0, dataSize);
        resultSetSerializable.setRootAllocator(new RootAllocator(Long.MAX_VALUE));
        resultSetSerializable.setFirstChunkStringData(Base64.getEncoder().encodeToString(dataBytes));
        resultSetSerializable.setFirstChunkByteData(dataBytes);
        resultSetSerializable.setChunkFileCount(0);
        SFArrowResultSet resultSet = new SFArrowResultSet(resultSetSerializable, (Telemetry)new NoOpTelemetryClient(), true);
        for (int i = 0; i < 1000; ++i) {
            resultSet.next();
        }
        Assert.assertEquals(null, (Object)resultSet.getObject(1));
        Assert.assertFalse((boolean)resultSet.next());
        statement.execute("drop table teststructtimestamp;");
        con.close();
    }

    @Test
    public void testSortedResultChunk() throws Throwable {
        Connection con = AbstractDriverIT.getConnection();
        Statement statement = con.createStatement();
        statement.execute("create or replace table alltypes (i1 int, d1 date, b1 bigint, f1 float, s1 smallint, t1 tinyint, b2 binary, t2 text, b3 boolean, d2 decimal)");
        ResultSet rs = statement.executeQuery("select * from alltypes");
        List resultSetSerializables = ((SnowflakeResultSet)rs).getResultSetSerializables(0x6400000L);
        SnowflakeResultSetSerializableV1 resultSetSerializable = (SnowflakeResultSetSerializableV1)resultSetSerializables.get(0);
        ArrayList<Field> fieldList = new ArrayList<Field>();
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("scale", "0");
        FieldType type = new FieldType(false, Types.MinorType.INT.getType(), null, customFieldMeta);
        fieldList.add(new Field("", type, null));
        customFieldMeta.put("logicalType", "DATE");
        type = new FieldType(false, Types.MinorType.DATEDAY.getType(), null, customFieldMeta);
        fieldList.add(new Field("", type, null));
        customFieldMeta.put("logicalType", "FIXED");
        type = new FieldType(false, Types.MinorType.BIGINT.getType(), null, customFieldMeta);
        fieldList.add(new Field("", type, null));
        customFieldMeta.put("logicalType", "REAL");
        type = new FieldType(false, Types.MinorType.FLOAT8.getType(), null, customFieldMeta);
        fieldList.add(new Field("", type, null));
        customFieldMeta.put("logicalType", "FIXED");
        type = new FieldType(false, Types.MinorType.SMALLINT.getType(), null, customFieldMeta);
        fieldList.add(new Field("", type, null));
        customFieldMeta.put("logicalType", "FIXED");
        type = new FieldType(false, Types.MinorType.TINYINT.getType(), null, customFieldMeta);
        fieldList.add(new Field("", type, null));
        customFieldMeta.put("logicalType", "BINARY");
        type = new FieldType(false, Types.MinorType.VARBINARY.getType(), null, customFieldMeta);
        fieldList.add(new Field("", type, null));
        customFieldMeta.put("logicalType", "TEXT");
        type = new FieldType(false, Types.MinorType.VARCHAR.getType(), null, customFieldMeta);
        fieldList.add(new Field("", type, null));
        customFieldMeta.put("logicalType", "BOOLEAN");
        type = new FieldType(false, Types.MinorType.BIT.getType(), null, customFieldMeta);
        fieldList.add(new Field("", type, null));
        customFieldMeta.put("logicalType", "REAL");
        type = new FieldType(false, (ArrowType)new ArrowType.Decimal(38, 16, 128), null, customFieldMeta);
        fieldList.add(new Field("", type, null));
        Schema schema = new Schema(fieldList);
        Object[][] data = this.generateData(schema, 1000);
        File file = this.createArrowFile("testVectorTypes", schema, data, 10);
        int dataSize = (int)file.length();
        byte[] dataBytes = new byte[dataSize];
        FileInputStream is = new FileInputStream(file);
        ((InputStream)is).read(dataBytes, 0, dataSize);
        resultSetSerializable.setRootAllocator(new RootAllocator(Long.MAX_VALUE));
        resultSetSerializable.setFirstChunkStringData(Base64.getEncoder().encodeToString(dataBytes));
        resultSetSerializable.setFirstChunkByteData(dataBytes);
        resultSetSerializable.setChunkFileCount(0);
        SFArrowResultSet resultSet = new SFArrowResultSet(resultSetSerializable, (Telemetry)new NoOpTelemetryClient(), true);
        for (int i = 0; i < 1000; ++i) {
            resultSet.next();
        }
        Assert.assertEquals(null, (Object)resultSet.getObject(1));
        Assert.assertFalse((boolean)resultSet.next());
        statement.execute("drop table alltypes;");
        con.close();
    }

    private class MockChunkDownloader
    implements ChunkDownloader {
        private List<File> resultFileNames;
        private int currentFileIndex;
        private RootAllocator rootAllocator = new RootAllocator(Long.MAX_VALUE);

        MockChunkDownloader(List<File> resultFileNames) {
            this.resultFileNames = resultFileNames;
            this.currentFileIndex = 0;
        }

        public SnowflakeResultChunk getNextChunkToConsume() throws SnowflakeSQLException {
            if (this.currentFileIndex < this.resultFileNames.size()) {
                ArrowResultChunk resultChunk = new ArrowResultChunk("", 0, 0, 0, this.rootAllocator, null);
                try {
                    FileInputStream is = new FileInputStream(this.resultFileNames.get(this.currentFileIndex));
                    resultChunk.readArrowStream((InputStream)is);
                    ++this.currentFileIndex;
                    return resultChunk;
                }
                catch (IOException e) {
                    throw new SnowflakeSQLException(ErrorCode.INTERNAL_ERROR, new Object[]{"Failed to read data"});
                }
            }
            return null;
        }

        public DownloaderMetrics terminate() {
            return null;
        }
    }
}

