/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.jdbc.ErrorCode;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class SFSessionPropertyTest {
    @Test
    public void testCheckApplicationName() throws SFException {
        String[] validApplicationName = new String[]{"test1234", "test_1234", "test-1234", "test.1234"};
        String[] invalidApplicationName = new String[]{"1234test", "test$A", "test<script>"};
        for (String valid : validApplicationName) {
            Object value = SFSessionProperty.checkPropertyValue((SFSessionProperty)SFSessionProperty.APPLICATION, (Object)valid);
            MatcherAssert.assertThat((Object)((String)value), (Matcher)CoreMatchers.is((Object)valid));
        }
        for (String invalid : invalidApplicationName) {
            try {
                SFSessionProperty.checkPropertyValue((SFSessionProperty)SFSessionProperty.APPLICATION, (Object)invalid);
                Assert.fail();
            }
            catch (SFException e) {
                MatcherAssert.assertThat((Object)e.getVendorCode(), (Matcher)CoreMatchers.is((Object)ErrorCode.INVALID_PARAMETER_VALUE.getMessageCode()));
            }
        }
    }

    @Test
    public void testCustomSuffixForUserAgentHeaders() {
        String customSuffix = "test-suffix";
        String userAgentHeader = HttpUtil.buildUserAgent((String)customSuffix);
        MatcherAssert.assertThat((String)"user-agent header should contain the suffix ", (Object)userAgentHeader, (Matcher)CoreMatchers.endsWith((String)customSuffix));
    }

    @Test
    public void testInvalidMaxRetries() {
        try {
            SFSessionProperty.checkPropertyValue((SFSessionProperty)SFSessionProperty.MAX_HTTP_RETRIES, (Object)"invalidValue");
            Assert.fail((String)"testInvalidMaxRetries");
        }
        catch (SFException e) {
            MatcherAssert.assertThat((Object)e.getVendorCode(), (Matcher)CoreMatchers.is((Object)ErrorCode.INVALID_PARAMETER_VALUE.getMessageCode()));
        }
    }

    @Test
    public void testvalidMaxRetries() throws SFException {
        int expectedVal = 10;
        Object value = SFSessionProperty.checkPropertyValue((SFSessionProperty)SFSessionProperty.MAX_HTTP_RETRIES, (Object)expectedVal);
        MatcherAssert.assertThat((String)"Integer value should match", ((Integer)value == expectedVal ? 1 : 0) != 0);
    }

    @Test
    public void testInvalidPutGetMaxRetries() {
        try {
            SFSessionProperty.checkPropertyValue((SFSessionProperty)SFSessionProperty.PUT_GET_MAX_RETRIES, (Object)"invalidValue");
            Assert.fail((String)"testInvalidMaxRetries");
        }
        catch (SFException e) {
            MatcherAssert.assertThat((Object)e.getVendorCode(), (Matcher)CoreMatchers.is((Object)ErrorCode.INVALID_PARAMETER_VALUE.getMessageCode()));
        }
    }

    @Test
    public void testvalidPutGetMaxRetries() throws SFException {
        int expectedVal = 10;
        Object value = SFSessionProperty.checkPropertyValue((SFSessionProperty)SFSessionProperty.PUT_GET_MAX_RETRIES, (Object)expectedVal);
        MatcherAssert.assertThat((String)"Integer value should match", ((Integer)value == expectedVal ? 1 : 0) != 0);
    }
}

