/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.snowflake.client.category.TestCategoryCore;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryService;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.AnyOf;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;

@Category(value={TestCategoryCore.class})
public class SFTrustManagerIT
extends BaseJDBCTest {
    private static final String[] TARGET_HOSTS = new String[]{"storage.googleapis.com", "ocspssd.us-east-1.snowflakecomputing.com/ocsp/fetch", "sfcsupport.snowflakecomputing.com", "sfcsupport.us-east-1.snowflakecomputing.com", "sfcsupport.eu-central-1.snowflakecomputing.com", "sfc-dev1-regression.s3.amazonaws.com", "sfc-ds2-customer-stage.s3.amazonaws.com", "snowflake.okta.com", "sfcdev1.blob.core.windows.net"};
    private boolean defaultState;
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    @Before
    public void setUp() {
        TelemetryService service = TelemetryService.getInstance();
        service.updateContextForIT(SFTrustManagerIT.getConnectionParameters());
        this.defaultState = service.isEnabled();
        service.setNumOfRetryToTriggerTelemetry(3);
        service.enable();
    }

    @After
    public void tearDown() throws InterruptedException {
        TelemetryService service = TelemetryService.getInstance();
        TimeUnit.SECONDS.sleep(5L);
        if (this.defaultState) {
            service.enable();
        } else {
            service.disable();
        }
        System.clearProperty("SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED");
        System.clearProperty("SF_OCSP_RESPONSE_CACHE_SERVER_URL");
    }

    @Test
    public void testOcsp() throws Throwable {
        System.setProperty("SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED", Boolean.TRUE.toString());
        for (String host : TARGET_HOSTS) {
            CloseableHttpClient client = HttpUtil.buildHttpClient((HttpClientSettingsKey)new HttpClientSettingsKey(OCSPMode.FAIL_CLOSED), null, (boolean)false);
            SFTrustManagerIT.accessHost(host, (HttpClient)client);
        }
    }

    @Test
    public void testOcspWithFileCache() throws Throwable {
        System.setProperty("SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED", Boolean.FALSE.toString());
        File ocspCacheFile = this.tmpFolder.newFile();
        for (String host : TARGET_HOSTS) {
            CloseableHttpClient client = HttpUtil.buildHttpClient((HttpClientSettingsKey)new HttpClientSettingsKey(OCSPMode.FAIL_CLOSED), (File)ocspCacheFile, (boolean)false);
            SFTrustManagerIT.accessHost(host, (HttpClient)client);
        }
    }

    @Test
    public void testOcspWithServerCache() throws Throwable {
        System.setProperty("SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED", Boolean.TRUE.toString());
        File ocspCacheFile = this.tmpFolder.newFile();
        for (String host : TARGET_HOSTS) {
            CloseableHttpClient client = HttpUtil.buildHttpClient((HttpClientSettingsKey)new HttpClientSettingsKey(OCSPMode.FAIL_CLOSED), (File)ocspCacheFile, (boolean)false);
            SFTrustManagerIT.accessHost(host, (HttpClient)client);
        }
    }

    @Test
    public void testOcspWithoutServerCache() throws Throwable {
        System.setProperty("SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED", Boolean.FALSE.toString());
        File ocspCacheFile = this.tmpFolder.newFile();
        for (String host : TARGET_HOSTS) {
            CloseableHttpClient client = HttpUtil.buildHttpClient((HttpClientSettingsKey)new HttpClientSettingsKey(OCSPMode.FAIL_OPEN), (File)ocspCacheFile, (boolean)false);
            SFTrustManagerIT.accessHost(host, (HttpClient)client);
        }
    }

    @Test
    public void testInvalidCacheFile() throws Throwable {
        System.setProperty("SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED", Boolean.TRUE.toString());
        File ocspCacheFile = new File("NEVER_EXISTS", "NEVER_EXISTS");
        String host = TARGET_HOSTS[0];
        CloseableHttpClient client = HttpUtil.buildHttpClient((HttpClientSettingsKey)new HttpClientSettingsKey(OCSPMode.FAIL_CLOSED), (File)ocspCacheFile, (boolean)false);
        SFTrustManagerIT.accessHost(host, (HttpClient)client);
    }

    private static void accessHost(String host, HttpClient client) throws IOException {
        HttpGet httpRequest;
        HttpResponse response;
        int maxRetry = 10;
        int statusCode = -1;
        for (int retry = 0; retry < 10 && ((statusCode = (response = client.execute((HttpUriRequest)(httpRequest = new HttpGet(String.format("https://%s:443/", host))))).getStatusLine().getStatusCode()) == 503 || statusCode == 504); ++retry) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        MatcherAssert.assertThat((String)String.format("response code for %s", host), (Object)statusCode, (Matcher)AnyOf.anyOf((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)200), CoreMatchers.equalTo((Object)403), CoreMatchers.equalTo((Object)400)}));
    }

    private List<X509Certificate> getX509CertificatesFromFile(String filename) throws Throwable {
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        for (Certificate certificate : fact.generateCertificates(this.getFile(filename))) {
            certList.add((X509Certificate)certificate);
        }
        return certList;
    }

    private InputStream getFile(String fileName) throws Throwable {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL url = classLoader.getResource(fileName);
        return url != null ? url.openStream() : null;
    }
}

