/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.File;
import java.io.IOException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import net.snowflake.client.TestUtil;
import net.snowflake.client.category.TestCategoryCore;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.SFTrustManager;
import net.snowflake.client.jdbc.SnowflakeUtil;
import org.hamcrest.MatcherAssert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

@Category(value={TestCategoryCore.class})
public class SFTrustManagerMockitoMockLatestIT {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    @Test
    @Ignore(value="static initialization block of SFTrustManager class doesn't run sometimes")
    public void testUnitOCSPWithCustomCacheDirectory() throws IOException {
        try (MockedStatic mockedTrustManagerFactory = Mockito.mockStatic(TrustManagerFactory.class);
             MockedStatic mockedSnowflakeUtil = Mockito.mockStatic(SnowflakeUtil.class);){
            File cacheFolder = this.tmpFolder.newFolder();
            mockedSnowflakeUtil.when(() -> TestUtil.systemGetEnv("SF_OCSP_RESPONSE_CACHE_DIR")).thenReturn((Object)cacheFolder.getCanonicalPath());
            TrustManagerFactory tested = (TrustManagerFactory)Mockito.mock(TrustManagerFactory.class);
            Mockito.when((Object)tested.getTrustManagers()).thenReturn((Object)new TrustManager[0]);
            mockedTrustManagerFactory.when(() -> TrustManagerFactory.getInstance("SunX509")).thenReturn((Object)tested);
            new SFTrustManager(new HttpClientSettingsKey(OCSPMode.FAIL_CLOSED), null);
            MatcherAssert.assertThat((String)"The cache file doesn't exist.", (boolean)new File(cacheFolder, "ocsp_response_cache.json").exists());
        }
    }
}

