/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.util.Base64;
import java.util.Properties;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.QueryResultFormat;
import net.snowflake.client.core.SFTrustManager;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializable;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializableV1;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class SFTrustManagerTest {
    @Test
    public void testBuildRetryURL() throws Exception {
        SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN = null;
        SFTrustManager.resetOCSPResponseCacherServerURL((String)"http://ocsp.us-east-1.privatelink.snowflakecomputing.com/ocsp_response_cache.json");
        MatcherAssert.assertThat((Object)SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN, (Matcher)CoreMatchers.equalTo((Object)"http://ocsp.us-east-1.privatelink.snowflakecomputing.com/retry/%s/%s"));
        SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN = null;
        SFTrustManager.resetOCSPResponseCacherServerURL((String)"http://ocsp.us-east-1.privatelink.snowflakecomputing.com:80/ocsp_response_cache.json");
        MatcherAssert.assertThat((Object)SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN, (Matcher)CoreMatchers.equalTo((Object)"http://ocsp.us-east-1.privatelink.snowflakecomputing.com:80/retry/%s/%s"));
        SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN = null;
        SFTrustManager.resetOCSPResponseCacherServerURL((String)"http://ocsp.snowflakecomputing.com/ocsp_response_cache.json");
        MatcherAssert.assertThat((Object)SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN, (Matcher)CoreMatchers.nullValue());
        SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN = null;
        SFTrustManager.resetOCSPResponseCacherServerURL((String)"http://ocsp.snowflakecomputing.com:80/ocsp_response_cache.json");
        MatcherAssert.assertThat((Object)SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testBuildNewRetryURL() {
        try {
            System.setProperty("net.snowflake.jdbc.ocsp_activate_new_endpoint", Boolean.TRUE.toString());
            SFTrustManager tManager = new SFTrustManager(new HttpClientSettingsKey(OCSPMode.FAIL_OPEN), null);
            tManager.ocspCacheServer.resetOCSPResponseCacheServer("a1.snowflakecomputing.com");
            MatcherAssert.assertThat((Object)tManager.ocspCacheServer.SF_OCSP_RESPONSE_CACHE_SERVER, (Matcher)CoreMatchers.equalTo((Object)"https://ocspssd.snowflakecomputing.com/ocsp/fetch"));
            MatcherAssert.assertThat((Object)tManager.ocspCacheServer.SF_OCSP_RESPONSE_RETRY_URL, (Matcher)CoreMatchers.equalTo((Object)"https://ocspssd.snowflakecomputing.com/ocsp/retry"));
            tManager.ocspCacheServer.resetOCSPResponseCacheServer("a1-12345.global.snowflakecomputing.com");
            MatcherAssert.assertThat((Object)tManager.ocspCacheServer.SF_OCSP_RESPONSE_CACHE_SERVER, (Matcher)CoreMatchers.equalTo((Object)"https://ocspssd-12345.global.snowflakecomputing.com/ocsp/fetch"));
            MatcherAssert.assertThat((Object)tManager.ocspCacheServer.SF_OCSP_RESPONSE_RETRY_URL, (Matcher)CoreMatchers.equalTo((Object)"https://ocspssd-12345.global.snowflakecomputing.com/ocsp/retry"));
            tManager.ocspCacheServer.resetOCSPResponseCacheServer("okta.snowflake.com");
            MatcherAssert.assertThat((Object)tManager.ocspCacheServer.SF_OCSP_RESPONSE_CACHE_SERVER, (Matcher)CoreMatchers.equalTo((Object)"https://ocspssd.snowflakecomputing.com/ocsp/fetch"));
            MatcherAssert.assertThat((Object)tManager.ocspCacheServer.SF_OCSP_RESPONSE_RETRY_URL, (Matcher)CoreMatchers.equalTo((Object)"https://ocspssd.snowflakecomputing.com/ocsp/retry"));
            tManager.ocspCacheServer.resetOCSPResponseCacheServer("a1.us-east-1.privatelink.snowflakecomputing.com");
            MatcherAssert.assertThat((Object)tManager.ocspCacheServer.SF_OCSP_RESPONSE_CACHE_SERVER, (Matcher)CoreMatchers.equalTo((Object)"https://ocspssd.us-east-1.privatelink.snowflakecomputing.com/ocsp/fetch"));
            MatcherAssert.assertThat((Object)tManager.ocspCacheServer.SF_OCSP_RESPONSE_RETRY_URL, (Matcher)CoreMatchers.equalTo((Object)"https://ocspssd.us-east-1.privatelink.snowflakecomputing.com/ocsp/retry"));
        }
        finally {
            System.clearProperty("net.snowflake.jdbc.ocsp_activate_new_endpoint");
        }
    }

    @Test
    public void testSnowflakeResultSetSerializable_getResultSet() throws Exception {
        SnowflakeResultSetSerializableV1 resultSetSerializable = new SnowflakeResultSetSerializableV1();
        resultSetSerializable.setFirstChunkStringData(Base64.getEncoder().encodeToString("".getBytes(StandardCharsets.UTF_8)));
        resultSetSerializable.setChunkFileCount(0);
        resultSetSerializable.getParameters().put("CLIENT_MEMORY_LIMIT", 10);
        resultSetSerializable.setQueryResultFormat(QueryResultFormat.ARROW);
        SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN = null;
        ResultSet rs = resultSetSerializable.getResultSet(SnowflakeResultSetSerializable.ResultSetRetrieveConfig.Builder.newInstance().setProxyProperties(new Properties()).setSfFullURL("https://sfctest0.snowflakecomputing.com").build());
        MatcherAssert.assertThat((Object)SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN, (Matcher)CoreMatchers.nullValue());
        SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN = null;
        rs = resultSetSerializable.getResultSet(SnowflakeResultSetSerializable.ResultSetRetrieveConfig.Builder.newInstance().setProxyProperties(new Properties()).setSfFullURL("https://sfctest0.us-west-2.privatelink.snowflakecomputing.com").build());
        MatcherAssert.assertThat((Object)SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN, (Matcher)CoreMatchers.equalTo((Object)"http://ocsp.sfctest0.us-west-2.privatelink.snowflakecomputing.com/retry/%s/%s"));
    }
}

