/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningNotOnLinux;
import net.snowflake.client.RunningNotOnWinMac;
import net.snowflake.client.core.Constants;
import net.snowflake.client.core.MockAdvapi32Lib;
import net.snowflake.client.core.MockSecurityLib;
import net.snowflake.client.core.SecureStorageAppleManager;
import net.snowflake.client.core.SecureStorageLinuxManager;
import net.snowflake.client.core.SecureStorageManager;
import net.snowflake.client.core.SecureStorageWindowsManager;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;

public class SecureStorageManagerTest {
    @Rule
    public ConditionalIgnoreRule rule = new ConditionalIgnoreRule();
    private static final String host = "fakeHost";
    private static final String user = "fakeUser";
    private static final String idToken = "fakeIdToken";
    private static final String idToken0 = "fakeIdToken0";
    private static final String mfaToken = "fakeMfaToken";
    private static final String ID_TOKEN = "ID_TOKEN";
    private static final String MFA_TOKEN = "MFATOKEN";

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningNotOnWinMac.class)
    public void testLoadNativeLibrary() {
        if (Constants.getOS() == Constants.OS.MAC) {
            MatcherAssert.assertThat((Object)SecureStorageAppleManager.SecurityLibManager.getInstance(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
        if (Constants.getOS() == Constants.OS.WINDOWS) {
            MatcherAssert.assertThat((Object)SecureStorageWindowsManager.Advapi32LibManager.getInstance(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testWindowsManager() {
        SecureStorageWindowsManager.Advapi32LibManager.setInstance((SecureStorageWindowsManager.Advapi32Lib)new MockAdvapi32Lib());
        SecureStorageWindowsManager manager = SecureStorageWindowsManager.builder();
        this.testBody((SecureStorageManager)manager);
        SecureStorageWindowsManager.Advapi32LibManager.resetInstance();
    }

    @Test
    public void testMacManager() {
        SecureStorageAppleManager.SecurityLibManager.setInstance((SecureStorageAppleManager.SecurityLib)new MockSecurityLib());
        SecureStorageAppleManager manager = SecureStorageAppleManager.builder();
        this.testBody((SecureStorageManager)manager);
        SecureStorageAppleManager.SecurityLibManager.resetInstance();
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningNotOnLinux.class)
    public void testLinuxManager() {
        SecureStorageLinuxManager manager = SecureStorageLinuxManager.getInstance();
        this.testBody((SecureStorageManager)manager);
        this.testDeleteLinux((SecureStorageManager)manager);
    }

    private void testBody(SecureStorageManager manager) {
        MatcherAssert.assertThat((Object)manager.deleteCredential(host, user, ID_TOKEN), (Matcher)CoreMatchers.equalTo((Object)SecureStorageManager.SecureStorageStatus.SUCCESS));
        MatcherAssert.assertThat((Object)manager.getCredential(host, user, ID_TOKEN), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)manager.setCredential(host, user, ID_TOKEN, idToken), (Matcher)CoreMatchers.equalTo((Object)SecureStorageManager.SecureStorageStatus.SUCCESS));
        MatcherAssert.assertThat((Object)manager.getCredential(host, user, ID_TOKEN), (Matcher)CoreMatchers.equalTo((Object)idToken));
        MatcherAssert.assertThat((Object)manager.setCredential(host, user, ID_TOKEN, idToken0), (Matcher)CoreMatchers.equalTo((Object)SecureStorageManager.SecureStorageStatus.SUCCESS));
        MatcherAssert.assertThat((Object)manager.getCredential(host, user, ID_TOKEN), (Matcher)CoreMatchers.equalTo((Object)idToken0));
        MatcherAssert.assertThat((Object)manager.deleteCredential(host, user, ID_TOKEN), (Matcher)CoreMatchers.equalTo((Object)SecureStorageManager.SecureStorageStatus.SUCCESS));
        MatcherAssert.assertThat((Object)manager.getCredential(host, user, ID_TOKEN), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private void testDeleteLinux(SecureStorageManager manager) {
        MatcherAssert.assertThat((Object)manager.setCredential(host, user, ID_TOKEN, idToken), (Matcher)CoreMatchers.equalTo((Object)SecureStorageManager.SecureStorageStatus.SUCCESS));
        MatcherAssert.assertThat((Object)manager.setCredential(host, user, MFA_TOKEN, mfaToken), (Matcher)CoreMatchers.equalTo((Object)SecureStorageManager.SecureStorageStatus.SUCCESS));
        MatcherAssert.assertThat((Object)manager.getCredential(host, user, ID_TOKEN), (Matcher)CoreMatchers.equalTo((Object)idToken));
        MatcherAssert.assertThat((Object)manager.getCredential(host, user, MFA_TOKEN), (Matcher)CoreMatchers.equalTo((Object)mfaToken));
        MatcherAssert.assertThat((Object)manager.deleteCredential(host, user, ID_TOKEN), (Matcher)CoreMatchers.equalTo((Object)SecureStorageManager.SecureStorageStatus.SUCCESS));
        MatcherAssert.assertThat((Object)manager.getCredential(host, user, ID_TOKEN), (Matcher)CoreMatchers.equalTo(null));
        MatcherAssert.assertThat((Object)manager.getCredential(host, user, MFA_TOKEN), (Matcher)CoreMatchers.equalTo((Object)mfaToken));
        MatcherAssert.assertThat((Object)manager.deleteCredential(host, user, MFA_TOKEN), (Matcher)CoreMatchers.equalTo((Object)SecureStorageManager.SecureStorageStatus.SUCCESS));
    }
}

