/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.net.URI;
import java.net.URISyntaxException;
import net.snowflake.client.core.FakeSessionUtilExternalBrowser;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFLoginInput;
import net.snowflake.client.core.SessionUtilExternalBrowser;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.common.core.ClientAuthnDTO;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class SessionUtilExternalBrowserTest {
    private static final String MOCK_PROOF_KEY = "specialkey";
    private static final String MOCK_SSO_URL = "https://sso.someidp.net/";

    @Test
    public void testSessionUtilExternalBrowser() throws Throwable {
        SFLoginInput loginInput = this.initMockLoginInput();
        try (MockedStatic mockedHttpUtil = Mockito.mockStatic(HttpUtil.class);){
            mockedHttpUtil.when(() -> HttpUtil.executeGeneralRequest((HttpRequestBase)((HttpRequestBase)Mockito.any(HttpRequestBase.class)), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (HttpClientSettingsKey)((HttpClientSettingsKey)Mockito.nullable(HttpClientSettingsKey.class)))).thenReturn((Object)"{\"success\":\"true\",\"data\":{\"proofKey\":\"specialkey\", \"ssoUrl\":\"https://sso.someidp.net/\"}}");
            SessionUtilExternalBrowser sub = FakeSessionUtilExternalBrowser.createInstance(loginInput, false);
            sub.authenticate();
            Assert.assertThat((String)"", (Object)sub.getToken(), (Matcher)CoreMatchers.equalTo((Object)"MOCK_SAML_TOKEN"));
            sub = FakeSessionUtilExternalBrowser.createInstance(loginInput, true);
            sub.authenticate();
            Assert.assertThat((String)"", (Object)sub.getToken(), (Matcher)CoreMatchers.equalTo((Object)"MOCK_SAML_TOKEN"));
        }
    }

    @Test
    public void testSessionUtilExternalBrowserFail() throws Throwable {
        SFLoginInput loginInput = this.initMockLoginInput();
        try (MockedStatic mockedHttpUtil = Mockito.mockStatic(HttpUtil.class);){
            mockedHttpUtil.when(() -> HttpUtil.executeGeneralRequest((HttpRequestBase)((HttpRequestBase)Mockito.any(HttpRequestBase.class)), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (HttpClientSettingsKey)((HttpClientSettingsKey)Mockito.nullable(HttpClientSettingsKey.class)))).thenReturn((Object)"{\"success\":\"false\",\"code\":\"123456\",\"message\":\"errormes\"}");
            SessionUtilExternalBrowser sub = FakeSessionUtilExternalBrowser.createInstance(loginInput, false);
            try {
                sub.authenticate();
                Assert.fail((String)"should have failed with an exception.");
            }
            catch (SnowflakeSQLException ex) {
                Assert.assertThat((String)"Error is expected", (Object)ex.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)123456));
            }
        }
    }

    @Test
    public void testBuildDefaultHandler() throws URISyntaxException {
        SessionUtilExternalBrowser.DefaultAuthExternalBrowserHandlers handler = new SessionUtilExternalBrowser.DefaultAuthExternalBrowserHandlers();
        URI uri = new URI("https://testaccount.snowflakecomputing.com:443/session/authenticator-request");
        HttpPost postReq = handler.build(uri);
        Assert.assertEquals((Object)"POST https://testaccount.snowflakecomputing.com:443/session/authenticator-request HTTP/1.1", (Object)postReq.toString());
    }

    @Test
    public void testInvalidSSOUrl() {
        SessionUtilExternalBrowser.DefaultAuthExternalBrowserHandlers handler = new SessionUtilExternalBrowser.DefaultAuthExternalBrowserHandlers();
        try {
            handler.openBrowser("file://invalidUrl");
        }
        catch (SFException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("Invalid SSOUrl found"));
        }
    }

    private SFLoginInput initMockLoginInput() {
        SFLoginInput loginInput = (SFLoginInput)Mockito.mock(SFLoginInput.class);
        Mockito.when((Object)loginInput.getServerUrl()).thenReturn((Object)"https://testaccount.snowflakecomputing.com/");
        Mockito.when((Object)loginInput.getAuthenticator()).thenReturn((Object)ClientAuthnDTO.AuthenticatorType.EXTERNALBROWSER.name());
        Mockito.when((Object)loginInput.getAccountName()).thenReturn((Object)"testaccount");
        Mockito.when((Object)loginInput.getUserName()).thenReturn((Object)"testuser");
        return loginInput;
    }
}

