/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import com.fasterxml.jackson.databind.node.BooleanNode;
import java.util.HashMap;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.jdbc.MockConnectionTest;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class SessionUtilTest {
    @Test
    public void testIsPrefixEqual() throws Exception {
        MatcherAssert.assertThat((String)"no port number", (boolean)SessionUtil.isPrefixEqual((String)"https://testaccount.snowflakecomputing.com/blah", (String)"https://testaccount.snowflakecomputing.com/"));
        MatcherAssert.assertThat((String)"no port number with a slash", (boolean)SessionUtil.isPrefixEqual((String)"https://testaccount.snowflakecomputing.com/blah", (String)"https://testaccount.snowflakecomputing.com"));
        MatcherAssert.assertThat((String)"including a port number on one of them", (boolean)SessionUtil.isPrefixEqual((String)"https://testaccount.snowflakecomputing.com/blah", (String)"https://testaccount.snowflakecomputing.com:443/"));
        MatcherAssert.assertThat((String)"different hostnames", (!SessionUtil.isPrefixEqual((String)"https://testaccount1.snowflakecomputing.com/blah", (String)"https://testaccount2.snowflakecomputing.com/") ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"different port numbers", (!SessionUtil.isPrefixEqual((String)"https://testaccount.snowflakecomputing.com:123/blah", (String)"https://testaccount.snowflakecomputing.com:443/") ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"different protocols", (!SessionUtil.isPrefixEqual((String)"http://testaccount.snowflakecomputing.com/blah", (String)"https://testaccount.snowflakecomputing.com/") ? 1 : 0) != 0);
    }

    @Test
    public void testParameterParsing() {
        HashMap<String, BooleanNode> parameterMap = new HashMap<String, BooleanNode>();
        parameterMap.put("other_parameter", BooleanNode.getTrue());
        SFBaseSession session = new MockConnectionTest.MockSnowflakeConnectionImpl().getSFSession();
        SessionUtil.updateSfDriverParamValues(parameterMap, (SFBaseSession)session);
        assert (((BooleanNode)session.getOtherParameter("other_parameter")).asBoolean());
    }

    @Test
    public void testConvertSystemPropertyToIntValue() {
        System.setProperty("net.snowflake.jdbc.max_connections", "500");
        Assert.assertEquals((long)500L, (long)HttpUtil.convertSystemPropertyToIntValue((String)"net.snowflake.jdbc.max_connections", (int)300));
        System.setProperty("net.snowflake.jdbc.max_connections", "notAnInteger");
        Assert.assertEquals((long)300L, (long)HttpUtil.convertSystemPropertyToIntValue((String)"net.snowflake.jdbc.max_connections", (int)300));
        System.setProperty("net.snowflake.jdbc.max_connections_per_route", "30");
        Assert.assertEquals((long)30L, (long)HttpUtil.convertSystemPropertyToIntValue((String)"net.snowflake.jdbc.max_connections_per_route", (int)300));
    }
}

