/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.snowflake.client.category.TestCategoryCore;
import net.snowflake.client.core.ExecTimeTelemetryData;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.SFLoginInput;
import net.snowflake.client.core.StmtUtil;
import net.snowflake.client.jdbc.BaseJDBCTest;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpRequestBase;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

@Category(value={TestCategoryCore.class})
public class StmtUtilTest
extends BaseJDBCTest {
    @Test
    public void testForwardedHeaders() throws Throwable {
        SFLoginInput input = this.createLoginInput();
        HashMap<String, String> additionalHeaders = new HashMap<String, String>();
        additionalHeaders.put("Extra-Snowflake-Header", "present");
        input.setAdditionalHttpHeadersForSnowsight(additionalHeaders);
        try (MockedStatic mockedHttpUtil = Mockito.mockStatic(HttpUtil.class);){
            MockedStatic.Verification httpCalledWithHeaders = () -> HttpUtil.executeRequest((HttpRequestBase)((HttpRequestBase)Mockito.argThat(arg -> {
                for (Map.Entry definedHeader : additionalHeaders.entrySet()) {
                    Header actualHeader = arg.getLastHeader((String)definedHeader.getKey());
                    if (actualHeader == null) {
                        return false;
                    }
                    if (((String)definedHeader.getValue()).equals(actualHeader.getValue())) continue;
                    return false;
                }
                return true;
            })), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (AtomicBoolean)((AtomicBoolean)Mockito.nullable(AtomicBoolean.class)), (boolean)Mockito.anyBoolean(), (boolean)Mockito.anyBoolean(), (HttpClientSettingsKey)((HttpClientSettingsKey)Mockito.nullable(HttpClientSettingsKey.class)), (ExecTimeTelemetryData)((ExecTimeTelemetryData)Mockito.nullable(ExecTimeTelemetryData.class)));
            mockedHttpUtil.when(httpCalledWithHeaders).thenReturn((Object)"{\"data\":null,\"code\":333334,\"message\":null,\"success\":true}");
            mockedHttpUtil.when(() -> HttpUtil.applyAdditionalHeadersForSnowsight((HttpRequestBase)((HttpRequestBase)Mockito.any()), (Map)((Map)Mockito.any()))).thenCallRealMethod();
            StmtUtil.StmtInput stmtInput = new StmtUtil.StmtInput();
            stmtInput.setAdditionalHttpHeadersForSnowsight(additionalHeaders);
            stmtInput.setAsync(true);
            stmtInput.setHttpClientSettingsKey(new HttpClientSettingsKey(OCSPMode.FAIL_OPEN));
            stmtInput.setRequestId(UUID.randomUUID().toString());
            stmtInput.setServiceName("MOCK_SERVICE_NAME");
            stmtInput.setServerUrl("MOCK_SERVER_URL");
            stmtInput.setSessionToken("MOCK_SESSION_TOKEN");
            stmtInput.setSequenceId(1);
            stmtInput.setSql("SELECT * FROM MOCK_TABLE");
            StmtUtil.execute((StmtUtil.StmtInput)stmtInput, (ExecTimeTelemetryData)new ExecTimeTelemetryData());
            mockedHttpUtil.verify(Mockito.times((int)1), httpCalledWithHeaders);
        }
    }

    private SFLoginInput createLoginInput() {
        SFLoginInput input = new SFLoginInput();
        input.setServerUrl("MOCK_TEST_HOST");
        input.setUserName("MOCK_USERNAME");
        input.setPassword("MOCK_PASSWORD");
        input.setAccountName("MOCK_ACCOUNT_NAME");
        input.setAppId("MOCK_APP_ID");
        input.setOCSPMode(OCSPMode.FAIL_OPEN);
        input.setHttpClientSettingsKey(new HttpClientSettingsKey(OCSPMode.FAIL_OPEN));
        input.setLoginTimeout(1000);
        input.setSessionParameters(new HashMap());
        return input;
    }
}

