/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import net.snowflake.client.core.URLUtil;
import org.junit.Assert;
import org.junit.Test;

public class URLUtilTest {
    @Test
    public void testValidURL() throws Exception {
        Assert.assertTrue((boolean)URLUtil.isValidURL((String)"https://ssoTestURL.okta.com"));
        Assert.assertTrue((boolean)URLUtil.isValidURL((String)"https://ssoTestURL.okta.com:8080"));
        Assert.assertTrue((boolean)URLUtil.isValidURL((String)"https://ssoTestURL.okta.com/testpathvalue"));
    }

    @Test
    public void testInvalidURL() throws Exception {
        Assert.assertFalse((boolean)URLUtil.isValidURL((String)"-a Calculator"));
        Assert.assertFalse((boolean)URLUtil.isValidURL((String)"This is random text"));
        Assert.assertFalse((boolean)URLUtil.isValidURL((String)"file://TestForFile"));
    }

    @Test
    public void testEncodeURL() throws Exception {
        Assert.assertEquals((Object)URLUtil.urlEncode((String)"Hello @World"), (Object)"Hello+%40World");
        Assert.assertEquals((Object)URLUtil.urlEncode((String)"Test//String"), (Object)"Test%2F%2FString");
    }
}

