/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.sql.Timestamp;
import java.util.Random;
import java.util.TimeZone;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.arrow.ArrowResultUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ArrowResultUtilTest {
    @Parameterized.Parameters
    public static Object[][] data() {
        return new Object[][]{{"UTC"}, {"America/Los_Angeles"}, {"America/New_York"}, {"Asia/Singapore"}, {"MEZ"}};
    }

    @After
    public void clearTimeZone() {
        System.clearProperty("user.timezone");
    }

    public ArrowResultUtilTest(String tz) {
        System.setProperty("user.timezone", tz);
    }

    @Test
    @Ignore
    public void testGetDatePerformance() throws SFException {
        int i;
        Random random = new Random();
        int dateBound = 50000;
        int times = 100000;
        SFSession session = new SFSession();
        long start = System.currentTimeMillis();
        TimeZone tz = TimeZone.getDefault();
        int[] days = new int[times];
        for (i = 0; i < times; ++i) {
            days[i] = random.nextInt(dateBound) - dateBound / 2;
        }
        for (i = 0; i < times; ++i) {
            ResultUtil.getDate((String)Integer.toString(days[i]), (TimeZone)tz, (SFBaseSession)session);
        }
        long duration1 = System.currentTimeMillis() - start;
        start = System.currentTimeMillis();
        for (int i2 = 0; i2 < times; ++i2) {
            ArrowResultUtil.getDate((int)days[i2], (TimeZone)tz, (TimeZone)tz);
        }
        long duration2 = System.currentTimeMillis() - start;
        start = System.currentTimeMillis();
        for (int i3 = 0; i3 < times; ++i3) {
            ArrowResultUtil.getDate((int)days[i3]);
        }
        long duration3 = System.currentTimeMillis() - start;
        System.out.println(duration1 + " " + duration2 + " " + duration3);
    }

    @Test
    public void testToJavaTimestamp() {
        long[] cases = new long[]{-1123456789L, -123456789L, 123456789L, 123123456789L, -123123456789L};
        long[] millisecs = new long[]{-1124L, -124L, 123L, 123123L, -123124L};
        int[] nanos = new int[]{876543211, 876543211, 123456789, 123456789, 876543211};
        int scale = 9;
        for (int i = 0; i < cases.length; ++i) {
            Timestamp ts = ArrowResultUtil.toJavaTimestamp((long)cases[i], (int)scale);
            Assert.assertEquals((long)millisecs[i], (long)ts.getTime());
            Assert.assertEquals((long)nanos[i], (long)ts.getNanos());
        }
    }
}

