/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.TimeZone;
import net.snowflake.client.TestUtil;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.ArrowVectorConverter;
import net.snowflake.client.core.arrow.BaseConverterTest;
import net.snowflake.client.core.arrow.BigIntToTimestampNTZConverter;
import net.snowflake.common.core.SFTimestamp;
import net.snowflake.common.core.SnowflakeDateTimeFormat;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BigIntToTimestampNTZConverterTest
extends BaseConverterTest {
    private BufferAllocator allocator = new RootAllocator(Long.MAX_VALUE);
    private Random random = new Random();
    private int oldScale = 9;

    @Parameterized.Parameters
    public static Object[][] data() {
        return new Object[][]{{"UTC"}, {"America/Los_Angeles"}, {"America/New_York"}, {"Pacific/Honolulu"}, {"Asia/Singapore"}, {"MEZ"}, {"MESZ"}};
    }

    public BigIntToTimestampNTZConverterTest(String tz) {
        System.setProperty("user.timezone", tz);
    }

    @Test
    public void testHonorClientTZForTimestampNTZDisabled() throws SFException {
        this.setHonorClientTZForTimestampNTZ(false);
        this.testTimestampNTZ();
    }

    @Test
    public void testHonorClientTZForTimestampNTZEnabled() throws SFException {
        this.setHonorClientTZForTimestampNTZ(true);
        this.testTimestampNTZ();
    }

    @Test
    public void testWithNullTimezone() throws SFException {
        this.testTimestampNTZ(null);
    }

    @Test
    public void testTimestampNTZ() throws SFException {
        this.testTimestampNTZ(TimeZone.getDefault());
    }

    private void testTimestampNTZ(TimeZone timezone) throws SFException {
        long[] testTimestampsInt64 = new long[]{1546391837L, 15463918370L, 154639183700L, 1546391837000L, 15463918370000L, 154639183700000L, 1546391837000000L};
        int[] testScales = new int[]{0, 1, 2, 3, 4, 5, 6};
        String[] testTimesJson = new String[]{"1546391837.000000000"};
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "TIMESTAMP");
        HashSet<Integer> nullValIndex = new HashSet<Integer>();
        FieldType fieldType = new FieldType(true, Types.MinorType.BIGINT.getType(), null, customFieldMeta);
        BigIntVector vector = new BigIntVector("timestamp", fieldType, this.allocator);
        int i = 0;
        int j = 0;
        while (i < testTimestampsInt64.length) {
            boolean isNull = this.random.nextBoolean();
            if (isNull) {
                vector.setNull(j);
                nullValIndex.add(j);
            } else {
                vector.setSafe(j, testTimestampsInt64[i++]);
            }
            ++j;
        }
        BigIntToTimestampNTZConverter converter = new BigIntToTimestampNTZConverter((ValueVector)vector, 0, (DataConversionContext)this);
        int rowCount = j;
        i = 0;
        this.setScale(testScales[i]);
        for (j = 0; j < rowCount; ++j) {
            Timestamp ts = this.createTimestampObject((ArrowVectorConverter)converter, j, timezone);
            Date date = converter.toDate(j, this.getTimeZone(), false);
            Time time = converter.toTime(j);
            String tsStr = converter.toString(j);
            if (tsStr != null) {
                Assert.assertFalse((boolean)converter.isNull(j));
            } else {
                Assert.assertTrue((boolean)converter.isNull(j));
            }
            if (nullValIndex.contains(j)) {
                MatcherAssert.assertThat((Object)ts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)date, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)false, (Matcher)CoreMatchers.is((Object)converter.toBoolean(j)));
                MatcherAssert.assertThat((Object)converter.toBytes(j), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                continue;
            }
            SFTimestamp sfTimestamp = ResultUtil.getSFTimestamp((String)testTimesJson[0], (int)this.oldScale, (int)93, (long)this.getResultVersion(), (TimeZone)this.getTimeZone(), (SFBaseSession)this.getSession());
            Timestamp oldTs = sfTimestamp.getTimestamp();
            if (this.getHonorClientTZForTimestampNTZ()) {
                oldTs = sfTimestamp.moveToTimeZone(this.getTimeZone()).getTimestamp();
            }
            oldTs = ResultUtil.adjustTimestamp((Timestamp)oldTs);
            SFTimestamp sfTS = ResultUtil.getSFTimestamp((String)testTimesJson[0], (int)this.oldScale, (int)93, (long)this.getResultVersion(), (TimeZone)this.getTimeZone(), (SFBaseSession)this.getSession());
            String timestampStr = ResultUtil.getSFTimestampAsString((SFTimestamp)sfTS, (int)93, (int)this.oldScale, (SnowflakeDateTimeFormat)this.getTimestampNTZFormatter(), (SnowflakeDateTimeFormat)this.getTimestampLTZFormatter(), (SnowflakeDateTimeFormat)this.getTimestampTZFormatter(), (SFBaseSession)this.getSession());
            Date oldDate = new Date(oldTs.getTime());
            Time oldTime = new Time(oldTs.getTime());
            MatcherAssert.assertThat((Object)oldTs, (Matcher)CoreMatchers.is((Object)ts));
            MatcherAssert.assertThat((Object)oldDate, (Matcher)CoreMatchers.is((Object)date));
            MatcherAssert.assertThat((Object)timestampStr, (Matcher)CoreMatchers.is((Object)tsStr));
            MatcherAssert.assertThat((Object)oldTime, (Matcher)CoreMatchers.is((Object)time));
            MatcherAssert.assertThat((Object)converter.toBytes(j), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            if (++i < testScales.length) {
                this.setScale(testScales[i]);
            }
            int x = j;
            TestUtil.assertSFException(this.invalidConversionErrorCode, () -> BigIntToTimestampNTZConverterTest.lambda$testTimestampNTZ$0((ArrowVectorConverter)converter, x));
        }
        vector.clear();
    }

    private Timestamp createTimestampObject(ArrowVectorConverter converter, int j, TimeZone zone) throws SFException {
        return converter.toTimestamp(j, zone);
    }

    private static /* synthetic */ void lambda$testTimestampNTZ$0(ArrowVectorConverter converter, int x) throws SFException {
        converter.toBoolean(x);
    }
}

