/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.sql.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.TimeZone;
import net.snowflake.client.TestUtil;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.ArrowResultUtil;
import net.snowflake.client.core.arrow.ArrowVectorConverter;
import net.snowflake.client.core.arrow.BaseConverterTest;
import net.snowflake.client.core.arrow.DateConverter;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DateConverterTest
extends BaseConverterTest {
    private BufferAllocator allocator = new RootAllocator(Long.MAX_VALUE);
    private Random random = new Random();
    int[] testDates = new int[]{-8865, -719162, -354285, -244712, -208156, -171664, -135107, 0, 16911};
    String[] expectedDates = new String[]{"1945-09-24", "0001-01-01", "1000-01-01", "1300-01-01", "1400-02-02", "1500-01-01", "1600-02-03", "1970-01-01", "2016-04-20"};

    @Parameterized.Parameters
    public static Object[][] data() {
        return new Object[][]{{"UTC"}, {"America/Los_Angeles"}, {"America/New_York"}, {"Pacific/Honolulu"}, {"Asia/Singapore"}, {"MEZ"}, {"MESZ"}};
    }

    public DateConverterTest(String tz) {
        System.setProperty("user.timezone", tz);
    }

    @Test
    public void testDate() throws SFException {
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "DATE");
        HashSet<Integer> nullValIndex = new HashSet<Integer>();
        FieldType fieldType = new FieldType(true, Types.MinorType.DATEDAY.getType(), null, customFieldMeta);
        DateDayVector vector = new DateDayVector("date", fieldType, this.allocator);
        int i = 0;
        int j = 0;
        while (i < this.testDates.length) {
            boolean isNull = this.random.nextBoolean();
            if (isNull) {
                vector.setNull(j);
                nullValIndex.add(j);
            } else {
                vector.setSafe(j, this.testDates[i++]);
            }
            ++j;
        }
        DateConverter converter = new DateConverter((ValueVector)vector, 0, (DataConversionContext)this);
        int rowCount = j;
        i = 0;
        for (j = 0; j < rowCount; ++j) {
            int intVal = converter.toInt(j);
            String strVal = converter.toString(j);
            Object obj = converter.toObject(j);
            if (strVal != null) {
                Assert.assertFalse((boolean)converter.isNull(j));
            } else {
                Assert.assertTrue((boolean)converter.isNull(j));
            }
            Date oldObj = ArrowResultUtil.getDate((int)intVal, (TimeZone)TimeZone.getTimeZone("UTC"), (TimeZone)TimeZone.getDefault());
            if (nullValIndex.contains(j)) {
                MatcherAssert.assertThat((Object)intVal, (Matcher)CoreMatchers.is((Object)0));
                MatcherAssert.assertThat((Object)obj, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)strVal, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)false, (Matcher)CoreMatchers.is((Object)converter.toBoolean(j)));
                MatcherAssert.assertThat((Object)converter.toBytes(j), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                continue;
            }
            MatcherAssert.assertThat((Object)intVal, (Matcher)CoreMatchers.is((Object)this.testDates[i]));
            MatcherAssert.assertThat((Object)((Date)obj).getTime(), (Matcher)CoreMatchers.is((Object)oldObj.getTime()));
            MatcherAssert.assertThat((Object)obj.toString(), (Matcher)CoreMatchers.is((Object)this.expectedDates[i]));
            MatcherAssert.assertThat((Object)((Date)obj).getTime(), (Matcher)CoreMatchers.is((Object)oldObj.getTime()));
            MatcherAssert.assertThat((Object)((Object)oldObj).toString(), (Matcher)CoreMatchers.is((Object)this.expectedDates[i++]));
            int x = j;
            TestUtil.assertSFException(this.invalidConversionErrorCode, () -> DateConverterTest.lambda$testDate$0((ArrowVectorConverter)converter, x));
        }
        vector.clear();
    }

    @Test
    public void testRandomDates() throws SFException {
        int dateBound = 50000;
        int rowCount = 50000;
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "DATE");
        HashSet<Integer> nullValIndex = new HashSet<Integer>();
        FieldType fieldType = new FieldType(true, Types.MinorType.DATEDAY.getType(), null, customFieldMeta);
        DateDayVector vector = new DateDayVector("date", fieldType, this.allocator);
        int[] rawDates = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            boolean isNull = this.random.nextBoolean();
            if (isNull) {
                nullValIndex.add(i);
                vector.setNull(i);
                continue;
            }
            rawDates[i] = this.random.nextInt(dateBound) - dateBound / 2;
            vector.setSafe(i, rawDates[i]);
        }
        DateConverter converter = new DateConverter((ValueVector)vector, 0, (DataConversionContext)this);
        for (int i = 0; i < rowCount; ++i) {
            int intVal = converter.toInt(i);
            String strVal = converter.toString(i);
            Date obj = converter.toDate(i, this.getTimeZone(), false);
            String str = converter.toString(i);
            if (nullValIndex.contains(i)) {
                MatcherAssert.assertThat((Object)intVal, (Matcher)CoreMatchers.is((Object)0));
                MatcherAssert.assertThat((Object)strVal, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)obj, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                continue;
            }
            Date oldObj = ArrowResultUtil.getDate((int)intVal);
            MatcherAssert.assertThat((Object)intVal, (Matcher)CoreMatchers.is((Object)rawDates[i]));
            MatcherAssert.assertThat((Object)obj.getTime(), (Matcher)CoreMatchers.is((Object)oldObj.getTime()));
        }
    }

    private static /* synthetic */ void lambda$testDate$0(ArrowVectorConverter converter, int x) throws SFException {
        converter.toBoolean(x);
    }
}

