/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import net.snowflake.client.TestUtil;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.ArrowVectorConverter;
import net.snowflake.client.core.arrow.BaseConverterTest;
import net.snowflake.client.core.arrow.DoubleToRealConverter;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class DoubleToRealConverterTest
extends BaseConverterTest {
    private BufferAllocator allocator = new RootAllocator(Long.MAX_VALUE);
    private Random random = new Random();
    private ByteBuffer bb;

    @Test
    public void testConvertToDouble() throws SFException {
        int rowCount = 1000;
        ArrayList<Double> expectedValues = new ArrayList<Double>();
        HashSet<Integer> nullValIndex = new HashSet<Integer>();
        for (int i = 0; i < 1000; ++i) {
            expectedValues.add(this.random.nextDouble());
        }
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "REAL");
        FieldType fieldType = new FieldType(true, Types.MinorType.FLOAT8.getType(), null, customFieldMeta);
        Float8Vector vector = new Float8Vector("col_one", fieldType, this.allocator);
        for (int i = 0; i < 1000; ++i) {
            boolean isNull = this.random.nextBoolean();
            if (isNull) {
                vector.setNull(i);
                nullValIndex.add(i);
                continue;
            }
            vector.setSafe(i, ((Double)expectedValues.get(i)).doubleValue());
        }
        DoubleToRealConverter converter = new DoubleToRealConverter((ValueVector)vector, 0, (DataConversionContext)this);
        for (int i = 0; i < 1000; ++i) {
            double doubleVal = converter.toDouble(i);
            float floatVal = converter.toFloat(i);
            Object doubleObject = converter.toObject(i);
            String doubleString = converter.toString(i);
            if (doubleObject != null) {
                Assert.assertFalse((boolean)converter.isNull(i));
            } else {
                Assert.assertTrue((boolean)converter.isNull(i));
            }
            if (nullValIndex.contains(i)) {
                MatcherAssert.assertThat((Object)doubleVal, (Matcher)CoreMatchers.is((Object)0.0));
                MatcherAssert.assertThat((Object)Float.valueOf(floatVal), (Matcher)CoreMatchers.is((Object)Float.valueOf(0.0f)));
                MatcherAssert.assertThat((Object)doubleObject, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)doubleString, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)false, (Matcher)CoreMatchers.is((Object)converter.toBoolean(i)));
                MatcherAssert.assertThat((Object)converter.toBytes(i), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                continue;
            }
            MatcherAssert.assertThat((Object)doubleVal, (Matcher)CoreMatchers.is((Object)((Double)expectedValues.get(i))));
            MatcherAssert.assertThat((Object)Float.valueOf(floatVal), (Matcher)CoreMatchers.is((Object)Float.valueOf(((Double)expectedValues.get(i)).floatValue())));
            MatcherAssert.assertThat((Object)doubleObject, (Matcher)CoreMatchers.is(expectedValues.get(i)));
            MatcherAssert.assertThat((Object)doubleString, (Matcher)CoreMatchers.is((Object)((Double)expectedValues.get(i)).toString()));
            int x = i;
            TestUtil.assertSFException(this.invalidConversionErrorCode, () -> DoubleToRealConverterTest.lambda$testConvertToDouble$0((ArrowVectorConverter)converter, x));
            this.bb = ByteBuffer.wrap(converter.toBytes(i));
            MatcherAssert.assertThat((Object)doubleVal, (Matcher)CoreMatchers.is((Object)this.bb.getDouble()));
        }
        vector.clear();
    }

    private static /* synthetic */ void lambda$testConvertToDouble$0(ArrowVectorConverter converter, int x) throws SFException {
        converter.toBoolean(x);
    }
}

