/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.TimeZone;
import net.snowflake.client.TestUtil;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.ArrowVectorConverter;
import net.snowflake.client.core.arrow.BaseConverterTest;
import net.snowflake.client.core.arrow.IntToFixedConverter;
import net.snowflake.client.core.arrow.IntToScaledFixedConverter;
import net.snowflake.client.jdbc.ErrorCode;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class IntToFixedConverterTest
extends BaseConverterTest {
    private BufferAllocator allocator = new RootAllocator(Long.MAX_VALUE);
    private Random random = new Random();
    private ByteBuffer bb;

    @Test
    public void testFixedNoScale() throws SFException {
        int rowCount = 1000;
        ArrayList<Integer> expectedValues = new ArrayList<Integer>();
        HashSet<Integer> nullValIndex = new HashSet<Integer>();
        for (int i = 0; i < 1000; ++i) {
            expectedValues.add(this.random.nextInt());
        }
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("precision", "10");
        customFieldMeta.put("scale", "0");
        FieldType fieldType = new FieldType(true, Types.MinorType.INT.getType(), null, customFieldMeta);
        IntVector vector = new IntVector("col_one", fieldType, this.allocator);
        for (int i = 0; i < 1000; ++i) {
            boolean isNull = this.random.nextBoolean();
            if (isNull) {
                vector.setNull(i);
                nullValIndex.add(i);
                continue;
            }
            vector.setSafe(i, ((Integer)expectedValues.get(i)).intValue());
        }
        IntToFixedConverter converter = new IntToFixedConverter((ValueVector)vector, 0, (DataConversionContext)this);
        for (int i = 0; i < 1000; ++i) {
            int intVal = converter.toInt(i);
            Object longObj = converter.toObject(i);
            String intString = converter.toString(i);
            if (intString != null) {
                Assert.assertFalse((boolean)converter.isNull(i));
            } else {
                Assert.assertTrue((boolean)converter.isNull(i));
            }
            if (nullValIndex.contains(i)) {
                MatcherAssert.assertThat((Object)intVal, (Matcher)CoreMatchers.is((Object)0));
                MatcherAssert.assertThat((Object)longObj, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)intString, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)converter.toBytes(i), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                continue;
            }
            MatcherAssert.assertThat((Object)intVal, (Matcher)CoreMatchers.is((Object)((Integer)expectedValues.get(i))));
            Assert.assertEquals((Object)longObj, (Object)((Integer)expectedValues.get(i)));
            MatcherAssert.assertThat((Object)intString, (Matcher)CoreMatchers.is((Object)((Integer)expectedValues.get(i)).toString()));
            this.bb = ByteBuffer.wrap(converter.toBytes(i));
            MatcherAssert.assertThat((Object)intVal, (Matcher)CoreMatchers.is((Object)this.bb.getInt()));
        }
        vector.clear();
    }

    @Test
    public void testFixedWithScale() throws SFException {
        int rowCount = 1000;
        ArrayList<Integer> expectedValues = new ArrayList<Integer>();
        HashSet<Integer> nullValIndex = new HashSet<Integer>();
        for (int i = 0; i < 1000; ++i) {
            expectedValues.add(this.random.nextInt());
        }
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("precision", "10");
        customFieldMeta.put("scale", "3");
        FieldType fieldType = new FieldType(true, Types.MinorType.INT.getType(), null, customFieldMeta);
        IntVector vector = new IntVector("col_one", fieldType, this.allocator);
        for (int i = 0; i < 1000; ++i) {
            boolean isNull = this.random.nextBoolean();
            if (isNull) {
                vector.setNull(i);
                nullValIndex.add(i);
                continue;
            }
            vector.setSafe(i, ((Integer)expectedValues.get(i)).intValue());
        }
        IntToScaledFixedConverter converter = new IntToScaledFixedConverter((ValueVector)vector, 0, (DataConversionContext)this, 3);
        for (int i = 0; i < 1000; ++i) {
            BigDecimal bigDecimalVal = converter.toBigDecimal(i);
            Object objectVal = converter.toObject(i);
            String stringVal = converter.toString(i);
            if (nullValIndex.contains(i)) {
                MatcherAssert.assertThat((Object)bigDecimalVal, (Matcher)CoreMatchers.nullValue());
                MatcherAssert.assertThat((Object)objectVal, (Matcher)CoreMatchers.nullValue());
                MatcherAssert.assertThat((Object)stringVal, (Matcher)CoreMatchers.nullValue());
                MatcherAssert.assertThat((Object)converter.toBytes(i), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                continue;
            }
            BigDecimal expectedVal = BigDecimal.valueOf(((Integer)expectedValues.get(i)).intValue(), 3);
            MatcherAssert.assertThat((Object)bigDecimalVal, (Matcher)CoreMatchers.is((Object)expectedVal));
            MatcherAssert.assertThat((Object)objectVal, (Matcher)CoreMatchers.is((Object)expectedVal));
            MatcherAssert.assertThat((Object)stringVal, (Matcher)CoreMatchers.is((Object)expectedVal.toString()));
            MatcherAssert.assertThat((Object)converter.toBytes(i), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
        vector.clear();
    }

    @Test
    public void testInvalidConversion() {
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("precision", "10");
        customFieldMeta.put("scale", "3");
        FieldType fieldType = new FieldType(true, Types.MinorType.INT.getType(), null, customFieldMeta);
        IntVector vector = new IntVector("col_one", fieldType, this.allocator);
        vector.setSafe(0, 33000);
        IntToScaledFixedConverter converter = new IntToScaledFixedConverter((ValueVector)vector, 0, (DataConversionContext)this, 3);
        int invalidConversionErrorCode = ErrorCode.INVALID_VALUE_CONVERT.getMessageCode();
        TestUtil.assertSFException(invalidConversionErrorCode, () -> IntToFixedConverterTest.lambda$testInvalidConversion$0((ArrowVectorConverter)converter));
        TestUtil.assertSFException(invalidConversionErrorCode, () -> IntToFixedConverterTest.lambda$testInvalidConversion$1((ArrowVectorConverter)converter));
        TestUtil.assertSFException(invalidConversionErrorCode, () -> IntToFixedConverterTest.lambda$testInvalidConversion$2((ArrowVectorConverter)converter));
        TestUtil.assertSFException(invalidConversionErrorCode, () -> IntToFixedConverterTest.lambda$testInvalidConversion$3((ArrowVectorConverter)converter));
        TestUtil.assertSFException(invalidConversionErrorCode, () -> IntToFixedConverterTest.lambda$testInvalidConversion$4((ArrowVectorConverter)converter));
        TestUtil.assertSFException(invalidConversionErrorCode, () -> this.lambda$testInvalidConversion$5((ArrowVectorConverter)converter));
        TestUtil.assertSFException(invalidConversionErrorCode, () -> IntToFixedConverterTest.lambda$testInvalidConversion$6((ArrowVectorConverter)converter));
        TestUtil.assertSFException(invalidConversionErrorCode, () -> IntToFixedConverterTest.lambda$testInvalidConversion$7((ArrowVectorConverter)converter));
        vector.clear();
    }

    @Test
    public void testGetSmallerIntegralType() throws SFException {
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("precision", "10");
        customFieldMeta.put("scale", "0");
        FieldType fieldType = new FieldType(true, Types.MinorType.INT.getType(), null, customFieldMeta);
        IntVector vectorFoo = new IntVector("col_one", fieldType, this.allocator);
        vectorFoo.setSafe(0, 33000);
        vectorFoo.setSafe(1, -33000);
        IntToFixedConverter converterFoo = new IntToFixedConverter((ValueVector)vectorFoo, 0, (DataConversionContext)this);
        int invalidConversionErrorCode = ErrorCode.INVALID_VALUE_CONVERT.getMessageCode();
        TestUtil.assertSFException(invalidConversionErrorCode, () -> IntToFixedConverterTest.lambda$testGetSmallerIntegralType$8((ArrowVectorConverter)converterFoo));
        TestUtil.assertSFException(invalidConversionErrorCode, () -> IntToFixedConverterTest.lambda$testGetSmallerIntegralType$9((ArrowVectorConverter)converterFoo));
        TestUtil.assertSFException(invalidConversionErrorCode, () -> IntToFixedConverterTest.lambda$testGetSmallerIntegralType$10((ArrowVectorConverter)converterFoo));
        TestUtil.assertSFException(invalidConversionErrorCode, () -> IntToFixedConverterTest.lambda$testGetSmallerIntegralType$11((ArrowVectorConverter)converterFoo));
        MatcherAssert.assertThat((Object)converterFoo.toLong(0), (Matcher)CoreMatchers.is((Object)33000L));
        MatcherAssert.assertThat((Object)converterFoo.toLong(1), (Matcher)CoreMatchers.is((Object)-33000L));
        vectorFoo.clear();
        IntVector vectorBar = new IntVector("col_one", fieldType, this.allocator);
        vectorBar.setSafe(0, 10);
        vectorBar.setSafe(1, -10);
        IntToFixedConverter converterBar = new IntToFixedConverter((ValueVector)vectorBar, 0, (DataConversionContext)this);
        MatcherAssert.assertThat((Object)converterBar.toByte(0), (Matcher)CoreMatchers.is((Object)10));
        MatcherAssert.assertThat((Object)converterBar.toByte(1), (Matcher)CoreMatchers.is((Object)-10));
        MatcherAssert.assertThat((Object)converterBar.toShort(0), (Matcher)CoreMatchers.is((Object)10));
        MatcherAssert.assertThat((Object)converterBar.toShort(1), (Matcher)CoreMatchers.is((Object)-10));
        MatcherAssert.assertThat((Object)converterBar.toLong(0), (Matcher)CoreMatchers.is((Object)10L));
        MatcherAssert.assertThat((Object)converterBar.toLong(1), (Matcher)CoreMatchers.is((Object)-10L));
        vectorBar.clear();
    }

    @Test
    public void testGetBooleanNoScale() throws SFException {
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("precision", "10");
        customFieldMeta.put("scale", "0");
        FieldType fieldType = new FieldType(true, Types.MinorType.INT.getType(), null, customFieldMeta);
        IntVector vector = new IntVector("col_one", fieldType, this.allocator);
        vector.setSafe(0, 0);
        vector.setSafe(1, 1);
        vector.setNull(2);
        vector.setSafe(3, 5);
        IntToFixedConverter converter = new IntToFixedConverter((ValueVector)vector, 0, (DataConversionContext)this);
        MatcherAssert.assertThat((Object)false, (Matcher)CoreMatchers.is((Object)converter.toBoolean(0)));
        MatcherAssert.assertThat((Object)true, (Matcher)CoreMatchers.is((Object)converter.toBoolean(1)));
        MatcherAssert.assertThat((Object)false, (Matcher)CoreMatchers.is((Object)converter.toBoolean(2)));
        TestUtil.assertSFException(this.invalidConversionErrorCode, () -> IntToFixedConverterTest.lambda$testGetBooleanNoScale$12((ArrowVectorConverter)converter));
        vector.close();
    }

    @Test
    public void testGetBooleanWithScale() throws SFException {
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("precision", "10");
        customFieldMeta.put("scale", "3");
        FieldType fieldType = new FieldType(true, Types.MinorType.INT.getType(), null, customFieldMeta);
        IntVector vector = new IntVector("col_one", fieldType, this.allocator);
        vector.setSafe(0, 0);
        vector.setSafe(1, 1);
        vector.setNull(2);
        vector.setSafe(3, 5);
        IntToScaledFixedConverter converter = new IntToScaledFixedConverter((ValueVector)vector, 0, (DataConversionContext)this, 3);
        MatcherAssert.assertThat((Object)false, (Matcher)CoreMatchers.is((Object)converter.toBoolean(0)));
        TestUtil.assertSFException(this.invalidConversionErrorCode, () -> IntToFixedConverterTest.lambda$testGetBooleanWithScale$13((ArrowVectorConverter)converter));
        MatcherAssert.assertThat((Object)false, (Matcher)CoreMatchers.is((Object)converter.toBoolean(2)));
        TestUtil.assertSFException(this.invalidConversionErrorCode, () -> IntToFixedConverterTest.lambda$testGetBooleanWithScale$14((ArrowVectorConverter)converter));
        vector.close();
    }

    private static /* synthetic */ void lambda$testGetBooleanWithScale$14(ArrowVectorConverter converter) throws SFException {
        converter.toBoolean(3);
    }

    private static /* synthetic */ void lambda$testGetBooleanWithScale$13(ArrowVectorConverter converter) throws SFException {
        converter.toBoolean(3);
    }

    private static /* synthetic */ void lambda$testGetBooleanNoScale$12(ArrowVectorConverter converter) throws SFException {
        converter.toBoolean(3);
    }

    private static /* synthetic */ void lambda$testGetSmallerIntegralType$11(ArrowVectorConverter converterFoo) throws SFException {
        converterFoo.toByte(1);
    }

    private static /* synthetic */ void lambda$testGetSmallerIntegralType$10(ArrowVectorConverter converterFoo) throws SFException {
        converterFoo.toShort(1);
    }

    private static /* synthetic */ void lambda$testGetSmallerIntegralType$9(ArrowVectorConverter converterFoo) throws SFException {
        converterFoo.toByte(0);
    }

    private static /* synthetic */ void lambda$testGetSmallerIntegralType$8(ArrowVectorConverter converterFoo) throws SFException {
        converterFoo.toShort(0);
    }

    private static /* synthetic */ void lambda$testInvalidConversion$7(ArrowVectorConverter converter) throws SFException {
        converter.toTimestamp(0, TimeZone.getDefault());
    }

    private static /* synthetic */ void lambda$testInvalidConversion$6(ArrowVectorConverter converter) throws SFException {
        converter.toTime(0);
    }

    private /* synthetic */ void lambda$testInvalidConversion$5(ArrowVectorConverter converter) throws SFException {
        converter.toDate(0, this.getTimeZone(), false);
    }

    private static /* synthetic */ void lambda$testInvalidConversion$4(ArrowVectorConverter converter) throws SFException {
        converter.toByte(0);
    }

    private static /* synthetic */ void lambda$testInvalidConversion$3(ArrowVectorConverter converter) throws SFException {
        converter.toShort(0);
    }

    private static /* synthetic */ void lambda$testInvalidConversion$2(ArrowVectorConverter converter) throws SFException {
        converter.toInt(0);
    }

    private static /* synthetic */ void lambda$testInvalidConversion$1(ArrowVectorConverter converter) throws SFException {
        converter.toLong(0);
    }

    private static /* synthetic */ void lambda$testInvalidConversion$0(ArrowVectorConverter converter) throws SFException {
        converter.toBoolean(0);
    }
}

