/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.TimeZone;
import net.snowflake.client.TestUtil;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.ArrowVectorConverter;
import net.snowflake.client.core.arrow.BaseConverterTest;
import net.snowflake.client.core.arrow.SmallIntToFixedConverter;
import net.snowflake.client.core.arrow.SmallIntToScaledFixedConverter;
import net.snowflake.client.jdbc.ErrorCode;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class SmallIntToFixedConverterTest
extends BaseConverterTest {
    private BufferAllocator allocator = new RootAllocator(Long.MAX_VALUE);
    private Random random = new Random();
    private ByteBuffer bb;

    @Test
    public void testFixedNoScale() throws SFException {
        int rowCount = 1000;
        ArrayList<Short> expectedValues = new ArrayList<Short>();
        HashSet<Integer> nullValIndex = new HashSet<Integer>();
        for (int i = 0; i < 1000; ++i) {
            expectedValues.add((short)this.random.nextInt(65536));
        }
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("precision", "10");
        customFieldMeta.put("scale", "0");
        FieldType fieldType = new FieldType(true, Types.MinorType.SMALLINT.getType(), null, customFieldMeta);
        SmallIntVector vector = new SmallIntVector("col_one", fieldType, this.allocator);
        for (int i = 0; i < 1000; ++i) {
            boolean isNull = this.random.nextBoolean();
            if (isNull) {
                vector.setNull(i);
                nullValIndex.add(i);
                continue;
            }
            vector.setSafe(i, ((Short)expectedValues.get(i)).shortValue());
        }
        SmallIntToFixedConverter converter = new SmallIntToFixedConverter((ValueVector)vector, 0, (DataConversionContext)this);
        for (int i = 0; i < 1000; ++i) {
            short shortVal = converter.toShort(i);
            Object longObject = converter.toObject(i);
            String shortString = converter.toString(i);
            if (shortString != null) {
                Assert.assertFalse((boolean)converter.isNull(i));
            } else {
                Assert.assertTrue((boolean)converter.isNull(i));
            }
            if (nullValIndex.contains(i)) {
                MatcherAssert.assertThat((Object)shortVal, (Matcher)CoreMatchers.is((Object)0));
                MatcherAssert.assertThat((Object)longObject, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)shortString, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)converter.toBytes(i), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                continue;
            }
            MatcherAssert.assertThat((Object)shortVal, (Matcher)CoreMatchers.is((Object)((Short)expectedValues.get(i))));
            Assert.assertEquals((Object)longObject, (Object)((Short)expectedValues.get(i)));
            MatcherAssert.assertThat((Object)shortString, (Matcher)CoreMatchers.is((Object)((Short)expectedValues.get(i)).toString()));
            this.bb = ByteBuffer.wrap(converter.toBytes(i));
            MatcherAssert.assertThat((Object)shortVal, (Matcher)CoreMatchers.is((Object)this.bb.getShort()));
        }
        vector.clear();
    }

    @Test
    public void testFixedWithScale() throws SFException {
        int rowCount = 1000;
        ArrayList<Short> expectedValues = new ArrayList<Short>();
        HashSet<Integer> nullValIndex = new HashSet<Integer>();
        for (int i = 0; i < 1000; ++i) {
            expectedValues.add((short)this.random.nextInt(65536));
        }
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("precision", "10");
        customFieldMeta.put("scale", "3");
        FieldType fieldType = new FieldType(true, Types.MinorType.SMALLINT.getType(), null, customFieldMeta);
        SmallIntVector vector = new SmallIntVector("col_one", fieldType, this.allocator);
        for (int i = 0; i < 1000; ++i) {
            boolean isNull = this.random.nextBoolean();
            if (isNull) {
                vector.setNull(i);
                nullValIndex.add(i);
                continue;
            }
            vector.setSafe(i, ((Short)expectedValues.get(i)).shortValue());
        }
        SmallIntToScaledFixedConverter converter = new SmallIntToScaledFixedConverter((ValueVector)vector, 0, (DataConversionContext)this, 3);
        for (int i = 0; i < 1000; ++i) {
            BigDecimal bigDecimalVal = converter.toBigDecimal(i);
            Object objectVal = converter.toObject(i);
            String stringVal = converter.toString(i);
            if (nullValIndex.contains(i)) {
                MatcherAssert.assertThat((Object)bigDecimalVal, (Matcher)CoreMatchers.nullValue());
                MatcherAssert.assertThat((Object)objectVal, (Matcher)CoreMatchers.nullValue());
                MatcherAssert.assertThat((Object)stringVal, (Matcher)CoreMatchers.nullValue());
                MatcherAssert.assertThat((Object)converter.toBytes(i), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                continue;
            }
            BigDecimal expectedVal = BigDecimal.valueOf(((Short)expectedValues.get(i)).shortValue(), 3);
            MatcherAssert.assertThat((Object)bigDecimalVal, (Matcher)CoreMatchers.is((Object)expectedVal));
            MatcherAssert.assertThat((Object)objectVal, (Matcher)CoreMatchers.is((Object)expectedVal));
            MatcherAssert.assertThat((Object)stringVal, (Matcher)CoreMatchers.is((Object)expectedVal.toString()));
            MatcherAssert.assertThat((Object)converter.toBytes(i), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
        vector.clear();
    }

    @Test
    public void testInvalidConversion() {
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("precision", "10");
        customFieldMeta.put("scale", "3");
        FieldType fieldType = new FieldType(true, Types.MinorType.SMALLINT.getType(), null, customFieldMeta);
        SmallIntVector vector = new SmallIntVector("col_one", fieldType, this.allocator);
        vector.setSafe(0, 200);
        SmallIntToScaledFixedConverter converter = new SmallIntToScaledFixedConverter((ValueVector)vector, 0, (DataConversionContext)this, 3);
        int invalidConversionErrorCode = ErrorCode.INVALID_VALUE_CONVERT.getMessageCode();
        TestUtil.assertSFException(invalidConversionErrorCode, () -> SmallIntToFixedConverterTest.lambda$testInvalidConversion$0((ArrowVectorConverter)converter));
        TestUtil.assertSFException(invalidConversionErrorCode, () -> SmallIntToFixedConverterTest.lambda$testInvalidConversion$1((ArrowVectorConverter)converter));
        TestUtil.assertSFException(invalidConversionErrorCode, () -> SmallIntToFixedConverterTest.lambda$testInvalidConversion$2((ArrowVectorConverter)converter));
        TestUtil.assertSFException(invalidConversionErrorCode, () -> SmallIntToFixedConverterTest.lambda$testInvalidConversion$3((ArrowVectorConverter)converter));
        TestUtil.assertSFException(invalidConversionErrorCode, () -> SmallIntToFixedConverterTest.lambda$testInvalidConversion$4((ArrowVectorConverter)converter));
        TestUtil.assertSFException(invalidConversionErrorCode, () -> this.lambda$testInvalidConversion$5((ArrowVectorConverter)converter));
        TestUtil.assertSFException(invalidConversionErrorCode, () -> SmallIntToFixedConverterTest.lambda$testInvalidConversion$6((ArrowVectorConverter)converter));
        TestUtil.assertSFException(invalidConversionErrorCode, () -> SmallIntToFixedConverterTest.lambda$testInvalidConversion$7((ArrowVectorConverter)converter));
        vector.clear();
    }

    @Test
    public void testGetSmallerIntegralType() throws SFException {
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("precision", "10");
        customFieldMeta.put("scale", "0");
        FieldType fieldType = new FieldType(true, Types.MinorType.SMALLINT.getType(), null, customFieldMeta);
        SmallIntVector vectorFoo = new SmallIntVector("col_one", fieldType, this.allocator);
        vectorFoo.setSafe(0, 200);
        vectorFoo.setSafe(1, -200);
        SmallIntToFixedConverter converterFoo = new SmallIntToFixedConverter((ValueVector)vectorFoo, 0, (DataConversionContext)this);
        int invalidConversionErrorCode = ErrorCode.INVALID_VALUE_CONVERT.getMessageCode();
        TestUtil.assertSFException(invalidConversionErrorCode, () -> SmallIntToFixedConverterTest.lambda$testGetSmallerIntegralType$8((ArrowVectorConverter)converterFoo));
        TestUtil.assertSFException(invalidConversionErrorCode, () -> SmallIntToFixedConverterTest.lambda$testGetSmallerIntegralType$9((ArrowVectorConverter)converterFoo));
        vectorFoo.clear();
        SmallIntVector vectorBar = new SmallIntVector("col_one", fieldType, this.allocator);
        vectorBar.setSafe(0, 10);
        vectorBar.setSafe(1, -10);
        SmallIntToFixedConverter converterBar = new SmallIntToFixedConverter((ValueVector)vectorBar, 0, (DataConversionContext)this);
        MatcherAssert.assertThat((Object)converterBar.toByte(0), (Matcher)CoreMatchers.is((Object)10));
        MatcherAssert.assertThat((Object)converterBar.toByte(1), (Matcher)CoreMatchers.is((Object)-10));
        MatcherAssert.assertThat((Object)converterBar.toInt(0), (Matcher)CoreMatchers.is((Object)10));
        MatcherAssert.assertThat((Object)converterBar.toInt(1), (Matcher)CoreMatchers.is((Object)-10));
        MatcherAssert.assertThat((Object)converterBar.toLong(0), (Matcher)CoreMatchers.is((Object)10L));
        MatcherAssert.assertThat((Object)converterBar.toLong(1), (Matcher)CoreMatchers.is((Object)-10L));
        vectorBar.clear();
    }

    @Test
    public void testGetBooleanNoScale() throws SFException {
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("precision", "10");
        customFieldMeta.put("scale", "0");
        FieldType fieldType = new FieldType(true, Types.MinorType.SMALLINT.getType(), null, customFieldMeta);
        SmallIntVector vector = new SmallIntVector("col_one", fieldType, this.allocator);
        vector.setSafe(0, 0);
        vector.setSafe(1, 1);
        vector.setNull(2);
        vector.setSafe(3, 5);
        SmallIntToFixedConverter converter = new SmallIntToFixedConverter((ValueVector)vector, 0, (DataConversionContext)this);
        MatcherAssert.assertThat((Object)false, (Matcher)CoreMatchers.is((Object)converter.toBoolean(0)));
        MatcherAssert.assertThat((Object)true, (Matcher)CoreMatchers.is((Object)converter.toBoolean(1)));
        MatcherAssert.assertThat((Object)false, (Matcher)CoreMatchers.is((Object)converter.toBoolean(2)));
        Assert.assertFalse((boolean)converter.isNull(0));
        Assert.assertFalse((boolean)converter.isNull(1));
        Assert.assertTrue((boolean)converter.isNull(2));
        Assert.assertFalse((boolean)converter.isNull(3));
        TestUtil.assertSFException(this.invalidConversionErrorCode, () -> SmallIntToFixedConverterTest.lambda$testGetBooleanNoScale$10((ArrowVectorConverter)converter));
        vector.close();
    }

    @Test
    public void testGetBooleanWithScale() throws SFException {
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("precision", "10");
        customFieldMeta.put("scale", "3");
        FieldType fieldType = new FieldType(true, Types.MinorType.SMALLINT.getType(), null, customFieldMeta);
        SmallIntVector vector = new SmallIntVector("col_one", fieldType, this.allocator);
        vector.setSafe(0, 0);
        vector.setSafe(1, 1);
        vector.setNull(2);
        vector.setSafe(3, 5);
        SmallIntToScaledFixedConverter converter = new SmallIntToScaledFixedConverter((ValueVector)vector, 0, (DataConversionContext)this, 3);
        MatcherAssert.assertThat((Object)false, (Matcher)CoreMatchers.is((Object)converter.toBoolean(0)));
        TestUtil.assertSFException(this.invalidConversionErrorCode, () -> SmallIntToFixedConverterTest.lambda$testGetBooleanWithScale$11((ArrowVectorConverter)converter));
        MatcherAssert.assertThat((Object)false, (Matcher)CoreMatchers.is((Object)converter.toBoolean(2)));
        TestUtil.assertSFException(this.invalidConversionErrorCode, () -> SmallIntToFixedConverterTest.lambda$testGetBooleanWithScale$12((ArrowVectorConverter)converter));
        vector.close();
    }

    private static /* synthetic */ void lambda$testGetBooleanWithScale$12(ArrowVectorConverter converter) throws SFException {
        converter.toBoolean(3);
    }

    private static /* synthetic */ void lambda$testGetBooleanWithScale$11(ArrowVectorConverter converter) throws SFException {
        converter.toBoolean(3);
    }

    private static /* synthetic */ void lambda$testGetBooleanNoScale$10(ArrowVectorConverter converter) throws SFException {
        converter.toBoolean(3);
    }

    private static /* synthetic */ void lambda$testGetSmallerIntegralType$9(ArrowVectorConverter converterFoo) throws SFException {
        converterFoo.toByte(1);
    }

    private static /* synthetic */ void lambda$testGetSmallerIntegralType$8(ArrowVectorConverter converterFoo) throws SFException {
        converterFoo.toByte(0);
    }

    private static /* synthetic */ void lambda$testInvalidConversion$7(ArrowVectorConverter converter) throws SFException {
        converter.toTimestamp(0, TimeZone.getDefault());
    }

    private static /* synthetic */ void lambda$testInvalidConversion$6(ArrowVectorConverter converter) throws SFException {
        converter.toTime(0);
    }

    private /* synthetic */ void lambda$testInvalidConversion$5(ArrowVectorConverter converter) throws SFException {
        converter.toDate(0, this.getTimeZone(), false);
    }

    private static /* synthetic */ void lambda$testInvalidConversion$4(ArrowVectorConverter converter) throws SFException {
        converter.toByte(0);
    }

    private static /* synthetic */ void lambda$testInvalidConversion$3(ArrowVectorConverter converter) throws SFException {
        converter.toShort(0);
    }

    private static /* synthetic */ void lambda$testInvalidConversion$2(ArrowVectorConverter converter) throws SFException {
        converter.toInt(0);
    }

    private static /* synthetic */ void lambda$testInvalidConversion$1(ArrowVectorConverter converter) throws SFException {
        converter.toLong(0);
    }

    private static /* synthetic */ void lambda$testInvalidConversion$0(ArrowVectorConverter converter) throws SFException {
        converter.toBoolean(0);
    }
}

