/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.TimeZone;
import net.snowflake.client.TestUtil;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.ArrowVectorConverter;
import net.snowflake.client.core.arrow.BaseConverterTest;
import net.snowflake.client.core.arrow.TwoFieldStructToTimestampNTZConverter;
import net.snowflake.common.core.SFTimestamp;
import net.snowflake.common.core.SnowflakeDateTimeFormat;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TwoFieldStructToTimestampNTZConverterTest
extends BaseConverterTest {
    private BufferAllocator allocator = new RootAllocator(Long.MAX_VALUE);
    private Random random = new Random();
    private int oldScale = 9;

    @Parameterized.Parameters
    public static Object[][] data() {
        return new Object[][]{{"UTC"}, {"America/Los_Angeles"}, {"America/New_York"}, {"Pacific/Honolulu"}, {"Asia/Singapore"}, {"MEZ"}, {"MESZ"}};
    }

    public TwoFieldStructToTimestampNTZConverterTest(String tz) {
        System.setProperty("user.timezone", tz);
    }

    @Test
    public void timestampOverflowTest() throws SFException {
        long[] testSecondsInt64 = new long[]{154639183700000L};
        int[] testNanoSecs = new int[]{0};
        String[] testTimesJson = new String[]{"154639183700000.000000000"};
        this.setHonorClientTZForTimestampNTZ(false);
        this.testTimestampNTZ(testSecondsInt64, testNanoSecs, testTimesJson);
    }

    @Test
    public void testHonorClientTZForTimestampNTZDisabled() throws SFException {
        long[] testSecondsInt64 = new long[]{1546391837L, 0L, -1546391838L, -1546391838L, -1546391838L};
        int[] testNanoSecs = new int[]{0, 1, 999999990, 876543211, 1};
        String[] testTimesJson = new String[]{"1546391837.000000000", "0.000000001", "-1546391837.000000010", "-1546391837.123456789", "-1546391837.999999999"};
        this.setHonorClientTZForTimestampNTZ(false);
        this.testTimestampNTZ(testSecondsInt64, testNanoSecs, testTimesJson);
    }

    @Test
    public void testHonorClientTZForTimestampNTZEnabled() throws SFException {
        long[] testSecondsInt64 = new long[]{1546391837L, 1546391837L, 1546391837L, 1546391837L, 1546391837L};
        int[] testNanoSecs = new int[]{0, 1, 10, 100, 999999999};
        String[] testTimesJson = new String[]{"1546391837.000000000", "1546391837.000000001", "1546391837.000000010", "1546391837.000000100", "1546391837.999999999"};
        this.setHonorClientTZForTimestampNTZ(true);
        this.testTimestampNTZ(testSecondsInt64, testNanoSecs, testTimesJson);
    }

    public void testTimestampNTZ(long[] testSecondsInt64, int[] testNanoSecs, String[] testTimesJson) throws SFException {
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "TIMESTAMP");
        HashSet<Integer> nullValIndex = new HashSet<Integer>();
        FieldType fieldType = new FieldType(true, Types.MinorType.BIGINT.getType(), null, customFieldMeta);
        FieldType fieldType2 = new FieldType(true, Types.MinorType.INT.getType(), null, customFieldMeta);
        StructVector structVector = StructVector.empty((String)"testListVector", (BufferAllocator)this.allocator);
        LinkedList<Field> fieldList = new LinkedList<Field>();
        Field bigIntField = new Field("epoch", fieldType, null);
        Field intField = new Field("fraction", fieldType2, null);
        fieldList.add(bigIntField);
        fieldList.add(intField);
        structVector.initializeChildrenFromFields(fieldList);
        BigIntVector epochs = (BigIntVector)structVector.getChild("epoch", BigIntVector.class);
        IntVector fractions = (IntVector)structVector.getChild("fraction", IntVector.class);
        int i = 0;
        int j = 0;
        while (i < testSecondsInt64.length) {
            boolean isNull = this.random.nextBoolean();
            if (isNull) {
                epochs.setNull(j);
                fractions.setNull(j);
                nullValIndex.add(j);
            } else {
                epochs.setSafe(j, testSecondsInt64[i]);
                fractions.setSafe(j, testNanoSecs[i++]);
            }
            ++j;
        }
        TwoFieldStructToTimestampNTZConverter converter = new TwoFieldStructToTimestampNTZConverter((ValueVector)structVector, 0, (DataConversionContext)this);
        int rowCount = j;
        i = 0;
        for (j = 0; j < rowCount; ++j) {
            Timestamp ts = converter.toTimestamp(j, TimeZone.getDefault());
            Date date = converter.toDate(j, this.getTimeZone(), false);
            Time time = converter.toTime(j);
            String tsStr = converter.toString(j);
            if (tsStr != null) {
                Assert.assertFalse((boolean)converter.isNull(j));
            } else {
                Assert.assertTrue((boolean)converter.isNull(j));
            }
            if (nullValIndex.contains(j)) {
                MatcherAssert.assertThat((Object)ts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)date, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)false, (Matcher)CoreMatchers.is((Object)converter.toBoolean(j)));
                MatcherAssert.assertThat((Object)converter.toBytes(j), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                continue;
            }
            SFTimestamp sfTimestamp = ResultUtil.getSFTimestamp((String)testTimesJson[i], (int)this.oldScale, (int)93, (long)this.getResultVersion(), (TimeZone)this.getTimeZone(), (SFBaseSession)this.getSession());
            Timestamp oldTs = sfTimestamp.getTimestamp();
            if (this.getHonorClientTZForTimestampNTZ()) {
                oldTs = sfTimestamp.moveToTimeZone(this.getTimeZone()).getTimestamp();
            }
            oldTs = ResultUtil.adjustTimestamp((Timestamp)oldTs);
            SFTimestamp sfTS = ResultUtil.getSFTimestamp((String)testTimesJson[i], (int)this.oldScale, (int)93, (long)this.getResultVersion(), (TimeZone)this.getTimeZone(), (SFBaseSession)this.getSession());
            String timestampStr = ResultUtil.getSFTimestampAsString((SFTimestamp)sfTS, (int)93, (int)this.oldScale, (SnowflakeDateTimeFormat)this.getTimestampNTZFormatter(), (SnowflakeDateTimeFormat)this.getTimestampLTZFormatter(), (SnowflakeDateTimeFormat)this.getTimestampTZFormatter(), (SFBaseSession)this.getSession());
            Date oldDate = new Date(oldTs.getTime());
            Time oldTime = new Time(oldTs.getTime());
            MatcherAssert.assertThat((Object)oldTs, (Matcher)CoreMatchers.is((Object)ts));
            MatcherAssert.assertThat((Object)oldDate, (Matcher)CoreMatchers.is((Object)date));
            MatcherAssert.assertThat((Object)timestampStr, (Matcher)CoreMatchers.is((Object)tsStr));
            MatcherAssert.assertThat((Object)oldTime, (Matcher)CoreMatchers.is((Object)time));
            ++i;
            int x = j;
            TestUtil.assertSFException(this.invalidConversionErrorCode, () -> TwoFieldStructToTimestampNTZConverterTest.lambda$testTimestampNTZ$0((ArrowVectorConverter)converter, x));
            TestUtil.assertSFException(this.invalidConversionErrorCode, () -> TwoFieldStructToTimestampNTZConverterTest.lambda$testTimestampNTZ$1((ArrowVectorConverter)converter, x));
        }
        structVector.clear();
    }

    private static /* synthetic */ void lambda$testTimestampNTZ$1(ArrowVectorConverter converter, int x) throws SFException {
        converter.toBytes(x);
    }

    private static /* synthetic */ void lambda$testTimestampNTZ$0(ArrowVectorConverter converter, int x) throws SFException {
        converter.toBoolean(x);
    }
}

