/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import net.snowflake.client.TestUtil;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.ArrowVectorConverter;
import net.snowflake.client.core.arrow.BaseConverterTest;
import net.snowflake.client.core.arrow.VarBinaryToBinaryConverter;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class VarBinaryToBinaryConverterTest
extends BaseConverterTest {
    private BufferAllocator allocator = new RootAllocator(Long.MAX_VALUE);
    private Random random = new Random();

    @Test
    public void testConvertToString() throws SFException {
        int rowCount = 1000;
        ArrayList<byte[]> expectedValues = new ArrayList<byte[]>();
        HashSet<Integer> nullValIndex = new HashSet<Integer>();
        for (int i = 0; i < 1000; ++i) {
            expectedValues.add(RandomStringUtils.random((int)20).getBytes());
        }
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "BINARY");
        FieldType fieldType = new FieldType(true, Types.MinorType.VARBINARY.getType(), null, customFieldMeta);
        VarBinaryVector vector = new VarBinaryVector("col_one", fieldType, this.allocator);
        for (int i = 0; i < 1000; ++i) {
            boolean isNull = this.random.nextBoolean();
            if (isNull) {
                vector.setNull(i);
                nullValIndex.add(i);
                continue;
            }
            vector.setSafe(i, (byte[])expectedValues.get(i));
        }
        VarBinaryToBinaryConverter converter = new VarBinaryToBinaryConverter((ValueVector)vector, 0, (DataConversionContext)this);
        for (int i = 0; i < 1000; ++i) {
            String stringVal = converter.toString(i);
            Object objectVal = converter.toObject(i);
            byte[] bytesVal = converter.toBytes(i);
            if (stringVal != null) {
                Assert.assertFalse((boolean)converter.isNull(i));
            } else {
                Assert.assertTrue((boolean)converter.isNull(i));
            }
            if (nullValIndex.contains(i)) {
                MatcherAssert.assertThat((Object)stringVal, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)objectVal, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)bytesVal, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)false, (Matcher)CoreMatchers.is((Object)converter.toBoolean(i)));
                continue;
            }
            String base64Expected = Base64.getEncoder().encodeToString((byte[])expectedValues.get(i));
            MatcherAssert.assertThat((Object)stringVal, (Matcher)CoreMatchers.is((Object)base64Expected));
            MatcherAssert.assertThat((Object)bytesVal, (Matcher)CoreMatchers.is((Object)((byte[])expectedValues.get(i))));
            MatcherAssert.assertThat((Object)objectVal, (Matcher)CoreMatchers.is(expectedValues.get(i)));
            int x = i;
            TestUtil.assertSFException(this.invalidConversionErrorCode, () -> VarBinaryToBinaryConverterTest.lambda$testConvertToString$0((ArrowVectorConverter)converter, x));
        }
        vector.clear();
    }

    private static /* synthetic */ void lambda$testConvertToString$0(ArrowVectorConverter converter, int x) throws SFException {
        converter.toBoolean(x);
    }
}

