/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import net.snowflake.client.TestUtil;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.ArrowVectorConverter;
import net.snowflake.client.core.arrow.BaseConverterTest;
import net.snowflake.client.core.arrow.VarCharConverter;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class VarCharConverterTest
extends BaseConverterTest {
    private BufferAllocator allocator = new RootAllocator(Long.MAX_VALUE);
    private Random random = new Random();

    @Test
    public void testConvertToString() throws SFException {
        int rowCount = 1000;
        ArrayList<String> expectedValues = new ArrayList<String>();
        HashSet<Integer> nullValIndex = new HashSet<Integer>();
        for (int i = 0; i < 1000; ++i) {
            expectedValues.add(RandomStringUtils.random((int)20));
        }
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        FieldType fieldType = new FieldType(true, Types.MinorType.VARCHAR.getType(), null, customFieldMeta);
        VarCharVector vector = new VarCharVector("col_one", fieldType, this.allocator);
        for (int i = 0; i < 1000; ++i) {
            boolean isNull = this.random.nextBoolean();
            if (isNull) {
                vector.setNull(i);
                nullValIndex.add(i);
                continue;
            }
            vector.setSafe(i, ((String)expectedValues.get(i)).getBytes(StandardCharsets.UTF_8));
        }
        VarCharConverter converter = new VarCharConverter((ValueVector)vector, 0, (DataConversionContext)this);
        for (int i = 0; i < 1000; ++i) {
            String stringVal = converter.toString(i);
            Object objectVal = converter.toObject(i);
            byte[] bytesVal = converter.toBytes(i);
            if (stringVal != null) {
                Assert.assertFalse((boolean)converter.isNull(i));
            } else {
                Assert.assertTrue((boolean)converter.isNull(i));
            }
            if (nullValIndex.contains(i)) {
                MatcherAssert.assertThat((Object)stringVal, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)objectVal, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)bytesVal, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                continue;
            }
            MatcherAssert.assertThat((Object)stringVal, (Matcher)CoreMatchers.is((Object)((String)expectedValues.get(i))));
            MatcherAssert.assertThat((Object)objectVal, (Matcher)CoreMatchers.is(expectedValues.get(i)));
            MatcherAssert.assertThat((Object)bytesVal, (Matcher)CoreMatchers.is((Object)((String)expectedValues.get(i)).getBytes(StandardCharsets.UTF_8)));
        }
        vector.clear();
    }

    @Test
    public void testGetBoolean() throws SFException {
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        FieldType fieldType = new FieldType(true, Types.MinorType.VARCHAR.getType(), null, customFieldMeta);
        VarCharVector vector = new VarCharVector("col_one", fieldType, this.allocator);
        vector.setSafe(0, "0".getBytes(StandardCharsets.UTF_8));
        vector.setSafe(1, "1".getBytes(StandardCharsets.UTF_8));
        vector.setNull(2);
        vector.setSafe(3, "5".getBytes(StandardCharsets.UTF_8));
        VarCharConverter converter = new VarCharConverter((ValueVector)vector, 0, (DataConversionContext)this);
        MatcherAssert.assertThat((Object)false, (Matcher)CoreMatchers.is((Object)converter.toBoolean(0)));
        MatcherAssert.assertThat((Object)true, (Matcher)CoreMatchers.is((Object)converter.toBoolean(1)));
        MatcherAssert.assertThat((Object)false, (Matcher)CoreMatchers.is((Object)converter.toBoolean(2)));
        TestUtil.assertSFException(this.invalidConversionErrorCode, () -> VarCharConverterTest.lambda$testGetBoolean$0((ArrowVectorConverter)converter));
        vector.close();
    }

    private static /* synthetic */ void lambda$testGetBoolean$0(ArrowVectorConverter converter) throws SFException {
        converter.toBoolean(3);
    }
}

