/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.category.TestCategoryOthers;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryOthers.class})
public class BindingDataLatestIT
extends AbstractDriverIT {
    @Test
    public void testBindTimestampTZ() throws SQLException {
        Connection connection = BindingDataLatestIT.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table testBindTimestampTZ(cola int, colb timestamp_tz)");
        statement.execute("alter session set CLIENT_TIMESTAMP_TYPE_MAPPING=TIMESTAMP_TZ");
        long millSeconds = System.currentTimeMillis();
        Timestamp ts = new Timestamp(millSeconds);
        PreparedStatement prepStatement = connection.prepareStatement("insert into testBindTimestampTZ values (?, ?)");
        prepStatement.setInt(1, 123);
        prepStatement.setTimestamp(2, ts, Calendar.getInstance(TimeZone.getTimeZone("EST")));
        prepStatement.execute();
        ResultSet resultSet = statement.executeQuery("select cola, colb from testBindTimestampTz");
        resultSet.next();
        MatcherAssert.assertThat((String)"integer", (Object)resultSet.getInt(1), (Matcher)CoreMatchers.equalTo((Object)123));
        MatcherAssert.assertThat((String)"timestamp_tz", (Object)resultSet.getTimestamp(2), (Matcher)CoreMatchers.equalTo((Object)ts));
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testTimestampBindingWithNTZType() throws SQLException {
        try (Connection connection = BindingDataLatestIT.getConnection();){
            TimeZone origTz = TimeZone.getDefault();
            Statement statement = connection.createStatement();
            statement.execute("create or replace table stageinsert(ind int, ltz0 timestamp_ltz, tz0 timestamp_tz, ntz0 timestamp_ntz)");
            statement.execute("create or replace table regularinsert(ind int, ltz0 timestamp_ltz, tz0 timestamp_tz, ntz0 timestamp_ntz)");
            statement.execute("alter session set CLIENT_TIMESTAMP_TYPE_MAPPING=TIMESTAMP_NTZ");
            statement.execute("alter session set TIMEZONE='Asia/Tokyo'");
            TimeZone.setDefault(TimeZone.getTimeZone("Asia/Tokyo"));
            Timestamp currT = new Timestamp(System.currentTimeMillis());
            PreparedStatement prepStatement = connection.prepareStatement("insert into stageinsert values (?,?,?,?)");
            statement.execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 1");
            prepStatement.setInt(1, 1);
            prepStatement.setTimestamp(2, currT);
            prepStatement.setTimestamp(3, currT);
            prepStatement.setTimestamp(4, currT);
            prepStatement.addBatch();
            prepStatement.executeBatch();
            statement.execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 0");
            prepStatement = connection.prepareStatement("insert into regularinsert values (?,?,?,?)");
            for (int i = 1; i <= 6; ++i) {
                prepStatement.setInt(1, 1);
                prepStatement.setTimestamp(2, currT);
                prepStatement.setTimestamp(3, currT);
                prepStatement.setTimestamp(4, currT);
                prepStatement.addBatch();
            }
            prepStatement.executeBatch();
            ResultSet rs1 = statement.executeQuery("select * from stageinsert");
            ResultSet rs2 = statement.executeQuery("select * from regularinsert");
            rs1.next();
            rs2.next();
            Assert.assertEquals((long)rs1.getInt(1), (long)rs2.getInt(1));
            Assert.assertEquals((Object)rs1.getString(2), (Object)rs2.getString(2));
            Assert.assertEquals((Object)rs1.getString(3), (Object)rs2.getString(3));
            Assert.assertEquals((Object)rs1.getString(4), (Object)rs2.getString(4));
            statement.execute("drop table if exists stageinsert");
            statement.execute("drop table if exists regularinsert");
            TimeZone.setDefault(origTz);
            statement.close();
            prepStatement.close();
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testTimestampBindingWithLTZType() throws SQLException {
        try (Connection connection = BindingDataLatestIT.getConnection();){
            TimeZone origTz = TimeZone.getDefault();
            Statement statement = connection.createStatement();
            statement.execute("create or replace table stageinsert(ind int, ltz0 timestamp_ltz, tz0 timestamp_tz, ntz0 timestamp_ntz)");
            statement.execute("create or replace table regularinsert(ind int, ltz0 timestamp_ltz, tz0 timestamp_tz, ntz0 timestamp_ntz)");
            statement.execute("alter session set CLIENT_TIMESTAMP_TYPE_MAPPING=TIMESTAMP_LTZ");
            statement.execute("alter session set TIMEZONE='Asia/Tokyo'");
            TimeZone.setDefault(TimeZone.getTimeZone("Asia/Tokyo"));
            Timestamp currT = new Timestamp(System.currentTimeMillis());
            PreparedStatement prepStatement = connection.prepareStatement("insert into stageinsert values (?,?,?,?)");
            statement.execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 1");
            prepStatement.setInt(1, 1);
            prepStatement.setTimestamp(2, currT);
            prepStatement.setTimestamp(3, currT);
            prepStatement.setTimestamp(4, currT);
            prepStatement.addBatch();
            prepStatement.executeBatch();
            statement.execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 0");
            prepStatement = connection.prepareStatement("insert into regularinsert values (?,?,?,?)");
            for (int i = 1; i <= 6; ++i) {
                prepStatement.setInt(1, 1);
                prepStatement.setTimestamp(2, currT);
                prepStatement.setTimestamp(3, currT);
                prepStatement.setTimestamp(4, currT);
                prepStatement.addBatch();
            }
            prepStatement.executeBatch();
            ResultSet rs1 = statement.executeQuery("select * from stageinsert");
            ResultSet rs2 = statement.executeQuery("select * from regularinsert");
            rs1.next();
            rs2.next();
            Assert.assertEquals((long)rs1.getInt(1), (long)rs2.getInt(1));
            Assert.assertEquals((Object)rs1.getString(2), (Object)rs2.getString(2));
            Assert.assertEquals((Object)rs1.getString(3), (Object)rs2.getString(3));
            Assert.assertEquals((Object)rs1.getString(4), (Object)rs2.getString(4));
            statement.execute("drop table if exists stageinsert");
            statement.execute("drop table if exists regularinsert");
            TimeZone.setDefault(origTz);
            statement.close();
            prepStatement.close();
        }
    }
}

