/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.snowflake.client.category.TestCategoryStatement;
import net.snowflake.client.jdbc.CallableStatementIT;
import net.snowflake.client.jdbc.SnowflakeCallableStatementV1;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryStatement.class})
public class CallableStatementLatestIT
extends CallableStatementIT {
    public CallableStatementLatestIT(String format) {
        super(format);
    }

    @Test
    public void testParseSqlEscapeSyntaxFunction() {
        String[] callStatements = new String[]{"{call square_it(5)}", "call no_bracket_function(44)", "call {bracket_function(a=?)}"};
        String[] expectedStatements = new String[]{"call square_it(5)", "call no_bracket_function(44)", "call {bracket_function(a=?)}"};
        for (int i = 0; i < callStatements.length; ++i) {
            Assert.assertEquals((Object)expectedStatements[i], (Object)SnowflakeCallableStatementV1.parseSqlEscapeSyntax((String)callStatements[i]));
        }
    }

    @Test
    public void testPrepareCallWithCurlyBracketSyntax() throws SQLException {
        this.connection = CallableStatementLatestIT.getConnection();
        this.statement = this.connection.createStatement();
        CallableStatement callableStatement = this.connection.prepareCall("{call square_it(5)}");
        MatcherAssert.assertThat((Object)callableStatement.getParameterMetaData().getParameterCount(), (Matcher)CoreMatchers.is((Object)0));
        callableStatement = this.connection.prepareCall("{call square_it(?)}");
        MatcherAssert.assertThat((Object)callableStatement.getParameterMetaData().getParameterType(1), (Matcher)CoreMatchers.is((Object)12));
        callableStatement.getParameterMetaData().getParameterTypeName(1);
        MatcherAssert.assertThat((Object)callableStatement.getParameterMetaData().getParameterTypeName(1), (Matcher)CoreMatchers.is((Object)"text"));
        callableStatement.setFloat(1, 7.0f);
        ResultSet rs = callableStatement.executeQuery();
        rs.next();
        Assert.assertEquals((float)49.0f, (float)rs.getFloat(1), (float)1.0f);
        callableStatement = this.connection.prepareCall("{call add_nums(?,?)}");
        callableStatement.setDouble(1, 32.0);
        callableStatement.setDouble(2, 15.0);
        rs = callableStatement.executeQuery();
        rs.next();
        Assert.assertEquals((double)47.0, (double)rs.getDouble(1), (double)0.5);
    }
}

