/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.category.TestCategoryOthers;
import net.snowflake.client.core.ExecTimeTelemetryData;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFStatement;
import net.snowflake.client.jdbc.ChunkDownloadContext;
import net.snowflake.client.jdbc.RestRequest;
import net.snowflake.client.jdbc.SnowflakeChunkDownloader;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeResultChunk;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializable;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializableV1;
import net.snowflake.client.jdbc.SnowflakeStatementV1;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryOthers.class})
public class ChunkDownloaderS3RetryUrlLatestIT
extends AbstractDriverIT {
    private Connection connection;
    private SFStatement sfStatement;
    private SFBaseSession sfBaseSession;
    private ChunkDownloadContext sfContext;

    @Before
    public void setup() throws SQLException, InterruptedException {
        this.connection = ChunkDownloaderS3RetryUrlLatestIT.getConnection();
        this.sfBaseSession = this.connection.unwrap(SnowflakeConnectionV1.class).getSFBaseSession();
        Statement statement = this.connection.createStatement();
        this.sfStatement = statement.unwrap(SnowflakeStatementV1.class).getSfStatement();
        int rowCount = 170000;
        ResultSet rs = statement.executeQuery("select randstr(100, random()) from table(generator(rowcount => " + rowCount + "))");
        List resultSetSerializables = ((SnowflakeResultSet)rs).getResultSetSerializables(0x6400000L);
        SnowflakeResultSetSerializable resultSetSerializable = (SnowflakeResultSetSerializable)resultSetSerializables.get(0);
        SnowflakeChunkDownloader downloader = new SnowflakeChunkDownloader((SnowflakeResultSetSerializableV1)resultSetSerializable);
        SnowflakeResultChunk chunk = downloader.getNextChunkToConsume();
        String qrmk = ((SnowflakeResultSetSerializableV1)resultSetSerializable).getQrmk();
        Map chunkHeadersMap = ((SnowflakeResultSetSerializableV1)resultSetSerializable).getChunkHeadersMap();
        this.sfContext = new ChunkDownloadContext(downloader, chunk, qrmk, 0, chunkHeadersMap, 0, 0, 0, 7, this.sfBaseSession);
    }

    @Test
    public void testParamsInRetryS3Url() throws Exception {
        HttpGet getRequest = new HttpGet(new URIBuilder(this.sfContext.getResultChunk().getUrl()).build());
        CloseableHttpClient httpClient = HttpUtil.getHttpClient((HttpClientSettingsKey)this.sfContext.getChunkDownloader().getHttpClientSettingsKey());
        for (Map.Entry entry : this.sfContext.getChunkHeadersMap().entrySet()) {
            getRequest.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        RestRequest.execute((CloseableHttpClient)httpClient, (HttpRequestBase)getRequest, (long)(this.sfContext.getNetworkTimeoutInMilli() / 1000), (long)this.sfContext.getAuthTimeout(), (int)this.sfContext.getSocketTimeout(), (int)1, (int)0, null, (boolean)false, (boolean)false, (boolean)false, (boolean)true, (ExecTimeTelemetryData)new ExecTimeTelemetryData());
        Assert.assertFalse((boolean)getRequest.containsHeader("retryCount"));
        Assert.assertFalse((boolean)getRequest.containsHeader("retryReason"));
        Assert.assertFalse((boolean)getRequest.containsHeader("clientStartTime"));
        Assert.assertFalse((boolean)getRequest.containsHeader("request_guid"));
    }
}

