/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.category.TestCategoryOthers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={TestCategoryOthers.class})
public class ClientMemoryLimitParallelIT {
    private static Logger LOGGER = LoggerFactory.getLogger((String)ClientMemoryLimitParallelIT.class.getName());
    private static final int rowCount = 10000;
    private static final String createTestTableSQL = "create or replace table testtable_cml \n(c1 number, c2 number, c3 number, c4 number,\nc5 number, c6 number, c7 number, c8 number,\nc9 number, c10 number, c11 number, c12 number,\nc13 text, c14 text, c15 text, c16 text, c17 text, c18 text, c19 text, c20 text, c21 text, c22 text,\nc23 text, c24 text, c25 text, c26 text, c27 text, c28 text, c29 text, c30 text, c31 text, c32 text,\nc33 text, c34 text, c35 text, c36 text, c37 text, c38 text, c39 text, c40 text, c41 text, c42 text,\nc43 text, c44 text, c45 text, c46 text, c47 text, c48 text, c49 text, c50 text, c51 text, c52 text,\nc53 text, c54 text, c55 text, c56 text, c57 text, c58 text, c59 text, c60 text)\nas\nselect \nseq1(), seq2()+10, seq4()+100, seq8()+1000, \nseq1(), seq2()+10, seq4()+100, seq8()+1000, \nseq1(), seq2()+10, seq4()+100, seq8()+1000, \nrandom(),random(1),random(10),random(100),\nrandom(),random(1),random(10),random(100),\nrandom(),random(1),random(10),random(100),\nrandom(),random(1),random(10),random(100),\nrandom(),random(1),random(10),random(100),\nrandom(),random(1),random(10),random(100),\nrandom(),random(1),random(10),random(100),\nrandom(),random(1),random(10),random(100),\nrandom(),random(1),random(10),random(100),\nrandom(),random(1),random(10),random(100),\nrandom(),random(1),random(10),random(100),\nrandom(),random(1),random(10),random(100)\nfrom table(generator(rowcount => 10000));";

    @Before
    public void setUp() throws SQLException {
        Connection con = AbstractDriverIT.getConnection();
        con.createStatement().execute(createTestTableSQL);
        con.close();
    }

    @After
    public void tearDown() throws SQLException {
        Connection con = AbstractDriverIT.getConnection();
        con.createStatement().execute("drop table if exists testtable_cml");
        con.close();
    }

    @Test
    @Ignore(value="Long term high memory usage test")
    public void testParallelQueries() throws Exception {
        Runnable testQuery = new Runnable(){

            @Override
            public void run() {
                try {
                    Properties paramProperties = new Properties();
                    Connection connection = AbstractDriverIT.getConnection(paramProperties);
                    Statement statement = connection.createStatement();
                    ClientMemoryLimitParallelIT.queryRows(statement, 100, 48);
                    statement.close();
                    connection.close();
                }
                catch (SQLException e) {
                    Assert.assertEquals(null, (Object)e);
                }
            }
        };
        Thread t1 = new Thread(testQuery);
        Thread t2 = new Thread(testQuery);
        Thread t3 = new Thread(testQuery);
        Thread t4 = new Thread(testQuery);
        Thread t5 = new Thread(testQuery);
        t1.start();
        t2.start();
        t3.start();
        t4.start();
        t5.start();
        t1.join();
        t2.join();
        t3.join();
        t4.join();
        t5.join();
    }

    @Test
    public void testQueryNotHanging() throws SQLException {
        Properties paramProperties = new Properties();
        Connection connection = AbstractDriverIT.getConnection(paramProperties);
        Statement statement = connection.createStatement();
        ClientMemoryLimitParallelIT.queryRows(statement, 100, 160);
        statement.close();
        connection.close();
    }

    private static void queryRows(Statement stmt, int limit, int chunkSize) throws SQLException {
        stmt.execute("alter session set CLIENT_MEMORY_LIMIT=" + limit);
        stmt.execute("alter session set CLIENT_RESULT_CHUNK_SIZE=" + chunkSize);
        String query = "select * from testtable_cml";
        ResultSet resultSet = stmt.executeQuery(query);
        int rowIdx = 0;
        while (resultSet.next()) {
            if (++rowIdx % 1000 != 0) continue;
            LOGGER.info(Thread.currentThread().getName() + ": processedRows: " + rowIdx);
        }
        Assert.assertEquals((long)rowIdx, (long)10000L);
        resultSet.close();
    }
}

