/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.util.Properties;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.jdbc.SnowflakeConnectString;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class ConnectStringParseTest {
    @Test
    public void testParseAccountName() throws SnowflakeSQLException {
        Properties info = new Properties();
        info.setProperty("username", "test");
        String jdbcConnectString = "jdbc:snowflake://abc.us-east-1.snowflakecomputing.com";
        SnowflakeConnectString cstring = SnowflakeConnectString.parse((String)jdbcConnectString, (Properties)info);
        MatcherAssert.assertThat(cstring.getParameters().get(SFSessionProperty.ACCOUNT.getPropertyKey().toUpperCase()), (Matcher)CoreMatchers.is((Object)"abc"));
        jdbcConnectString = "jdbc:snowflake://abc_test.us-east-1.snowflakecomputing.com";
        cstring = SnowflakeConnectString.parse((String)jdbcConnectString, (Properties)info);
        MatcherAssert.assertThat(cstring.getParameters().get(SFSessionProperty.ACCOUNT.getPropertyKey().toUpperCase()), (Matcher)CoreMatchers.is((Object)"abc_test"));
        MatcherAssert.assertThat((Object)cstring.getHost(), (Matcher)CoreMatchers.is((Object)"abc-test.us-east-1.snowflakecomputing.com"));
        jdbcConnectString = "jdbc:snowflake://abc-test.us-east-1.snowflakecomputing.com";
        cstring = SnowflakeConnectString.parse((String)jdbcConnectString, (Properties)info);
        MatcherAssert.assertThat(cstring.getParameters().get(SFSessionProperty.ACCOUNT.getPropertyKey().toUpperCase()), (Matcher)CoreMatchers.is((Object)"abc-test"));
        MatcherAssert.assertThat((Object)cstring.getHost(), (Matcher)CoreMatchers.is((Object)"abc-test.us-east-1.snowflakecomputing.com"));
        jdbcConnectString = "jdbc:snowflake://abc_test.us-east-1.snowflakecomputing.com";
        info.setProperty(SFSessionProperty.ALLOW_UNDERSCORES_IN_HOST.getPropertyKey(), "false");
        cstring = SnowflakeConnectString.parse((String)jdbcConnectString, (Properties)info);
        MatcherAssert.assertThat(cstring.getParameters().get(SFSessionProperty.ACCOUNT.getPropertyKey().toUpperCase()), (Matcher)CoreMatchers.is((Object)"abc_test"));
        MatcherAssert.assertThat((Object)cstring.getHost(), (Matcher)CoreMatchers.is((Object)"abc-test.us-east-1.snowflakecomputing.com"));
        jdbcConnectString = "jdbc:snowflake://abc-test.us-east-1.snowflakecomputing.com";
        cstring = SnowflakeConnectString.parse((String)jdbcConnectString, (Properties)info);
        MatcherAssert.assertThat(cstring.getParameters().get(SFSessionProperty.ACCOUNT.getPropertyKey().toUpperCase()), (Matcher)CoreMatchers.is((Object)"abc-test"));
        MatcherAssert.assertThat((Object)cstring.getHost(), (Matcher)CoreMatchers.is((Object)"abc-test.us-east-1.snowflakecomputing.com"));
        info.setProperty("ACCOUNT", "abc_test");
        cstring = SnowflakeConnectString.parse((String)jdbcConnectString, (Properties)info);
        MatcherAssert.assertThat(cstring.getParameters().get(SFSessionProperty.ACCOUNT.getPropertyKey().toUpperCase()), (Matcher)CoreMatchers.is((Object)"abc_test"));
        MatcherAssert.assertThat((Object)cstring.getHost(), (Matcher)CoreMatchers.is((Object)"abc-test.us-east-1.snowflakecomputing.com"));
    }

    @Test
    public void testParseWithIllegalUriCharacters() {
        Properties info = new Properties();
        String jdbcConnectString = "jdbc:snowflake://abc-test.us-east-1.snowflakecomputing.com/?private_key_file=C:\\temp\\rsa_key.p8&private_key_file_pwd=test_password&user=test_user";
        SnowflakeConnectString cstring = SnowflakeConnectString.parse((String)jdbcConnectString, (Properties)info);
        Assert.assertEquals((Object)"://:-1", (Object)cstring.toString());
    }
}

