/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.HashMap;
import net.snowflake.client.category.TestCategoryConnection;
import net.snowflake.client.jdbc.BaseJDBCTest;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryConnection.class})
public class ConnectionFeatureNotSupportedIT
extends BaseJDBCTest {
    @Test
    public void testFeatureNotSupportedException() throws Throwable {
        try (Connection connection = ConnectionFeatureNotSupportedIT.getConnection();){
            this.expectFeatureNotSupportedException(() -> connection.rollback(new FakeSavepoint()));
            this.expectFeatureNotSupportedException(() -> connection.setTransactionIsolation(8));
            this.expectFeatureNotSupportedException(() -> connection.setTransactionIsolation(4));
            this.expectFeatureNotSupportedException(() -> connection.prepareStatement("select 1", new int[]{1, 2}));
            this.expectFeatureNotSupportedException(() -> connection.prepareStatement("select 1", new String[]{"c1", "c2"}));
            this.expectFeatureNotSupportedException(() -> connection.prepareStatement("select 1", 1005, 1007));
            this.expectFeatureNotSupportedException(() -> connection.createStatement(1005, 1007));
            this.expectFeatureNotSupportedException(() -> connection.setTypeMap(new HashMap()));
            this.expectFeatureNotSupportedException(connection::setSavepoint);
            this.expectFeatureNotSupportedException(() -> connection.setSavepoint("fake"));
            this.expectFeatureNotSupportedException(() -> connection.releaseSavepoint(new FakeSavepoint()));
            this.expectFeatureNotSupportedException(connection::createBlob);
            this.expectFeatureNotSupportedException(connection::createNClob);
            this.expectFeatureNotSupportedException(connection::createSQLXML);
            this.expectFeatureNotSupportedException(() -> connection.createArrayOf("fakeType", new Object[0]));
            this.expectFeatureNotSupportedException(() -> connection.createStruct("fakeType", new Object[0]));
        }
    }

    class FakeSavepoint
    implements Savepoint {
        FakeSavepoint() {
        }

        @Override
        public int getSavepointId() throws SQLException {
            return 0;
        }

        @Override
        public String getSavepointName() throws SQLException {
            return "";
        }
    }
}

